<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            // Renomear coluna grupo_equipamentos_id para empresa_alcance_id
            $table->renameColumn('grupo_equipamentos_id', 'empresa_alcance_id');
        });
        
        // Atualizar enum para usar 'empresa' ao invés de 'grupo'
        DB::statement("ALTER TABLE publicacoes MODIFY COLUMN tipo_alcance ENUM('todos', 'serial_especifico', 'empresa') DEFAULT 'todos'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            // Reverter nome da coluna
            $table->renameColumn('empresa_alcance_id', 'grupo_equipamentos_id');
        });
        
        // Reverter enum
        DB::statement("ALTER TABLE publicacoes MODIFY COLUMN tipo_alcance ENUM('todos', 'serial_especifico', 'grupo') DEFAULT 'todos'");
    }
};
