<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            // Campos de tracking e clique
            $table->string('link_destino', 500)->nullable()->after('data_fim');
            $table->boolean('habilitar_clique')->default(false)->after('link_destino');
            $table->boolean('track_impressoes')->default(true)->after('habilitar_clique');
            $table->boolean('track_cliques')->default(true)->after('track_impressoes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            $table->dropColumn(['link_destino', 'habilitar_clique', 'track_impressoes', 'track_cliques']);
        });
    }
};
