<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('publicacao_impressoes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('hotspot_id')->constrained('hotspots')->onDelete('cascade');
            $table->foreignId('publicacao_id')->constrained('publicacoes')->onDelete('cascade');
            $table->foreignId('criativo_id')->constrained('criativos')->onDelete('cascade');
            $table->date('data');
            $table->integer('impressoes')->default(0);
            $table->integer('usuarios_unicos')->default(0);
            $table->timestamps();
            
            // Índice único para evitar duplicação
            $table->unique(['hotspot_id', 'publicacao_id', 'criativo_id', 'data'], 'impressoes_unique');
            
            // Índices para queries
            $table->index(['publicacao_id', 'data']);
            $table->index(['hotspot_id', 'data']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('publicacao_impressoes');
    }
};
