<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hotspot_customizations', function (Blueprint $table) {
            $table->id();

            // Relacionamento com hotspot
            $table->foreignId('hotspot_id')->constrained('hotspots')->onDelete('cascade');
            $table->unique('hotspot_id', 'unique_hotspot_customization');

            // =========================================
            // 🎨 IDENTIDADE VISUAL
            // =========================================
            $table->string('brand_name', 100)->default('freefi.com.br')->comment('Nome da marca exibido');
            $table->string('logo_url', 255)->default('img/logo.png')->comment('URL do logo');
            $table->string('favicon_url', 255)->nullable()->comment('URL do favicon');

            // =========================================
            // 🎨 CORES - Background Gradient (4 cores)
            // =========================================
            $table->string('bg_color_1', 50)->default('hsla(236.6,0%,53.52%,1)')->comment('Cor 1 do gradient');
            $table->string('bg_color_2', 50)->default('hsla(220.75,34.93%,26.52%,1)')->comment('Cor 2 do gradient');
            $table->string('bg_color_3', 50)->default('hsla(46.42,36.62%,83.92%,1)')->comment('Cor 3 do gradient');
            $table->string('bg_color_4', 50)->default('hsla(191.32,50.68%,56.45%,1)')->comment('Cor 4 do gradient');

            // =========================================
            // 🎨 CORES - Elementos
            // =========================================
            $table->string('primary_color', 20)->default('#3e4d59')->comment('Cor primária (botões)');
            $table->string('primary_hover_color', 20)->default('#33404a')->comment('Cor hover dos botões');
            $table->string('text_color', 20)->default('#fff')->comment('Cor do texto principal');
            $table->string('link_color', 20)->default('#486173')->comment('Cor dos links');

            // =========================================
            // 📝 TEXTOS PERSONALIZÁVEIS
            // =========================================
            $table->string('welcome_title', 100)->default('O Seu Wifi Grátis')->comment('Título da página inicial');
            $table->string('login_title', 100)->default('freefi.com.br')->comment('Título da página de login');
            $table->string('register_title', 100)->default('Cadastro de Usuário')->comment('Título do cadastro');
            $table->string('status_title', 100)->default('Você está conectado!')->comment('Título da página de status');

            // =========================================
            // 🔘 BOTÕES
            // =========================================
            $table->string('btn_first_access', 50)->default('1º Acesso')->comment('Texto botão primeiro acesso');
            $table->string('btn_login', 50)->default('Login')->comment('Texto botão login');
            $table->string('btn_connect', 50)->default('Conectar')->comment('Texto botão conectar');
            $table->string('btn_disconnect', 50)->default('Desconectar')->comment('Texto botão desconectar');

            // =========================================
            // 📱 PLACEHOLDERS DOS CAMPOS
            // =========================================
            $table->string('placeholder_username', 50)->default('cpf / login')->comment('Placeholder do campo usuário');
            $table->string('placeholder_password', 50)->default('senha')->comment('Placeholder senha');
            $table->string('placeholder_name', 50)->default('Nome')->comment('Placeholder nome');
            $table->string('placeholder_email', 50)->default('Email')->comment('Placeholder email');
            $table->string('placeholder_phone', 50)->default('Telefone')->comment('Placeholder telefone');

            // =========================================
            // ⏱️ TEMPOS E COMPORTAMENTO
            // =========================================
            $table->integer('modal_countdown_seconds')->default(10)->comment('Tempo countdown propaganda (segundos)');
            $table->integer('banner_rotation_seconds')->default(5)->comment('Tempo cada banner (segundos)');
            $table->integer('status_refresh_seconds')->default(60)->comment('Tempo refresh página status');

            // =========================================
            // 📢 PROPAGANDA
            // =========================================
            $table->boolean('enable_advertisement')->default(true)->comment('Habilitar propaganda modal');

            // =========================================
            // 🌐 URLS E REDIRECIONAMENTOS
            // =========================================
            $table->string('terms_url', 255)->nullable()->comment('URL dos termos de uso');
            $table->string('privacy_url', 255)->nullable()->comment('URL da política de privacidade');
            $table->string('support_url', 255)->nullable()->comment('URL do suporte');
            $table->string('redirect_after_login', 255)->default('http://freefi.com.br')->comment('URL após login');

            // =========================================
            // 📊 CAMPOS CUSTOMIZÁVEIS DO FORMULÁRIO
            // =========================================
            $table->boolean('require_name')->default(true)->comment('Exigir nome no cadastro');
            $table->boolean('require_email')->default(true)->comment('Exigir email no cadastro');
            $table->boolean('require_phone')->default(true)->comment('Exigir telefone no cadastro');
            $table->boolean('require_birth_date')->default(false)->comment('Exigir data nascimento');
            $table->boolean('require_address')->default(false)->comment('Exigir endereço');

            // =========================================
            // 🎭 TEMAS PRÉ-DEFINIDOS
            // =========================================
            $table->enum('theme_preset', ['default', 'lite', 'dark', 'custom'])->default('default')->comment('Tema visual');

            // =========================================
            // 🔧 CONFIGURAÇÕES TÉCNICAS
            // =========================================
            $table->boolean('enable_cpf_mask')->default(true)->comment('Habilitar máscara CPF');
            $table->boolean('enable_phone_mask')->default(true)->comment('Habilitar máscara telefone');
            $table->boolean('enable_password_hash')->default(true)->comment('Habilitar hash MD5 senha');

            // =========================================
            // 📝 INFORMAÇÕES EXIBIDAS NA PÁGINA STATUS
            // =========================================
            $table->boolean('show_hotspot_identity')->default(true)->comment('Mostrar identity do hotspot');
            $table->boolean('show_mac_address')->default(true)->comment('Mostrar MAC do cliente');
            $table->boolean('show_ip_address')->default(true)->comment('Mostrar IP do cliente');
            $table->boolean('show_upload_download')->default(true)->comment('Mostrar tráfego up/down');
            $table->boolean('show_session_time')->default(true)->comment('Mostrar tempo de sessão');

            // =========================================
            // 🎨 CSS/JS CUSTOMIZADO (Tag Manager Style)
            // =========================================
            $table->text('custom_css')->nullable()->comment('CSS personalizado injetado no <head>');
            $table->text('custom_js')->nullable()->comment('JavaScript personalizado injetado antes do </body>');
            $table->text('custom_head_html')->nullable()->comment('HTML adicional no <head> (meta tags, scripts)');
            $table->text('custom_body_html')->nullable()->comment('HTML adicional no início do <body>');

            // =========================================
            // 🗓️ CONTROLE E AUDITORIA
            // =========================================
            $table->boolean('is_active')->default(true)->comment('Customização ativa');
            $table->timestamps();
            $table->softDeletes();

            // Campos de auditoria (created_by, updated_by, deleted_by)
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('deleted_by')->nullable()->constrained('users')->onDelete('set null');

            // Índices
            $table->index('is_active');
            $table->index('theme_preset');
            $table->index(['hotspot_id', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotspot_customizations');
    }
};
