<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('empresa_user', function (Blueprint $table) {
            $table->id();

            // Foreign Keys
            $table->foreignId('user_id')
                ->constrained('users')
                ->onDelete('cascade');

            $table->foreignId('empresa_id')
                ->constrained('empresas')
                ->onDelete('cascade');

            // Role do usuário nesta empresa (opcional - para uso futuro)
            $table->enum('role', ['gestor', 'operador', 'visualizador'])
                ->default('gestor')
                ->comment('Papel do usuário nesta empresa específica');

            // Timestamps
            $table->timestamps();

            // Indexes
            $table->unique(['user_id', 'empresa_id'], 'user_empresa_unique');
            $table->index('user_id');
            $table->index('empresa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('empresa_user');
    }
};
