<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            // Status de aprovação do hotspot
            $table->enum('status_aprovacao', ['pendente', 'aprovado', 'rejeitado'])
                  ->default('pendente')
                  ->after('situacao');

            // Quem aprovou
            $table->foreignId('aprovado_por')
                  ->nullable()
                  ->after('status_aprovacao')
                  ->constrained('users')
                  ->nullOnDelete();

            // Data de aprovação
            $table->timestamp('aprovado_em')
                  ->nullable()
                  ->after('aprovado_por');

            // Motivo da rejeição (se aplicável)
            $table->text('motivo_rejeicao')
                  ->nullable()
                  ->after('aprovado_em');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            $table->dropForeign(['aprovado_por']);
            $table->dropColumn([
                'status_aprovacao',
                'aprovado_por',
                'aprovado_em',
                'motivo_rejeicao'
            ]);
        });
    }
};
