<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->string('token_convite', 64)->nullable()->unique()->after('status');
        });

        // Gerar tokens para franquias existentes
        DB::statement("UPDATE empresas SET token_convite = MD5(CONCAT(id, name, UNIX_TIMESTAMP())) WHERE tipo_empresa = 'franquia' AND token_convite IS NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->dropColumn('token_convite');
        });
    }
};
