<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            // Status de aprovação do cadastro (apenas para clientes)
            $table->enum('status_aprovacao', ['pendente', 'aprovado', 'rejeitado'])
                  ->default('aprovado')
                  ->after('status');

            // Quem aprovou
            $table->foreignId('aprovado_por')
                  ->nullable()
                  ->after('status_aprovacao')
                  ->constrained('users')
                  ->nullOnDelete();

            // Data de aprovação
            $table->timestamp('aprovado_em')
                  ->nullable()
                  ->after('aprovado_por');

            // Motivo da rejeição (se aplicável)
            $table->text('motivo_rejeicao')
                  ->nullable()
                  ->after('aprovado_em');
        });

        // Aprovar automaticamente franquias e matrizes existentes
        DB::statement("UPDATE empresas SET status_aprovacao = 'aprovado' WHERE tipo_empresa IN ('franquia', 'matriz')");

        // Aprovar automaticamente clientes existentes
        DB::statement("UPDATE empresas SET status_aprovacao = 'aprovado' WHERE tipo_empresa = 'cliente'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->dropForeign(['aprovado_por']);
            $table->dropColumn([
                'status_aprovacao',
                'aprovado_por',
                'aprovado_em',
                'motivo_rejeicao'
            ]);
        });
    }
};
