<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('configuracao_precos', function (Blueprint $table) {
            $table->id();
            $table->string('chave')->unique()->comment('Chave de configuração (ex: preco_semanal, preco_mensal)');
            $table->string('nome')->comment('Nome descritivo da configuração');
            $table->decimal('valor', 10, 2)->comment('Valor em reais');
            $table->text('descricao')->nullable()->comment('Descrição detalhada');
            $table->boolean('ativo')->default(true)->comment('Se a configuração está ativa');
            $table->timestamps();
        });

        // Inserir valores padrão
        DB::table('configuracao_precos')->insert([
            [
                'chave' => 'preco_semanal',
                'nome' => 'Publicidade Semanal',
                'valor' => 150.00,
                'descricao' => 'Valor para publicidade por 1 semana',
                'ativo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'chave' => 'preco_mensal',
                'nome' => 'Publicidade Mensal',
                'valor' => 600.00,
                'descricao' => 'Valor para publicidade por 1 mês (4 semanas)',
                'ativo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'chave' => 'multiplicador_mensal',
                'nome' => 'Multiplicador Mensal',
                'valor' => 4.00,
                'descricao' => 'Quantidade de semanas em um mês',
                'ativo' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('configuracao_precos');
    }
};
