<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos_publicidade', function (Blueprint $table) {
            $table->id();
            $table->string('codigo_pedido')->unique()->comment('Código único do pedido');

            // Dados da empresa
            $table->foreignId('empresa_id')->constrained('empresas')->onDelete('cascade');
            $table->string('codigo_empresa')->comment('Código da empresa fornecido no wizard');

            // Criativo
            $table->string('arquivo_criativo')->comment('Caminho do arquivo do criativo');
            $table->string('nome_criativo')->nullable();
            $table->string('tipo_arquivo')->nullable()->comment('Tipo MIME do arquivo');

            // Seleção de Hotspots
            $table->enum('tipo_selecao', ['individual', 'franquia_completa', 'multiplas_franquias'])->comment('Tipo de seleção de hotspots');
            $table->json('hotspots_selecionados')->nullable()->comment('IDs dos hotspots selecionados');
            $table->json('franquias_selecionadas')->nullable()->comment('IDs das franquias selecionadas');

            // Datas
            $table->date('data_inicio')->comment('Data de início da publicação');
            $table->date('data_fim')->comment('Data de término da publicação');

            // Posição e Periodicidade
            $table->integer('posicao')->default(1)->comment('Posição do anúncio (1-5)');
            $table->enum('periodicidade', ['semanal', 'mensal'])->comment('Periodicidade da publicidade');

            // Valores
            $table->decimal('valor_unitario', 10, 2)->comment('Valor unitário do período');
            $table->integer('quantidade_hotspots')->default(1)->comment('Quantidade de hotspots');
            $table->decimal('valor_total', 10, 2)->comment('Valor total do pedido');

            // Pagamento
            $table->enum('status_pagamento', ['pendente', 'aprovado', 'rejeitado', 'cancelado'])->default('pendente');
            $table->string('forma_pagamento')->nullable()->comment('Forma de pagamento escolhida');
            $table->string('transaction_id')->nullable()->comment('ID da transação do gateway');
            $table->text('dados_pagamento')->nullable()->comment('Dados adicionais do pagamento (JSON)');
            $table->timestamp('pago_em')->nullable();

            // Status do Pedido
            $table->enum('status', ['rascunho', 'aguardando_pagamento', 'aprovado', 'publicado', 'cancelado'])->default('rascunho');

            // Observações
            $table->text('observacoes')->nullable();

            // Auditoria
            $table->foreignId('criado_por')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('aprovado_por')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('aprovado_em')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos_publicidade');
    }
};
