<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->string('codigo')->unique()->nullable()->after('id')->comment('Código único da empresa para compra de publicidade');
        });

        // Gerar códigos únicos para empresas existentes
        $empresas = DB::table('empresas')->get();
        foreach ($empresas as $empresa) {
            $codigo = 'EMP' . str_pad($empresa->id, 6, '0', STR_PAD_LEFT);
            DB::table('empresas')
                ->where('id', $empresa->id)
                ->update(['codigo' => $codigo]);
        }

        // Tornar o campo obrigatório após gerar códigos
        Schema::table('empresas', function (Blueprint $table) {
            $table->string('codigo')->nullable(false)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->dropColumn('codigo');
        });
    }
};
