<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('midias_pedido', function (Blueprint $table) {
            $table->id();

            // Relacionamentos
            $table->foreignId('pedido_id')->constrained('pedidos_publicidade')->onDelete('cascade')
                ->comment('Pedido de origem');
            $table->foreignId('criativo_id')->nullable()->constrained('criativos')->onDelete('set null')
                ->comment('Criativo oficial criado após aprovação');

            // Dados da Mídia
            $table->string('titulo')->comment('Título do criativo');
            $table->string('arquivo')->comment('Caminho do arquivo criativo');
            $table->string('tipo_arquivo')->nullable()->comment('MIME type');
            $table->integer('duracao')->nullable()->comment('Duração em segundos (para vídeos)');
            $table->string('dimensoes')->nullable()->comment('Largura x Altura (ex: 1920x1080)');
            $table->bigInteger('tamanho_arquivo')->nullable()->comment('Tamanho em bytes');

            // Status
            $table->enum('status', ['pendente', 'aprovado', 'rejeitado', 'publicado'])->default('pendente');

            // Aprovação
            $table->foreignId('aprovado_por')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('aprovado_em')->nullable();
            $table->text('observacoes')->nullable();
            $table->text('motivo_rejeicao')->nullable();

            // Auditoria
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('deleted_by')->nullable()->constrained('users')->onDelete('set null');

            $table->timestamps();
            $table->softDeletes();

            // Índices
            $table->index('pedido_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('midias_pedido');
    }
};
