<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            // Adiciona relacionamento com pedidos_publicidade (nullable)
            $table->foreignId('pedido_id')
                ->nullable()
                ->after('id')
                ->constrained('pedidos_publicidade')
                ->onDelete('set null')
                ->comment('Pedido de origem da landing page');

            // Adiciona índice para performance
            $table->index('pedido_id');
        });

        // Modifica o enum status para incluir 'pendente_configuracao'
        DB::statement("ALTER TABLE publicacoes MODIFY COLUMN status ENUM('ativa', 'pausada', 'expirada', 'cancelada', 'pendente_configuracao') NOT NULL DEFAULT 'ativa'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Reverte o enum status para os valores originais
        DB::statement("ALTER TABLE publicacoes MODIFY COLUMN status ENUM('ativa', 'pausada', 'expirada', 'cancelada') NOT NULL DEFAULT 'ativa'");

        Schema::table('publicacoes', function (Blueprint $table) {
            // Remove o índice
            $table->dropIndex(['pedido_id']);

            // Remove a foreign key e a coluna
            $table->dropForeign(['pedido_id']);
            $table->dropColumn('pedido_id');
        });
    }
};
