<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            // Adicionar campos após deleted_by (última coluna existente em produção)
            $table->text('mp_access_token')->nullable();
            $table->string('mp_public_key')->nullable();
            $table->boolean('mp_ativo')->default(false);
            $table->boolean('mp_split_habilitado')->default(false);
            $table->decimal('mp_percentual_split', 5, 2)->nullable();
            $table->foreignId('mp_empresa_split_id')->nullable()->constrained('empresas')->nullOnDelete();
            $table->enum('mp_ambiente', ['sandbox', 'production'])->default('sandbox');
        });
    }

    public function down(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->dropForeign(['mp_empresa_split_id']);
            $table->dropColumn([
                'mp_access_token',
                'mp_public_key',
                'mp_ativo',
                'mp_split_habilitado',
                'mp_percentual_split',
                'mp_empresa_split_id',
                'mp_ambiente',
            ]);
        });
    }
};
