<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            // Adicionar código do cliente (empresa) onde o hotspot está instalado
            $table->string('cod_cliente', 20)->nullable()->after('cliente_id');

            // Adicionar código da franquia à qual a empresa pertence
            $table->string('cod_franquia', 20)->nullable()->after('cod_cliente');

            // Adicionar índice para melhorar performance de consultas
            $table->index('cod_cliente');
            $table->index('cod_franquia');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('hotspots', function (Blueprint $table) {
            // Remover índices primeiro
            $table->dropIndex(['cod_cliente']);
            $table->dropIndex(['cod_franquia']);

            // Remover colunas
            $table->dropColumn(['cod_cliente', 'cod_franquia']);
        });
    }
};
