<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tawkto_configs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('empresa_id')->constrained('empresas')->onDelete('cascade');
            $table->string('property_id', 100)->comment('ID do site no Tawk.to');
            $table->string('widget_id', 100)->comment('ID do widget no Tawk.to');
            $table->boolean('ativo')->default(true);
            $table->json('paginas_habilitadas')->nullable()->comment('["index","cadastro","login","welcome"]');
            $table->json('customizacao')->nullable()->comment('Cores, posição, etc');
            $table->json('metadata_personalizado')->nullable()->comment('Campos extras para enviar ao Tawk.to');
            $table->timestamps();
            $table->softDeletes();

            // Userstamps
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();

            // Índices
            $table->index('empresa_id');
            $table->index('ativo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tawkto_configs');
    }
};
