<?php

namespace Database\Seeders;

use App\Models\Empresa;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CriativoPublicacaoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $superAdmin = User::where('email', 'admin@freefi.com.br')->first();
        $adminSP = User::where('email', 'joao@freefissaop.com.br')->first();
        
        if (!$superAdmin || !$adminSP) {
            echo "❌ ERRO: Usuários não encontrados. Execute UserComAprovacoesSeeder primeiro.\n";
            return;
        }
        
        $freefi = Empresa::where('tipo_empresa', 'matriz')->first();
        $franquiaSP = Empresa::where('name', 'FreeFi São Paulo')->first();
        
        $clienteShopping = Empresa::where('name', 'Shopping Vila Olímpia')->first();
        $clienteRestaurante = Empresa::where('name', 'Restaurante Fogo de Chão')->first();
        
        echo "🎨 CRIANDO CRIATIVOS...\n\n";
        
        // ==========================================
        // CRIATIVOS DO CATÁLOGO FreeFi (aprovados)
        // ==========================================
        echo "📚 Catálogo FreeFi:\n";
        
        $criativo1 = DB::table('criativos')->insertGetId([
            'franquia_id' => null, // Catálogo FreeFi
            'title' => 'Banner Natal 2025',
            'tipo' => 'imagem',
            'formato' => 'jpg',
            'path' => 'criativos/imagens/freefi/natal-2025.jpg',
            'conteudo_html' => null,
            'status_aprovacao' => 'aprovado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(30),
            'status' => 0,
            'created_by' => $superAdmin->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ✅ Criativo aprovado: Banner Natal 2025 (catálogo)\n";
        
        $criativo2 = DB::table('criativos')->insertGetId([
            'franquia_id' => null,
            'title' => 'Vídeo Institucional FreeFi',
            'tipo' => 'video',
            'formato' => 'mp4',
            'path' => 'criativos/videos/freefi/institucional.mp4',
            'conteudo_html' => null,
            'status_aprovacao' => 'aprovado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(60),
            'status' => 0,
            'created_by' => $superAdmin->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ✅ Criativo aprovado: Vídeo Institucional (catálogo)\n";
        
        $criativo3 = DB::table('criativos')->insertGetId([
            'franquia_id' => null,
            'title' => 'Quiz Satisfação Cliente',
            'tipo' => 'quiz',
            'formato' => 'html',
            'path' => null,
            'conteudo_html' => '<div class="quiz"><h2>Como foi sua experiência?</h2><button>Excelente</button><button>Bom</button><button>Regular</button></div>',
            'status_aprovacao' => 'aprovado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(45),
            'status' => 0,
            'created_by' => $superAdmin->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ✅ Criativo aprovado: Quiz Satisfação (catálogo)\n";
        
        // ==========================================
        // CRIATIVOS DA FRANQUIA SP
        // ==========================================
        echo "\n🏢 Franquia São Paulo:\n";
        
        // Criativo aprovado
        $criativo4 = DB::table('criativos')->insertGetId([
            'franquia_id' => $franquiaSP->id,
            'title' => 'Banner Promoção Verão SP',
            'tipo' => 'imagem',
            'formato' => 'png',
            'path' => 'criativos/imagens/franquia_' . $franquiaSP->id . '/promo-verao.png',
            'conteudo_html' => null,
            'status_aprovacao' => 'aprovado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(10),
            'status' => 0,
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ✅ Criativo aprovado: Banner Promoção Verão SP\n";
        
        // Criativo pendente
        $criativo5 = DB::table('criativos')->insertGetId([
            'franquia_id' => $franquiaSP->id,
            'title' => 'Banner Black Friday 2025',
            'tipo' => 'imagem',
            'formato' => 'jpg',
            'path' => 'criativos/imagens/franquia_' . $franquiaSP->id . '/black-friday.jpg',
            'conteudo_html' => null,
            'status_aprovacao' => 'pendente',
            'aprovado_por' => null,
            'aprovado_em' => null,
            'status' => 0,
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ⏳ Criativo pendente: Banner Black Friday 2025\n";
        
        // Criativo rejeitado
        $criativo6 = DB::table('criativos')->insertGetId([
            'franquia_id' => $franquiaSP->id,
            'title' => 'Banner Baixa Qualidade',
            'tipo' => 'imagem',
            'formato' => 'jpg',
            'path' => 'criativos/imagens/franquia_' . $franquiaSP->id . '/baixa-qualidade.jpg',
            'conteudo_html' => null,
            'status_aprovacao' => 'rejeitado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(5),
            'motivo_rejeicao' => 'Imagem com resolução muito baixa. Mínimo: 1920x1080',
            'bloqueado_permanente' => false,
            'status' => 0,
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ❌ Criativo rejeitado: Banner Baixa Qualidade\n     Motivo: Imagem com resolução muito baixa\n";
        
        // Criativo bloqueado
        $criativo7 = DB::table('criativos')->insertGetId([
            'franquia_id' => $franquiaSP->id,
            'title' => 'Banner Conteúdo Inapropriado',
            'tipo' => 'imagem',
            'formato' => 'png',
            'path' => 'criativos/imagens/franquia_' . $franquiaSP->id . '/inapropriado.png',
            'conteudo_html' => null,
            'status_aprovacao' => 'bloqueado',
            'aprovado_por' => $superAdmin->id,
            'aprovado_em' => now()->subDays(3),
            'motivo_rejeicao' => 'Conteúdo inapropriado. Violação dos termos de uso.',
            'bloqueado_permanente' => true,
            'status' => 0,
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  🚫 Criativo bloqueado permanentemente: Conteúdo Inapropriado\n";
        
        // ==========================================
        // PUBLICAÇÕES (Reutilização de Criativos)
        // ==========================================
        echo "\n📢 CRIANDO PUBLICAÇÕES...\n\n";
        
        // Publicação 1: Banner Natal para Shopping (usando criativo do catálogo)
        DB::table('publicacoes')->insert([
            'criativo_id' => $criativo1, // Reutilizando!
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'titulo' => 'Campanha Natal - Shopping Vila Olímpia',
            'data_inicio' => now()->subDays(15),
            'data_fim' => now()->addDays(45), // Até depois do Natal
            'valor_contrato' => 5000.00,
            'impressoes_contratadas' => 100000,
            'status' => 'ativa',
            'publicada_por' => $adminSP->id,
            'publicada_em' => now()->subDays(15),
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ✅ Publicação ativa: Campanha Natal - Shopping\n";
        echo "     └─ Reutilizando: Banner Natal 2025 (catálogo)\n";
        
        // Publicação 2: MESMO criativo para outro cliente
        DB::table('publicacoes')->insert([
            'criativo_id' => $criativo1, // Reutilizando o MESMO arquivo!
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteRestaurante->id,
            'titulo' => 'Campanha Natal - Restaurante Fogo de Chão',
            'data_inicio' => now()->subDays(10),
            'data_fim' => now()->addDays(50),
            'valor_contrato' => 2500.00,
            'impressoes_contratadas' => 50000,
            'status' => 'ativa',
            'publicada_por' => $adminSP->id,
            'publicada_em' => now()->subDays(10),
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ✅ Publicação ativa: Campanha Natal - Restaurante\n";
        echo "     └─ Reutilizando: Banner Natal 2025 (MESMO arquivo! 💾)\n";
        
        // Publicação 3: Vídeo institucional
        DB::table('publicacoes')->insert([
            'criativo_id' => $criativo2,
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'titulo' => 'Vídeo Institucional - Shopping',
            'data_inicio' => now()->subDays(30),
            'data_fim' => now()->addMonths(6),
            'valor_contrato' => 1000.00,
            'impressoes_contratadas' => null, // Sem limite
            'status' => 'ativa',
            'publicada_por' => $adminSP->id,
            'publicada_em' => now()->subDays(30),
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ✅ Publicação ativa: Vídeo Institucional - Shopping\n";
        
        // Publicação 4: Pausada
        DB::table('publicacoes')->insert([
            'criativo_id' => $criativo4,
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteRestaurante->id,
            'titulo' => 'Promoção Verão - Restaurante (PAUSADA)',
            'data_inicio' => now()->subDays(5),
            'data_fim' => now()->addMonths(2),
            'valor_contrato' => 3000.00,
            'impressoes_contratadas' => 75000,
            'status' => 'pausada',
            'publicada_por' => $adminSP->id,
            'publicada_em' => now()->subDays(5),
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  ⏸️  Publicação pausada: Promoção Verão - Restaurante\n";
        
        // Publicação 5: Expirada
        DB::table('publicacoes')->insert([
            'criativo_id' => $criativo4,
            'franquia_id' => $franquiaSP->id,
            'cliente_id' => $clienteShopping->id,
            'titulo' => 'Promoção Páscoa 2025 (EXPIRADA)',
            'data_inicio' => now()->subMonths(8),
            'data_fim' => now()->subMonths(7),
            'valor_contrato' => 4000.00,
            'impressoes_contratadas' => 80000,
            'status' => 'expirada',
            'publicada_por' => $adminSP->id,
            'publicada_em' => now()->subMonths(8),
            'created_by' => $adminSP->id,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        echo "  🕐 Publicação expirada: Promoção Páscoa 2025\n";
        
        echo "\n";
        echo "📊 RESUMO DE CRIATIVOS:\n";
        echo "   • Catálogo FreeFi: 3\n";
        echo "   • Franquia SP: 4 (1 aprovado, 1 pendente, 1 rejeitado, 1 bloqueado)\n";
        echo "   • Total: " . DB::table('criativos')->count() . " criativos\n";
        echo "\n";
        echo "📊 STATUS DE APROVAÇÃO:\n";
        echo "   • Aprovados: " . DB::table('criativos')->where('status_aprovacao', 'aprovado')->count() . "\n";
        echo "   • Pendentes: " . DB::table('criativos')->where('status_aprovacao', 'pendente')->count() . "\n";
        echo "   • Rejeitados: " . DB::table('criativos')->where('status_aprovacao', 'rejeitado')->count() . "\n";
        echo "   • Bloqueados: " . DB::table('criativos')->where('status_aprovacao', 'bloqueado')->count() . "\n";
        echo "\n";
        echo "📊 PUBLICAÇÕES:\n";
        echo "   • Ativas: " . DB::table('publicacoes')->where('status', 'ativa')->count() . "\n";
        echo "   • Pausadas: " . DB::table('publicacoes')->where('status', 'pausada')->count() . "\n";
        echo "   • Expiradas: " . DB::table('publicacoes')->where('status', 'expirada')->count() . "\n";
        echo "   • Total: " . DB::table('publicacoes')->count() . " publicações\n";
        echo "\n";
        echo "💾 REUTILIZAÇÃO:\n";
        echo "   • Criativo 'Banner Natal 2025' usado em 2 publicações!\n";
        echo "   • 1 arquivo físico → 2 contratos = Economia de espaço! 🎯\n";
    }
}
