<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        echo "\n";
        echo "╔════════════════════════════════════════════════════════════╗\n";
        echo "║  🚀 FREEFI ADMIN - TESTE EXAUSTIVO DE ESTRUTURA          ║\n";
        echo "╚════════════════════════════════════════════════════════════╝\n";
        echo "\n";
        
        $this->call([
            // Fase 1: Hierarquia de Empresas
            EmpresaHierarquiaSeeder::class,
            
            // Fase 2: Usuários com Aprovações
            UserComAprovacoesSeeder::class,
            
            // Fase 3: Hotspots com Situações
            HotspotComSituacoesSeeder::class,
            
            // Fase 4: Criativos e Publicações
            CriativoPublicacaoSeeder::class,
            
            // Fase 5: Formatos Permitidos
            FormatosPermitidosSeeder::class,
        ]);
        
        echo "\n";
        echo "╔════════════════════════════════════════════════════════════╗\n";
        echo "║  ✅ SEEDERS EXECUTADOS COM SUCESSO!                       ║\n";
        echo "╚════════════════════════════════════════════════════════════╝\n";
        echo "\n";
    }
}
