@extends('layouts.master')
@section('title', 'Meus Clientes')
@section('main-content')
@use('Illuminate\Support\Facades\Storage')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-buildings f-s-16 me-2"></i>Meus Clientes</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>
                                @if($totalFranquias > 1)
                                    {{ $totalFranquias }} Franquias
                                @else
                                    {{ $franquias->first()->name ?? 'Franquia' }}
                                @endif
                            </span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Clientes</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Mensagens de feedback -->
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="ph ph-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ph ph-warning-circle me-2"></i>{{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <!-- Clientes Pendentes de Aprovação -->
        @php
            $clientesPendentes = $clientes->filter(function($cliente) {
                return $cliente->status_aprovacao === 'pendente';
            });
        @endphp

        @if($clientesPendentes->count() > 0)
        <div class="row mb-3">
            <div class="col-12">
                <div class="card border-warning">
                    <div class="card-header bg-warning text-white">
                        <h5 class="mb-0">
                            <i class="ph ph-clock me-2"></i>
                            Clientes Aguardando Aprovação ({{ $clientesPendentes->count() }})
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th>Cliente</th>
                                        @if($totalFranquias > 1)
                                            <th>Franquia</th>
                                        @endif
                                        <th>E-mail</th>
                                        <th>Telefone</th>
                                        <th>Cadastrado em</th>
                                        <th class="text-center" width="200">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($clientesPendentes as $cliente)
                                    <tr>
                                        <td>
                                            <strong>{{ $cliente->name }}</strong>
                                        </td>
                                        @if($totalFranquias > 1)
                                            <td>
                                                <span class="badge bg-light text-dark border">
                                                    {{ $cliente->empresaPai->name ?? '-' }}
                                                </span>
                                            </td>
                                        @endif
                                        <td>{{ $cliente->email ?? '-' }}</td>
                                        <td>{{ $cliente->phone ?? '-' }}</td>
                                        <td>{{ $cliente->created_at->format('d/m/Y H:i') }}</td>
                                        <td class="text-center">
                                            <div class="btn-group" role="group">
                                                <!-- Botão Aprovar -->
                                                <form action="{{ route('clientes.approve', $cliente->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit"
                                                            class="btn btn-sm btn-success"
                                                            onclick="return confirm('Aprovar cadastro de {{ $cliente->name }}?')"
                                                            title="Aprovar">
                                                        <i class="ph ph-check"></i> Aprovar
                                                    </button>
                                                </form>

                                                <!-- Botão Rejeitar -->
                                                <button type="button"
                                                        class="btn btn-sm btn-danger"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#rejectModal{{ $cliente->id }}"
                                                        title="Rejeitar">
                                                    <i class="ph ph-x"></i> Rejeitar
                                                </button>
                                            </div>

                                            <!-- Modal de Rejeição -->
                                            <div class="modal fade" id="rejectModal{{ $cliente->id }}" tabindex="-1">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Rejeitar Cadastro</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <form action="{{ route('clientes.reject', $cliente->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <p>Tem certeza que deseja rejeitar o cadastro de <strong>{{ $cliente->name }}</strong>?</p>
                                                                <div class="mb-3">
                                                                    <label for="motivo_rejeicao{{ $cliente->id }}" class="form-label">
                                                                        Motivo da Rejeição <span class="text-danger">*</span>
                                                                    </label>
                                                                    <textarea class="form-control"
                                                                              id="motivo_rejeicao{{ $cliente->id }}"
                                                                              name="motivo_rejeicao"
                                                                              rows="3"
                                                                              required
                                                                              maxlength="500"
                                                                              placeholder="Explique o motivo da rejeição..."></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                                <button type="submit" class="btn btn-danger">
                                                                    <i class="ph ph-x me-1"></i>Rejeitar Cadastro
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Filtro de Franquias (se tiver múltiplas) -->
        @if($totalFranquias > 1)
        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-3">
                            <div>
                                <i class="ph-duotone ph-funnel f-s-24 text-primary"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Filtrar por Franquia</h6>
                                <p class="text-muted small mb-0">Você tem acesso a {{ $totalFranquias }} franquias</p>
                            </div>
                            <div class="d-flex gap-2 flex-wrap">
                                <!-- Botão: Todas -->
                                <a href="{{ route('clientes.index') }}"
                                   class="btn btn-sm {{ !request('franquia_filter') ? 'btn-primary' : 'btn-outline-primary' }}">
                                    <i class="ph ph-buildings me-1"></i>
                                    Todas ({{ $clientes->total() }})
                                </a>

                                <!-- Botões: Cada Franquia -->
                                @foreach($franquias as $franquia)
                                    <a href="{{ route('clientes.index', ['franquia_filter' => $franquia->id]) }}"
                                       class="btn btn-sm {{ request('franquia_filter') == $franquia->id ? 'btn-primary' : 'btn-outline-primary' }}">
                                        {{ $franquia->name }}
                                        <span class="badge bg-light text-dark ms-1">
                                            {{ $franquia->clientes->count() }}
                                        </span>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- tables start  -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5>Clientes da Franquia</h5>
                                <small class="text-muted">Total: {{ $clientes->total() }} cliente(s)</small>
                            </div>
                            <div class="d-flex align-items-center gap-2">
                                <!-- OWASP A03:2021 - XSS Prevention via sanitização no backend -->
                                <!-- Formulário de Busca -->
                                <form action="{{ route('clientes.index') }}" method="GET" class="d-flex">
                                    <!-- OWASP A02:2021 - CSRF Token automático do Laravel -->
                                    <div class="input-group" style="min-width: 300px;">
                                        <input type="text"
                                               name="q"
                                               id="search"
                                               class="form-control"
                                               placeholder="Buscar por nome..."
                                               value="{{ old('q', request('q')) }}"
                                               maxlength="255">
                                        <button type="submit" class="btn btn-secondary">
                                            <i class="ph ph-magnifying-glass me-1"></i>Buscar
                                        </button>
                                        @if(request('q'))
                                            <a href="{{ route('clientes.index') }}" class="btn btn-outline-secondary" title="Limpar filtros">
                                                <i class="ph ph-x"></i>
                                            </a>
                                        @endif
                                    </div>
                                </form>

                                <!-- Link de Convite (se tiver apenas 1 franquia) -->
                                @if($totalFranquias == 1 && $franquias->first()->token_convite)
                                    <button type="button"
                                            class="btn btn-success"
                                            onclick="copiarLinkConvite('{{ route('public.register.form', $franquias->first()->token_convite) }}')"
                                            title="Copiar link de cadastro para clientes">
                                        <i class="ph ph-link me-1"></i>Link de Convite
                                    </button>
                                @endif

                                <!-- Botão Novo Cliente -->
                                <a href="{{ route('clientes.create') }}" class="btn btn-primary">
                                    <i class="ph ph-plus me-1"></i>Novo Cliente
                                </a>
                            </div>
                        </div>

                        <!-- Links de Convite (se tiver múltiplas franquias) -->
                        @if($totalFranquias > 1)
                            <div class="mt-3">
                                <small class="text-muted d-block mb-2">
                                    <i class="ph ph-link me-1"></i>
                                    Links de Cadastro por Franquia:
                                </small>
                                <div class="d-flex flex-wrap gap-2">
                                    @foreach($franquias as $f)
                                        @if($f->token_convite)
                                            <button type="button"
                                                    class="btn btn-sm btn-outline-success"
                                                    onclick="copiarLinkConvite('{{ route('public.register.form', $f->token_convite) }}')"
                                                    title="Copiar link de {{ $f->name }}">
                                                <i class="ph ph-copy me-1"></i>{{ $f->name }}
                                            </button>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col" width="80">Logo</th>
                                    <th scope="col">Nome</th>
                                    @if($totalFranquias > 1)
                                        <th scope="col">Franquia</th>
                                    @endif
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Telefone</th>
                                    <th scope="col" class="text-center">Status</th>
                                    <th scope="col" class="text-center" width="200">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($clientes as $index => $cliente)
                                <tr class="@if($cliente->status == 1) text-muted @endif">
                                    <td class="text-center">
                                        {{ $clientes->firstItem() + $index }}
                                    </td>
                                    <td>
                                        @if($cliente->logomarca && Storage::disk('public')->exists($cliente->logomarca))
                                            <!-- OWASP A05:2021 - Imagem de fonte confiável (nosso storage) -->
                                            <img src="{{ asset('storage/' . $cliente->logomarca) }}"
                                                 alt="{{ $cliente->name }}"
                                                 class="rounded"
                                                 style="width: 50px; height: 50px; object-fit: cover;">
                                        @else
                                            <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                 style="width: 50px; height: 50px;">
                                                <i class="ph ph-buildings f-s-24 text-muted"></i>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <!-- OWASP A03:2021 - XSS Prevention via Blade escaping -->
                                        <strong>{{ $cliente->name }}</strong>
                                        @if($cliente->status == 1)
                                            <span class="badge bg-danger ms-2">Inativo</span>
                                        @endif
                                        @if($cliente->status_aprovacao === 'pendente')
                                            <span class="badge bg-warning text-dark ms-2">
                                                <i class="ph ph-clock me-1"></i>Aguardando Aprovação
                                            </span>
                                        @elseif($cliente->status_aprovacao === 'rejeitado')
                                            <span class="badge bg-danger ms-2">
                                                <i class="ph ph-x-circle me-1"></i>Rejeitado
                                            </span>
                                        @endif
                                    </td>
                                    @if($totalFranquias > 1)
                                        <td>
                                            <span class="badge bg-light text-dark border">
                                                <i class="ph ph-buildings me-1"></i>
                                                {{ $cliente->empresaPai->name ?? '-' }}
                                            </span>
                                        </td>
                                    @endif
                                    <td>
                                        @if($cliente->email)
                                            <a href="mailto:{{ $cliente->email }}" class="text-decoration-none">
                                                {{ $cliente->email }}
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($cliente->phone)
                                            {{ $cliente->phone }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        @if($cliente->status == 0)
                                            <span class="badge bg-success">Ativo</span>
                                        @else
                                            <span class="badge bg-danger">Inativo</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group" role="group">
                                            <!-- OWASP A01:2021 - URLs com IDs validados pelo controller -->
                                            <a href="{{ route('clientes.show', $cliente->id) }}"
                                               class="btn btn-sm btn-info"
                                               title="Visualizar">
                                                <i class="ph ph-eye"></i>
                                            </a>
                                            <a href="{{ route('clientes.edit', $cliente->id) }}"
                                               class="btn btn-sm btn-warning"
                                               title="Editar">
                                                <i class="ph ph-pencil"></i>
                                            </a>

                                            @if($cliente->status == 0)
                                                <!-- Botão Inativar -->
                                                <button type="button"
                                                        class="btn btn-sm btn-danger"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#deleteModal{{ $cliente->id }}"
                                                        title="Inativar">
                                                    <i class="ph ph-lock"></i>
                                                </button>
                                            @endif
                                        </div>

                                        <!-- Modal de Confirmação de Inativação -->
                                        <!-- OWASP A02:2021 - CSRF Token em forms de mudança de estado -->
                                        <div class="modal fade" id="deleteModal{{ $cliente->id }}" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Confirmar Inativação</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Tem certeza que deseja inativar o cliente <strong>{{ $cliente->name }}</strong>?</p>
                                                        <p class="text-muted small">
                                                            <i class="ph ph-warning me-1"></i>
                                                            O cliente não poderá mais acessar o sistema até ser reativado.
                                                        </p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                        <form action="{{ route('clientes.destroy', $cliente->id) }}" method="POST" class="d-inline">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">
                                                                <i class="ph ph-lock me-1"></i>Inativar
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="{{ $totalFranquias > 1 ? '8' : '7' }}" class="text-center py-5">
                                        <i class="ph ph-buildings f-s-48 text-muted mb-3"></i>
                                        <p class="text-muted mb-0">Nenhum cliente cadastrado.</p>
                                        <a href="{{ route('clientes.create') }}" class="btn btn-primary btn-sm mt-3">
                                            <i class="ph ph-plus me-1"></i>Cadastrar Primeiro Cliente
                                        </a>
                                    </td>
                                </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Paginação -->
                    @if($clientes->hasPages())
                    <div class="card-footer">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-muted small">
                                Mostrando {{ $clientes->firstItem() }} a {{ $clientes->lastItem() }} de {{ $clientes->total() }} registros
                            </div>
                            <div>
                                {{ $clientes->links() }}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- OWASP A05:2021 - Content Security Policy via meta tags no layout --}}
    {{-- OWASP A08:2021 - Sem CDN externo não confiável, apenas assets locais --}}

    @push('scripts')
    <script>
        function copiarLinkConvite(url) {
            // Criar elemento temporário
            const tempInput = document.createElement('input');
            tempInput.value = url;
            document.body.appendChild(tempInput);
            tempInput.select();
            tempInput.setSelectionRange(0, 99999); // Para mobile

            try {
                document.execCommand('copy');

                // Mostrar notificação de sucesso
                alert('Link copiado com sucesso!\n\n' + url + '\n\nCompartilhe este link com seus clientes para que eles possam se cadastrar.');
            } catch (err) {
                alert('Erro ao copiar link. Por favor, copie manualmente:\n\n' + url);
            }

            document.body.removeChild(tempInput);
        }
    </script>
    @endpush
@endsection
