@extends('layouts.master')
@section('title', 'Detalhes do Cliente')
@section('main-content')
@use('Illuminate\Support\Facades\Storage')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-buildings f-s-16 me-2"></i>Detalhes do Cliente</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('clientes.index') }}" class="f-s-14 f-w-500">
                            <span>Meus Clientes</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">{{ $cliente->name }}</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <!-- Informações Principais -->
            <div class="col-xl-8">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">{{ $cliente->name }}</h5>
                                @if($cliente->status == 0)
                                    <span class="badge bg-success mt-1">Ativo</span>
                                @else
                                    <span class="badge bg-danger mt-1">Inativo</span>
                                @endif
                            </div>
                            <div>
                                <a href="{{ route('clientes.edit', $cliente->id) }}" class="btn btn-warning btn-sm">
                                    <i class="ph ph-pencil me-1"></i>Editar
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Logomarca -->
                            <div class="col-md-4 text-center mb-3 mb-md-0">
                                @if($cliente->logomarca && Storage::disk('public')->exists($cliente->logomarca))
                                    {{-- OWASP A05:2021 - Imagem de fonte confiável (nosso storage) --}}
                                    <img src="{{ asset('storage/' . $cliente->logomarca) }}"
                                         alt="{{ $cliente->name }}"
                                         class="img-fluid rounded border"
                                         style="max-width: 250px; max-height: 250px; object-fit: cover;">
                                @else
                                    <div class="bg-light rounded d-flex align-items-center justify-content-center mx-auto"
                                         style="width: 200px; height: 200px;">
                                        <i class="ph ph-buildings" style="font-size: 80px; color: #ccc;"></i>
                                    </div>
                                    <p class="text-muted small mt-2">Sem logomarca</p>
                                @endif
                            </div>

                            <!-- Dados do Cliente -->
                            <div class="col-md-8">
                                <h6 class="mb-3">Informações de Contato</h6>
                                <table class="table table-borderless">
                                    <tbody>
                                        <tr>
                                            <td width="120" class="text-muted"><i class="ph ph-identifier me-2"></i>ID:</td>
                                            {{-- OWASP A03:2021 - XSS Prevention via Blade escaping --}}
                                            <td><strong>{{ $cliente->id }}</strong></td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted"><i class="ph ph-envelope me-2"></i>E-mail:</td>
                                            <td>
                                                @if($cliente->email)
                                                    <a href="mailto:{{ $cliente->email }}" class="text-decoration-none">
                                                        {{ $cliente->email }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted"><i class="ph ph-phone me-2"></i>Telefone:</td>
                                            <td>
                                                @if($cliente->phone)
                                                    {{ $cliente->phone }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted"><i class="ph ph-map-pin me-2"></i>Endereço:</td>
                                            <td>
                                                @if($cliente->address)
                                                    {{ $cliente->address }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                                <hr class="my-3">

                                <h6 class="mb-3">Informações do Sistema</h6>
                                <table class="table table-borderless">
                                    <tbody>
                                        <tr>
                                            <td width="120" class="text-muted"><i class="ph ph-buildings me-2"></i>Franquia:</td>
                                            <td><strong>{{ $franquia->name }}</strong></td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted"><i class="ph ph-calendar me-2"></i>Criado em:</td>
                                            <td>{{ $cliente->created_at->format('d/m/Y H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted"><i class="ph ph-clock me-2"></i>Atualizado em:</td>
                                            <td>{{ $cliente->updated_at->format('d/m/Y H:i') }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Hotspots do Cliente -->
                <div class="card mt-3">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Hotspots</h5>
                            <a href="{{ route('hotspots.create', ['cliente_id' => $cliente->id]) }}" class="btn btn-primary btn-sm">
                                <i class="ph ph-plus me-1"></i>Novo Hotspot
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($cliente->hotspots && $cliente->hotspots->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Nome</th>
                                            <th>Local</th>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($cliente->hotspots as $hotspot)
                                        <tr>
                                            <td>
                                                <strong>{{ $hotspot->name }}</strong>
                                            </td>
                                            <td>
                                                @if($hotspot->location)
                                                    {{ $hotspot->location }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                @if($hotspot->status == 1)
                                                    <span class="badge bg-success">Ativo</span>
                                                @else
                                                    <span class="badge bg-danger">Inativo</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('hotspots.show', $hotspot->id) }}"
                                                       class="btn btn-sm btn-info"
                                                       title="Visualizar">
                                                        <i class="ph ph-eye"></i>
                                                    </a>
                                                    <a href="{{ route('hotspots.edit', $hotspot->id) }}"
                                                       class="btn btn-sm btn-warning"
                                                       title="Editar">
                                                        <i class="ph ph-pencil"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i class="ph ph-wifi-slash" style="font-size: 48px; color: #ccc;"></i>
                                <p class="text-muted mt-2 mb-0">Nenhum hotspot cadastrado para este cliente.</p>
                                <a href="{{ route('hotspots.create', ['cliente_id' => $cliente->id]) }}"
                                   class="btn btn-primary btn-sm mt-3">
                                    <i class="ph ph-plus me-1"></i>Cadastrar Primeiro Hotspot
                                </a>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Usuários do Cliente -->
                <div class="card mt-3">
                    <div class="card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-1 text-white">
                                    <i class="ph-duotone ph-users me-2"></i>
                                    Usuários do Cliente
                                </h5>
                                <small class="text-white-50">Gerenciar acessos e permissões</small>
                            </div>
                            <div class="text-end d-flex align-items-center gap-2">
                                <button onclick="copiarLinkConviteCliente('{{ route('public.register.form', $franquia->token_convite) }}')"
                                        class="btn btn-light btn-sm"
                                        title="Copiar link de cadastro">
                                    <i class="ph ph-link me-1"></i>Link de Convite
                                </button>
                                <span class="badge bg-white text-primary fs-6">{{ $totalUsuarios }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Estatísticas Rápidas -->
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="text-center p-3 bg-light rounded">
                                    <i class="ph ph-check-circle text-success" style="font-size: 2rem;"></i>
                                    <h4 class="mb-0 mt-2 text-success">{{ $usuariosAtivos }}</h4>
                                    <small class="text-muted">Ativos</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-center p-3 bg-light rounded">
                                    <i class="ph ph-clock text-warning" style="font-size: 2rem;"></i>
                                    <h4 class="mb-0 mt-2 text-warning">{{ $usuariosPendentes }}</h4>
                                    <small class="text-muted">Pendentes</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-center p-3 bg-light rounded">
                                    <i class="ph ph-users-three text-primary" style="font-size: 2rem;"></i>
                                    <h4 class="mb-0 mt-2 text-primary">{{ $totalUsuarios }}</h4>
                                    <small class="text-muted">Total</small>
                                </div>
                            </div>
                        </div>

                        <!-- Lista de Usuários -->
                        @if($usuarios && $usuarios->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th><i class="ph ph-user me-1"></i>Nome</th>
                                            <th><i class="ph ph-envelope me-1"></i>E-mail</th>
                                            <th class="text-center"><i class="ph ph-shield-check me-1"></i>Status</th>
                                            <th class="text-center"><i class="ph ph-calendar me-1"></i>Criado em</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($usuarios as $usuario)
                                        <tr class="{{ $usuario->deleted_at ? 'table-secondary' : '' }}">
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-circle me-2" style="width: 32px; height: 32px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">
                                                        {{ strtoupper(substr($usuario->name, 0, 1)) }}
                                                    </div>
                                                    <div>
                                                        <strong>{{ $usuario->name }}</strong>
                                                        @if($usuario->deleted_at)
                                                            <br><small class="text-muted">Excluído em {{ $usuario->deleted_at->format('d/m/Y') }}</small>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <a href="mailto:{{ $usuario->email }}" class="text-decoration-none">
                                                    {{ $usuario->email }}
                                                </a>
                                            </td>
                                            <td class="text-center">
                                                @if($usuario->deleted_at)
                                                    <span class="badge bg-secondary">Excluído</span>
                                                @elseif($usuario->status_cadastro === 'aprovado')
                                                    <span class="badge bg-success">
                                                        <i class="ph ph-check-circle me-1"></i>Aprovado
                                                    </span>
                                                @elseif($usuario->status_cadastro === 'pendente')
                                                    <span class="badge bg-warning">
                                                        <i class="ph ph-clock me-1"></i>Pendente
                                                    </span>
                                                @elseif($usuario->status_cadastro === 'rejeitado')
                                                    <span class="badge bg-danger">
                                                        <i class="ph ph-x-circle me-1"></i>Rejeitado
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="text-center text-muted small">
                                                {{ $usuario->created_at->format('d/m/Y') }}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i class="ph ph-user-circle-slash" style="font-size: 48px; color: #ccc;"></i>
                                <p class="text-muted mt-2 mb-0">Nenhum usuário cadastrado para este cliente.</p>
                                <p class="small text-muted">
                                    Os usuários podem se cadastrar através do link de convite da franquia.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Estatísticas e Ações -->
            <div class="col-xl-4">
                <!-- Card de Estatísticas -->
                <div class="card bg-light-primary">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="ph ph-chart-bar me-2"></i>Estatísticas</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">Total de Hotspots</span>
                                <h3 class="mb-0 text-primary">{{ $totalHotspots }}</h3>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-primary"
                                     style="width: 100%"></div>
                            </div>
                        </div>

                        <div class="mb-0">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted">Hotspots Ativos</span>
                                <h3 class="mb-0 text-success">{{ $hotspotsAtivos }}</h3>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar bg-success"
                                     style="width: {{ $totalHotspots > 0 ? ($hotspotsAtivos / $totalHotspots * 100) : 0 }}%"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Card de Ações Rápidas -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="ph ph-lightning me-2"></i>Ações Rápidas</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('clientes.edit', $cliente->id) }}" class="btn btn-warning">
                                <i class="ph ph-pencil me-2"></i>Editar Cliente
                            </a>
                            <a href="{{ route('hotspots.create', ['cliente_id' => $cliente->id]) }}" class="btn btn-primary">
                                <i class="ph ph-wifi-high me-2"></i>Novo Hotspot
                            </a>
                            <a href="{{ route('publicacoes.create', ['cliente_id' => $cliente->id]) }}" class="btn btn-info">
                                <i class="ph ph-megaphone me-2"></i>Nova Publicação
                            </a>
                            <hr class="my-2">
                            <a href="{{ route('clientes.index') }}" class="btn btn-secondary">
                                <i class="ph ph-arrow-left me-2"></i>Voltar
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Card de Avisos -->
                @if($cliente->status == 1)
                <div class="card mt-3 border-danger">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0"><i class="ph ph-warning me-2"></i>Atenção</h5>
                    </div>
                    <div class="card-body">
                        <p class="small mb-0">
                            <i class="ph ph-lock me-1"></i>
                            Este cliente está <strong>INATIVO</strong>. Ele não poderá acessar o sistema até ser reativado.
                        </p>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    {{-- OWASP A05:2021 - Content Security Policy via meta tags no layout --}}
    {{-- OWASP A03:2021 - XSS Prevention via Blade escaping automático --}}

    <script>
    function copiarLinkConviteCliente(url) {
        // Criar elemento temporário para copiar
        const tempInput = document.createElement('input');
        tempInput.value = url;
        document.body.appendChild(tempInput);
        tempInput.select();
        tempInput.setSelectionRange(0, 99999); // Para mobile

        try {
            document.execCommand('copy');

            // Feedback visual com toast
            const toast = document.createElement('div');
            toast.innerHTML = `
                <div style="position: fixed; top: 20px; right: 20px; z-index: 9999;
                            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                            color: white; padding: 15px 25px; border-radius: 8px;
                            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
                            animation: slideInRight 0.3s ease-out;">
                    <i class="ph ph-check-circle me-2"></i>
                    <strong>Link copiado com sucesso!</strong>
                    <div style="font-size: 0.85em; margin-top: 5px; opacity: 0.9;">
                        Compartilhe com novos usuários do cliente
                    </div>
                </div>
            `;
            document.body.appendChild(toast);

            // Remover toast após 3 segundos
            setTimeout(() => {
                toast.remove();
            }, 3000);

        } catch (err) {
            // Fallback para alert caso execCommand não funcione
            alert('Link de convite:\n\n' + url + '\n\nCompartilhe este link com novos usuários.');
        }

        document.body.removeChild(tempInput);
    }

    // Animação CSS para o toast
    const style = document.createElement('style');
    style.textContent = `
        @keyframes slideInRight {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
    `;
    document.head.appendChild(style);
    </script>
@endsection
