@extends('layouts.master')
@section('title', 'Detalhes da Personalização')
@section('main-content')
    <div class="container-fluid">
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-palette f-s-16 me-2"></i>Detalhes da Personalização</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li><a href="{{ route('customizations.index') }}" class="f-s-14 f-w-500">Personalização</a></li>
                    <li class="active"><a href="#" class="f-s-14 f-w-500">Detalhes</a></li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>Informações</h5>
                    </div>
                    <div class="card-body">
                        <table class="table">
                            <tr><th>Hotspot:</th><td><code>{{ $customization->hotspot->serial }}</code></td></tr>
                            <tr><th>Marca:</th><td>{{ $customization->brand_name }}</td></tr>
                            <tr><th>Logo:</th><td>{{ $customization->logo_url }}</td></tr>
                            <tr><th>Título:</th><td>{{ $customization->welcome_title }}</td></tr>
                            <tr><th>Cor Primária:</th><td>
                                <div class="d-flex align-items-center gap-2">
                                    <div style="width: 30px; height: 30px; background:{{ $customization->primary_color }}; border: 1px solid #ddd; border-radius: 4px;"></div>
                                    <code>{{ $customization->primary_color }}</code>
                                </div>
                            </td></tr>
                            <tr><th>Status:</th><td>
                                <span class="badge bg-{{ $customization->is_active ? 'success' : 'secondary' }}">
                                    {{ $customization->is_active ? 'Ativo' : 'Inativo' }}
                                </span>
                            </td></tr>
                            <tr><th>Criado em:</th><td>{{ $customization->created_at->format('d/m/Y H:i') }}</td></tr>
                            <tr><th>Atualizado em:</th><td>{{ $customization->updated_at->format('d/m/Y H:i') }}</td></tr>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>Código Customizado</h5>
                    </div>
                    <div class="card-body">
                        @if($customization->custom_css)
                            <h6>CSS:</h6>
                            <pre class="bg-light p-2"><code>{{ $customization->custom_css }}</code></pre>
                        @endif

                        @if($customization->custom_js)
                            <h6>JavaScript:</h6>
                            <pre class="bg-light p-2"><code>{{ $customization->custom_js }}</code></pre>
                        @endif

                        @if(!$customization->custom_css && !$customization->custom_js)
                            <p class="text-muted">Nenhum código customizado.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-12 d-flex justify-content-between">
                <a href="{{ route('customizations.index') }}" class="btn btn-secondary">
                    <i class="ph ph-arrow-left me-1"></i>Voltar
                </a>
                <div class="btn-group">
                    <a href="{{ route('customizations.edit', $customization) }}" class="btn btn-primary">
                        <i class="ph ph-pencil me-1"></i>Editar
                    </a>
                    <a href="{{ route('customizations.preview', $customization) }}" class="btn btn-info" target="_blank">
                        <i class="ph ph-code me-1"></i>Ver Script
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
