@extends('layouts.master')
@section('title', 'Dashboard')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-gauge f-s-16 me-2"></i>Dashboard</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Visão Geral</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Mensagem de Boas-vindas com Ações Rápidas -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <h4 class="mb-1">👋 Bem-vindo, {{ Auth::user()->name }}!</h4>
                                <p class="text-muted mb-0">Aqui está um resumo do desempenho das suas campanhas nos últimos 30 dias.</p>
                            </div>
                            <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
                                <div class="d-flex gap-2 flex-wrap justify-content-lg-end">
                                    <a href="{{ route('midias.index') }}" class="btn btn-sm btn-primary" title="Ver Criativos">
                                        <i class="ph-duotone ph-image me-1"></i>Criativos
                                    </a>
                                    <a href="{{ route('publicacoes.index') }}" class="btn btn-sm btn-success" title="Ver Publicações">
                                        <i class="ph-duotone ph-broadcast me-1"></i>Publicações
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- KPIs - Cards Principais -->
        <div class="row">
            <!-- KPI 1: Total de Criativos -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Criativos</p>
                                <h3 class="mb-0">{{ $totalCriativos }}</h3>
                                <small class="text-muted">Total disponível</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-primary">
                                    <i class="ph-duotone ph-image f-s-32 text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 2: Investimento Total -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Investimento</p>
                                <h3 class="mb-0">R$ {{ number_format($investimentoTotal, 2, ',', '.') }}</h3>
                                <small class="text-success">{{ $publicacoesAtivas }} {{ $publicacoesAtivas == 1 ? 'publicação ativa' : 'publicações ativas' }}</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-success">
                                    <i class="ph-duotone ph-currency-circle-dollar f-s-32 text-success"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 3: Impressões -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Impressões</p>
                                <h3 class="mb-0">{{ number_format($impressoes, 0, ',', '.') }}</h3>
                                <small class="text-muted">Últimos 30 dias</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-info">
                                    <i class="ph-duotone ph-eye f-s-32 text-info"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 4: Cliques -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Cliques</p>
                                <h3 class="mb-0">{{ number_format($cliques, 0, ',', '.') }}</h3>
                                <small class="text-muted">Últimos 30 dias</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-warning">
                                    <i class="ph-duotone ph-cursor-click f-s-32 text-warning"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Segunda Linha: Top Criativos e Status -->
        <div class="row">
            <!-- Top 3 Criativos -->
            <div class="col-xl-8">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="ph-duotone ph-trophy me-2"></i>Top Criativos com Melhor Desempenho</h5>
                    </div>
                    <div class="card-body">
                        @if($topCriativos->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th width="50">#</th>
                                            <th>Criativo</th>
                                            <th class="text-center">Impressões</th>
                                            <th class="text-center">Cliques</th>
                                            <th class="text-center">CTR</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($topCriativos as $index => $criativo)
                                        <tr>
                                            <td class="text-center">
                                                @if($index === 0)
                                                    <span class="badge bg-warning">🥇</span>
                                                @elseif($index === 1)
                                                    <span class="badge bg-secondary">🥈</span>
                                                @else
                                                    <span class="badge bg-light text-dark">🥉</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <i class="ph-duotone ph-image me-2 f-s-20 text-primary"></i>
                                                    <strong>{{ $criativo->title }}</strong>
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-light-info text-info">
                                                    {{ number_format($criativo->total_impressoes, 0, ',', '.') }}
                                                </span>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-light-warning text-warning">
                                                    {{ number_format($criativo->total_cliques, 0, ',', '.') }}
                                                </span>
                                            </td>
                                            <td class="text-center">
                                                <strong class="text-success">{{ $criativo->ctr }}%</strong>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-5">
                                <i class="ph-duotone ph-chart-line-up f-s-48 text-muted mb-3"></i>
                                <p class="text-muted">Nenhum dado de performance disponível ainda.</p>
                                <small class="text-muted">As métricas aparecerão aqui assim que suas publicações começarem a gerar visualizações.</small>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Status das Publicações -->
            <div class="col-xl-4">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="ph-duotone ph-chart-pie-slice me-2"></i>Status das Publicações</h5>
                    </div>
                    <div class="card-body">
                        @if(count($statusPublicacoes) > 0)
                            @php
                                $total = array_sum($statusPublicacoes);
                                $cores = [
                                    'ativa' => 'success',
                                    'pausada' => 'warning',
                                    'expirada' => 'danger',
                                    'agendada' => 'info'
                                ];
                                $labels = [
                                    'ativa' => 'Ativas',
                                    'pausada' => 'Pausadas',
                                    'expirada' => 'Expiradas',
                                    'agendada' => 'Agendadas'
                                ];
                            @endphp

                            <div class="mb-4">
                                @foreach($statusPublicacoes as $status => $quantidade)
                                    @php
                                        $porcentagem = $total > 0 ? round(($quantidade / $total) * 100, 1) : 0;
                                        $cor = $cores[$status] ?? 'secondary';
                                        $label = $labels[$status] ?? ucfirst($status);
                                    @endphp
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between mb-1">
                                            <span class="text-muted">{{ $label }}</span>
                                            <span><strong>{{ $quantidade }}</strong> ({{ $porcentagem }}%)</span>
                                        </div>
                                        <div class="progress" style="height: 8px;">
                                            <div class="progress-bar bg-{{ $cor }}"
                                                 role="progressbar"
                                                 style="width: {{ $porcentagem }}%"
                                                 aria-valuenow="{{ $porcentagem }}"
                                                 aria-valuemin="0"
                                                 aria-valuemax="100">
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <div class="alert alert-light mb-0">
                                <p class="mb-1"><strong>Total de Publicações</strong></p>
                                <h4 class="mb-0">{{ $total }}</h4>
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i class="ph-duotone ph-broadcast f-s-48 text-muted mb-3"></i>
                                <p class="text-muted mb-0">Você ainda não possui publicações.</p>
                                <a href="{{ route('publicacoes.index') }}" class="btn btn-sm btn-primary mt-3">
                                    Ver Publicações
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Resumo CTR e Custos -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="ph-duotone ph-chart-line me-2"></i>Análise de Performance e Custos</h5>
                    </div>
                    <div class="card-body">
                        <div class="row align-items-center">
                            <!-- CTR -->
                            <div class="col-md-3 text-center border-end">
                                <i class="ph-duotone ph-target f-s-36 text-primary mb-2"></i>
                                <h6 class="text-muted mb-1 f-s-12">Taxa de Conversão</h6>
                                <h3 class="mb-0 text-primary">{{ $ctrGeral }}%</h3>
                                <small class="text-muted">CTR Geral</small>
                            </div>

                            <!-- Custo por Impressão -->
                            <div class="col-md-3 text-center border-end">
                                <i class="ph-duotone ph-eye f-s-36 text-info mb-2"></i>
                                <h6 class="text-muted mb-1 f-s-12">Custo por Impressão</h6>
                                @php
                                    $custoPorImpressao = $impressoes > 0 ? $investimentoTotal / $impressoes : 0;
                                @endphp
                                <h3 class="mb-0 text-info">R$ {{ number_format($custoPorImpressao, 2, ',', '.') }}</h3>
                                <small class="text-muted">Por visualização</small>
                            </div>

                            <!-- CPM (Custo por Mil) -->
                            <div class="col-md-3 text-center border-end">
                                <i class="ph-duotone ph-currency-circle-dollar f-s-36 text-success mb-2"></i>
                                <h6 class="text-muted mb-1 f-s-12">CPM</h6>
                                @php
                                    $cpm = $impressoes > 0 ? ($investimentoTotal / $impressoes) * 1000 : 0;
                                @endphp
                                <h3 class="mb-0 text-success">R$ {{ number_format($cpm, 2, ',', '.') }}</h3>
                                <small class="text-muted">Custo por mil</small>
                            </div>

                            <!-- Custo por Clique -->
                            <div class="col-md-3 text-center">
                                <i class="ph-duotone ph-cursor-click f-s-36 text-warning mb-2"></i>
                                <h6 class="text-muted mb-1 f-s-12">Custo por Clique</h6>
                                @php
                                    $custoPorClique = $cliques > 0 ? $investimentoTotal / $cliques : 0;
                                @endphp
                                <h3 class="mb-0 text-warning">R$ {{ number_format($custoPorClique, 2, ',', '.') }}</h3>
                                <small class="text-muted">CPC médio</small>
                            </div>
                        </div>

                        <hr class="my-3">

                        <!-- Dicas e Análise -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="alert alert-light-info mb-0">
                                    <strong>💡 CTR:</strong> Uma taxa entre <strong>5% e 10%</strong> é excelente.
                                    @if($ctrGeral >= 5)
                                        Parabéns! 🎉
                                    @else
                                        Continue otimizando!
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="alert alert-light-success mb-0">
                                    <strong>💰 ROI:</strong>
                                    @if($impressoes > 0 && $custoPorImpressao < 10)
                                        Seu custo por impressão está ótimo! Abaixo de R$ 10,00.
                                    @elseif($impressoes > 0)
                                        Considere otimizar para reduzir o custo por impressão.
                                    @else
                                        Aguardando primeiras impressões para calcular ROI.
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('styles')
<style>
    .kpi-card {
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .kpi-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    .avatar-md {
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .bg-light-primary { background-color: rgba(var(--primary), 0.1); }
    .bg-light-success { background-color: rgba(var(--success), 0.1); }
    .bg-light-info { background-color: rgba(var(--info), 0.1); }
    .bg-light-warning { background-color: rgba(var(--warning), 0.1); }
    .alert-light-info {
        background-color: rgba(var(--info), 0.1);
        border-color: rgba(var(--info), 0.2);
        color: var(--font-color);
    }
    .alert-light-success {
        background-color: rgba(var(--success), 0.1);
        border-color: rgba(var(--success), 0.2);
        color: var(--font-color);
    }
    .border-end {
        border-right: 1px solid var(--border_color) !important;
    }
</style>
@endpush
