@extends('layouts.master')
@section('title', 'Dashboard')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-gauge f-s-16 me-2"></i>Dashboard</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Visão Geral</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Mensagem de Boas-vindas -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <h4 class="mb-1">👋 Bem-vindo, {{ Auth::user()->name }}!</h4>
                                <p class="text-muted mb-0">
                                    @if($franquias->count() > 1)
                                        Você gerencia <strong>{{ $franquias->count() }} franquias</strong> com <strong>{{ $totalClientes }} clientes</strong> no total.
                                    @else
                                        Visão geral da sua franquia: <strong>{{ $franquias->first()->name }}</strong>
                                    @endif
                                </p>
                            </div>
                            <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
                                <div class="d-flex gap-2 flex-wrap justify-content-lg-end">
                                    <a href="{{ route('clientes.index') }}" class="btn btn-sm btn-primary">
                                        <i class="ph-duotone ph-buildings me-1"></i>Meus Clientes
                                    </a>
                                    <a href="{{ route('publicacoes.index') }}" class="btn btn-sm btn-success">
                                        <i class="ph-duotone ph-broadcast me-1"></i>Publicações
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- KPIs - Cards Principais -->
        <div class="row">
            <!-- KPI 1: Total de Clientes -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Clientes</p>
                                <h3 class="mb-0">{{ $totalClientes }}</h3>
                                <small class="text-muted">
                                    @if($franquias->count() > 1)
                                        De {{ $franquias->count() }} franquias
                                    @else
                                        Total cadastrados
                                    @endif
                                </small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-primary">
                                    <i class="ph-duotone ph-buildings f-s-32 text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 2: Total de Publicações -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Publicações</p>
                                <h3 class="mb-0">{{ $totalPublicacoes }}</h3>
                                <small class="text-success">Campanhas totais</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-success">
                                    <i class="ph-duotone ph-broadcast f-s-32 text-success"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 3: Total de Criativos -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Criativos</p>
                                <h3 class="mb-0">{{ $totalCriativos }}</h3>
                                <small class="text-muted">Total disponíveis</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-info">
                                    <i class="ph-duotone ph-image f-s-32 text-info"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 4: Alcance Mensal -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Alcance Mensal</p>
                                <h3 class="mb-0">{{ number_format($alcanceMensal, 0, ',', '.') }}</h3>
                                <small class="text-muted">Usuários únicos</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-warning">
                                    <i class="ph-duotone ph-users f-s-32 text-warning"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Franquias (se tiver múltiplas) -->
        @if($franquias->count() > 1)
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-buildings me-2"></i>
                            Suas Franquias
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($franquias as $franquia)
                                <div class="col-md-4 mb-3">
                                    <div class="card border">
                                        <div class="card-body">
                                            <h6 class="mb-2">{{ $franquia->name }}</h6>
                                            <p class="text-muted small mb-0">
                                                <i class="ph ph-users me-1"></i>
                                                {{ $franquia->clientes->count() }}
                                                {{ $franquia->clientes->count() == 1 ? 'cliente' : 'clientes' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Performance WiFi -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-1 text-white">
                                    <i class="ph-duotone ph-wifi-high me-2"></i>
                                    Performance da Rede WiFi
                                </h5>
                                <small class="text-white-50">Dados dos últimos 7 dias</small>
                            </div>
                            <div class="text-end">
                                <i class="ph-duotone ph-chart-line-up" style="font-size: 2rem; opacity: 0.3;"></i>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- KPIs WiFi -->
                        <div class="row mb-4">
                            <!-- Conexões Únicas -->
                            <div class="col-xl-3 col-md-6 mb-3">
                                <div class="card kpi-card border-start border-primary border-3">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <p class="text-muted mb-1 f-s-13">👤 Conexões Únicas</p>
                                                <h4 class="mb-0">{{ number_format($conexoesUnicas, 0, ',', '.') }}</h4>
                                                <small class="text-muted">Últimos 7 dias</small>
                                            </div>
                                            <div class="ms-2">
                                                <i class="ph ph-users-three f-s-32 text-primary opacity-50"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Taxa de Retorno -->
                            <div class="col-xl-3 col-md-6 mb-3">
                                <div class="card kpi-card border-start border-success border-3">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <p class="text-muted mb-1 f-s-13">🔄 Taxa de Retorno</p>
                                                <h4 class="mb-0">{{ number_format($taxaRetorno, 1) }}%</h4>
                                                <small class="text-success">
                                                    @if($taxaRetorno >= 40)
                                                        Excelente!
                                                    @elseif($taxaRetorno >= 25)
                                                        Bom
                                                    @else
                                                        Pode melhorar
                                                    @endif
                                                </small>
                                            </div>
                                            <div class="ms-2">
                                                <i class="ph ph-arrow-u-down-left f-s-32 text-success opacity-50"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Tempo Médio -->
                            <div class="col-xl-3 col-md-6 mb-3">
                                <div class="card kpi-card border-start border-info border-3">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <p class="text-muted mb-1 f-s-13">⏱️ Tempo Médio</p>
                                                <h4 class="mb-0">{{ number_format($tempoMedioSessao, 1) }} min</h4>
                                                <small class="text-muted">Por sessão</small>
                                            </div>
                                            <div class="ms-2">
                                                <i class="ph ph-clock f-s-32 text-info opacity-50"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- % Mobile -->
                            <div class="col-xl-3 col-md-6 mb-3">
                                <div class="card kpi-card border-start border-warning border-3">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <p class="text-muted mb-1 f-s-13">📱 Dispositivos Mobile</p>
                                                <h4 class="mb-0">{{ number_format($percentualMobile, 1) }}%</h4>
                                                <small class="text-muted">Do total de acessos</small>
                                            </div>
                                            <div class="ms-2">
                                                <i class="ph ph-device-mobile f-s-32 text-warning opacity-50"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Top 5 Hotspots e Status -->
                        <div class="row">
                            <!-- Top 5 Hotspots -->
                            <div class="col-lg-8">
                                <h6 class="mb-3">
                                    <i class="ph ph-trophy me-1"></i>
                                    Top 5 Hotspots Mais Ativos
                                </h6>
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th width="50">#</th>
                                                <th>Cliente / Local</th>
                                                <th class="text-center">Conexões</th>
                                                <th class="text-center">Taxa Retorno</th>
                                                <th class="text-center">Tempo Médio</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($topHotspots as $index => $hotspot)
                                                <tr>
                                                    <td class="text-center">
                                                        @if($index == 0) 🥇
                                                        @elseif($index == 1) 🥈
                                                        @elseif($index == 2) 🥉
                                                        @else {{ $index + 1 }}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div>
                                                            <strong>{{ $hotspot->cliente_nome ?? 'Sem cliente' }}</strong>
                                                        </div>
                                                        <small class="text-muted">Serial: {{ $hotspot->serial }}</small>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge bg-primary">{{ number_format($hotspot->total_conexoes, 0, ',', '.') }}</span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge bg-success">{{ number_format($hotspot->taxa_retorno ?? 0, 1) }}%</span>
                                                    </td>
                                                    <td class="text-center">
                                                        {{ number_format($hotspot->tempo_medio ?? 0, 1) }} min
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center text-muted py-3">
                                                        <i class="ph ph-wifi-slash f-s-32 d-block mb-2"></i>
                                                        Nenhum dado de acesso nos últimos 7 dias
                                                    </td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Status dos Hotspots -->
                            <div class="col-lg-4">
                                <h6 class="mb-3">
                                    <i class="ph ph-activity me-1"></i>
                                    Status dos Hotspots
                                </h6>
                                <div class="card border mb-3">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="flex-grow-1">
                                                <h3 class="mb-0">{{ $statusHotspots->total ?? 0 }}</h3>
                                                <small class="text-muted">Total Instalados</small>
                                            </div>
                                            <i class="ph ph-wifi-high f-s-48 text-muted opacity-25"></i>
                                        </div>
                                        <hr>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>
                                                <i class="ph ph-check-circle text-success me-1"></i>
                                                Online
                                            </span>
                                            <strong class="text-success">{{ $statusHotspots->online ?? 0 }}</strong>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <span>
                                                <i class="ph ph-warning-circle text-warning me-1"></i>
                                                Alerta
                                            </span>
                                            <strong class="text-warning">{{ $statusHotspots->alerta ?? 0 }}</strong>
                                        </div>
                                        @if(($statusHotspots->alerta ?? 0) > 0)
                                            <div class="alert alert-warning mt-3 mb-0 py-2">
                                                <small>
                                                    <i class="ph ph-warning me-1"></i>
                                                    {{ $statusHotspots->alerta }} hotspot(s) sem atividade recente
                                                </small>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <a href="{{ route('hotspots.index') }}" class="btn btn-outline-primary w-100">
                                    <i class="ph ph-list me-1"></i>
                                    Ver Todos os Hotspots
                                </a>
                            </div>
                        </div>

                        <!-- Gráfico de Conexões por Horário -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <h6 class="mb-3">
                                    <i class="ph ph-chart-line me-1"></i>
                                    Conexões por Horário (Últimos 7 dias)
                                </h6>
                                <canvas id="chartConexoesPorHorario" height="80"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Análise de Receita -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); color: white;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-1 text-white">
                                    <i class="ph-duotone ph-currency-circle-dollar me-2"></i>
                                    Análise de Receita por Cliente
                                </h5>
                                <small class="text-white-50">Publicações ativas</small>
                            </div>
                            <div class="text-end">
                                <i class="ph-duotone ph-trend-up" style="font-size: 2rem; opacity: 0.3;"></i>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- KPIs de Receita -->
                        <div class="row mb-4">
                            <!-- Receita Total -->
                            <div class="col-md-4">
                                <div class="card kpi-card border-start border-success border-4">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <p class="text-muted mb-1 f-s-13">💵 Receita Total Ativa</p>
                                                <h3 class="mb-0 text-success">R$ {{ number_format($receitaTotal, 2, ',', '.') }}</h3>
                                                <small class="text-muted">Publicações ativas</small>
                                            </div>
                                            <div class="ms-2">
                                                <i class="ph ph-trend-up f-s-40 text-success opacity-50"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Ticket Médio -->
                            <div class="col-md-4">
                                <div class="card kpi-card border-start border-info border-4">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <p class="text-muted mb-1 f-s-13">📊 Ticket Médio</p>
                                                <h3 class="mb-0 text-info">R$ {{ number_format($ticketMedio, 2, ',', '.') }}</h3>
                                                <small class="text-muted">Por cliente ativo</small>
                                            </div>
                                            <div class="ms-2">
                                                <i class="ph ph-chart-bar f-s-40 text-info opacity-50"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Cliente Mais Rentável -->
                            <div class="col-md-4">
                                <div class="card kpi-card border-start border-warning border-4">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-grow-1">
                                                <p class="text-muted mb-1 f-s-13">🏆 Cliente Mais Rentável</p>
                                                <h6 class="mb-1">
                                                    @if($clienteMaisRentavel)
                                                        {{ Str::limit($clienteMaisRentavel->name, 25) }}
                                                    @else
                                                        -
                                                    @endif
                                                </h6>
                                                <small class="text-warning">
                                                    @if($clienteMaisRentavel)
                                                        R$ {{ number_format($clienteMaisRentavel->receita_ativa, 2, ',', '.') }}
                                                        ({{ $percentualMaisRentavel }}%)
                                                    @else
                                                        Sem dados
                                                    @endif
                                                </small>
                                            </div>
                                            <div class="ms-2">
                                                <i class="ph ph-crown f-s-40 text-warning opacity-50"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Top 10 Clientes por Receita -->
                        <div class="row">
                            <div class="col-lg-7">
                                <h6 class="mb-3">
                                    <i class="ph ph-ranking me-1"></i>
                                    Top 10 Clientes por Receita
                                </h6>
                                @if($receitaPorCliente->count() > 0)
                                    <div style="position: relative; height: {{ max(300, $receitaPorCliente->count() * 50) }}px;">
                                        <canvas id="chartReceitaPorCliente"></canvas>
                                    </div>
                                @else
                                    <div class="alert alert-info">
                                        <i class="ph ph-info me-2"></i>
                                        Nenhum cliente com publicações ativas ainda.
                                    </div>
                                @endif
                            </div>

                            <!-- Insights -->
                            <div class="col-lg-5">
                                <h6 class="mb-3">
                                    <i class="ph ph-lightbulb me-1"></i>
                                    Insights Estratégicos
                                </h6>

                                <!-- Distribuição -->
                                <div class="card border mb-3">
                                    <div class="card-body">
                                        <h6 class="mb-3">📊 Distribuição de Receita</h6>
                                        @php
                                            $top3Receita = $receitaPorCliente->take(3)->sum('receita_ativa');
                                            $percentualTop3 = $receitaTotal > 0 ? round(($top3Receita / $receitaTotal) * 100, 1) : 0;
                                        @endphp
                                        <div class="mb-3">
                                            <div class="d-flex justify-content-between mb-1">
                                                <span class="text-muted small">Top 3 Clientes</span>
                                                <strong>{{ $percentualTop3 }}%</strong>
                                            </div>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-success" style="width: {{ $percentualTop3 }}%"></div>
                                            </div>
                                        </div>

                                        @if($percentualTop3 >= 70)
                                            <div class="alert alert-warning mb-0 py-2">
                                                <small>
                                                    <i class="ph ph-warning-circle me-1"></i>
                                                    <strong>Atenção:</strong> Sua receita está concentrada em poucos clientes.
                                                    Considere diversificar!
                                                </small>
                                            </div>
                                        @else
                                            <div class="alert alert-success mb-0 py-2">
                                                <small>
                                                    <i class="ph ph-check-circle me-1"></i>
                                                    <strong>Ótimo!</strong> Sua receita está bem distribuída.
                                                </small>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <!-- Oportunidades -->
                                <div class="card border">
                                    <div class="card-body">
                                        <h6 class="mb-3">💡 Oportunidades</h6>
                                        @php
                                            $clientesSemReceita = $totalClientes - $receitaPorCliente->where('total_publicacoes', '>', 0)->count();
                                        @endphp
                                        <div class="d-flex align-items-start mb-2">
                                            <i class="ph ph-users text-primary me-2 f-s-20"></i>
                                            <div>
                                                <strong>{{ $clientesSemReceita }}</strong> cliente(s) sem publicações ativas
                                                @if($clientesSemReceita > 0)
                                                    <br><small class="text-muted">Potencial de venda!</small>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-start mb-2">
                                            <i class="ph ph-chart-line-up text-success me-2 f-s-20"></i>
                                            <div>
                                                <small class="text-muted">Ticket médio: R$ {{ number_format($ticketMedio, 2, ',', '.') }}</small>
                                                <br><small>Clientes abaixo do ticket podem crescer</small>
                                            </div>
                                        </div>
                                        <hr>
                                        <a href="{{ route('clientes.index') }}" class="btn btn-sm btn-primary w-100">
                                            <i class="ph ph-phone me-1"></i>
                                            Entrar em Contato
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ações Rápidas -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-lightning me-2"></i>
                            Ações Rápidas
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('clientes.create') }}" class="btn btn-outline-primary w-100 p-3">
                                    <i class="ph-duotone ph-plus-circle f-s-32 d-block mb-2"></i>
                                    <span>Novo Cliente</span>
                                </a>
                            </div>
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('clientes.index') }}" class="btn btn-outline-secondary w-100 p-3">
                                    <i class="ph-duotone ph-list f-s-32 d-block mb-2"></i>
                                    <span>Ver Clientes</span>
                                </a>
                            </div>
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('publicacoes.index') }}" class="btn btn-outline-success w-100 p-3">
                                    <i class="ph-duotone ph-broadcast f-s-32 d-block mb-2"></i>
                                    <span>Publicações</span>
                                </a>
                            </div>
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('midias.index') }}" class="btn btn-outline-info w-100 p-3">
                                    <i class="ph-duotone ph-image f-s-32 d-block mb-2"></i>
                                    <span>Criativos</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <style>
        .kpi-card {
            transition: transform 0.2s, box-shadow 0.2s;
            border: none;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        }

        .kpi-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .avatar-md {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .bg-light-primary {
            background-color: rgba(var(--bs-primary-rgb), 0.1);
        }

        .bg-light-success {
            background-color: rgba(var(--bs-success-rgb), 0.1);
        }

        .bg-light-info {
            background-color: rgba(var(--bs-info-rgb), 0.1);
        }

        .bg-light-warning {
            background-color: rgba(var(--bs-warning-rgb), 0.1);
        }
    </style>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <script>
        // Gráfico de Conexões por Horário
        const ctx = document.getElementById('chartConexoesPorHorario');
        const dados = @json(array_values($conexoesPorHorarioCompleto));
        const labels = Array.from({length: 24}, (_, i) => i + 'h');

        new Chart(ctx, {
            type: 'line',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Conexões Únicas',
                    data: dados,
                    borderColor: 'rgb(75, 192, 192)',
                    backgroundColor: 'rgba(75, 192, 192, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointBackgroundColor: 'rgb(75, 192, 192)',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 4,
                    pointHoverRadius: 6
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                    },
                    tooltip: {
                        mode: 'index',
                        intersect: false,
                        callbacks: {
                            label: function(context) {
                                return 'Conexões: ' + context.parsed.y.toLocaleString('pt-BR');
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString('pt-BR');
                            }
                        },
                        grid: {
                            display: true,
                            drawBorder: false
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                },
                interaction: {
                    mode: 'nearest',
                    axis: 'x',
                    intersect: false
                }
            }
        });

        // Gráfico de Receita por Cliente (Barras Horizontais)
        console.log('🔍 DEBUG: Iniciando criação do gráfico de receita...');
        const ctxReceita = document.getElementById('chartReceitaPorCliente');
        console.log('🔍 DEBUG: Canvas element:', ctxReceita);

        if (ctxReceita) {
            const clientesNomes = @json($receitaPorCliente->pluck('name'));
            const clientesReceitas = @json($receitaPorCliente->pluck('receita_ativa'));

            console.log('🔍 DEBUG: Nomes dos clientes:', clientesNomes);
            console.log('🔍 DEBUG: Receitas:', clientesReceitas);
            console.log('🔍 DEBUG: Total de registros:', clientesNomes.length);

            // Verificar se há dados para exibir
            if (clientesNomes.length > 0 && clientesReceitas.length > 0) {
                console.log('✅ DEBUG: Dados OK, criando gráfico...');
                // Gerar cores gradientes
                const gerarCoresGradiente = (total) => {
                    const cores = [];
                    const coresBorda = [];
                    for (let i = 0; i < total; i++) {
                        const intensidade = 1 - (i / total) * 0.5; // Do mais escuro (1) ao mais claro (0.5)
                        cores.push(`rgba(75, 192, 192, ${intensidade * 0.7})`);
                        coresBorda.push(`rgba(75, 192, 192, ${intensidade})`);
                    }
                    return { cores, coresBorda };
                };

                const { cores, coresBorda } = gerarCoresGradiente(clientesNomes.length);

                try {
                    console.log('🎨 DEBUG: Criando instância do Chart.js...');
                    const chartReceita = new Chart(ctxReceita, {
            type: 'bar',
            data: {
                labels: clientesNomes,
                datasets: [{
                    label: 'Receita Ativa (R$)',
                    data: clientesReceitas,
                    backgroundColor: cores,
                    borderColor: coresBorda,
                    borderWidth: 2
                }]
            },
            options: {
                indexAxis: 'y', // Barras horizontais
                responsive: true,
                maintainAspectRatio: false,
                animation: {
                    duration: 1000,
                    onComplete: function() {
                        console.log('✅ Animação concluída!');
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const valor = context.parsed.x;
                                return 'Receita: R$ ' + valor.toLocaleString('pt-BR', {
                                    minimumFractionDigits: 2,
                                    maximumFractionDigits: 2
                                });
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return 'R$ ' + value.toLocaleString('pt-BR', {
                                    minimumFractionDigits: 0,
                                    maximumFractionDigits: 0
                                });
                            }
                        },
                        grid: {
                            display: true,
                            drawBorder: false
                        }
                    },
                    y: {
                        grid: {
                            display: false
                        },
                        ticks: {
                            autoSkip: false,
                            font: {
                                size: 11
                            }
                        }
                    }
                },
                interaction: {
                    mode: 'nearest',
                    axis: 'y',
                    intersect: false
                }
            }
        });
                    console.log('✅ DEBUG: Gráfico criado com sucesso!', chartReceita);
                } catch (error) {
                    console.error('❌ DEBUG: Erro ao criar gráfico:', error);
                    console.error('❌ Stack trace:', error.stack);
                }
            } else {
                console.warn('⚠️  DEBUG: Não há dados para exibir no gráfico');
                console.warn('   - Nomes:', clientesNomes.length);
                console.warn('   - Receitas:', clientesReceitas.length);
            } // fim if dados
        } else {
            console.warn('⚠️  DEBUG: Canvas chartReceitaPorCliente não encontrado no DOM');
        } // fim if ctxReceita
    </script>
@endsection
