@extends('layouts.master')
@section('title', 'Dashboard Super Admin')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-gauge f-s-16 me-2"></i>Dashboard Super Admin</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Visão Geral do Sistema</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Mensagem de Boas-vindas -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <h4 class="mb-1">👋 Bem-vindo, {{ Auth::user()->name }}!</h4>
                                <p class="text-muted mb-0">
                                    Visão completa do sistema FreeFi - Gerenciamento de Hotspots e Publicidade
                                </p>
                            </div>
                            <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
                                <div class="d-flex gap-2 flex-wrap justify-content-lg-end">
                                    <a href="{{ route('empresas.index') }}" class="btn btn-sm btn-primary">
                                        <i class="ph-duotone ph-buildings me-1"></i>Empresas
                                    </a>
                                    <a href="{{ route('publicacoes.index') }}" class="btn btn-sm btn-success">
                                        <i class="ph-duotone ph-broadcast me-1"></i>Publicações
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- KPIs - Cards Principais -->
        <div class="row">
            <!-- KPI 1: Total de Empresas -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Empresas</p>
                                <h3 class="mb-0">{{ $totalEmpresas }}</h3>
                                <small class="text-muted">Total cadastradas</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-primary">
                                    <i class="ph-duotone ph-buildings f-s-32 text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 2: Total de Publicações -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Publicações</p>
                                <h3 class="mb-0">{{ $totalPublicacoes }}</h3>
                                <small class="text-success">Campanhas totais</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-success">
                                    <i class="ph-duotone ph-broadcast f-s-32 text-success"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 3: Total de Criativos -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Criativos</p>
                                <h3 class="mb-0">{{ $totalCriativos }}</h3>
                                <small class="text-muted">Total disponíveis</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-info">
                                    <i class="ph-duotone ph-image f-s-32 text-info"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- KPI 4: Total de Hotspots -->
            <div class="col-xl-3 col-md-6">
                <div class="card kpi-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-2 f-s-14">Hotspots</p>
                                <h3 class="mb-0">{{ $totalHotspots }}</h3>
                                <small class="text-muted">Total instalados</small>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-md rounded-circle bg-light-warning">
                                    <i class="ph-duotone ph-wifi-high f-s-32 text-warning"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sistema -->
        <div class="row mt-4">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                        <h5 class="mb-0 text-white">
                            <i class="ph-duotone ph-buildings me-2"></i>
                            Empresas por Tipo
                        </h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-3">Distribuição de empresas no sistema</p>
                        <div class="alert alert-info">
                            <i class="ph ph-info me-2"></i>
                            Acesse o menu <strong>Empresas</strong> para visualizar detalhes e gerenciar todas as empresas cadastradas.
                        </div>
                        <a href="{{ route('empresas.index') }}" class="btn btn-primary w-100">
                            <i class="ph ph-buildings me-2"></i>
                            Gerenciar Empresas
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); color: white;">
                        <h5 class="mb-0 text-white">
                            <i class="ph-duotone ph-broadcast me-2"></i>
                            Publicações Ativas
                        </h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-3">Campanhas publicitárias em andamento</p>
                        <div class="alert alert-success">
                            <i class="ph ph-check-circle me-2"></i>
                            Sistema de publicidade operacional. Total de <strong>{{ $totalPublicacoes }}</strong> publicações cadastradas.
                        </div>
                        <a href="{{ route('publicacoes.index') }}" class="btn btn-success w-100">
                            <i class="ph ph-broadcast me-2"></i>
                            Ver Publicações
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ações Rápidas -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-lightning me-2"></i>
                            Ações Rápidas
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('empresas.create') }}" class="btn btn-outline-primary w-100 p-3">
                                    <i class="ph-duotone ph-plus-circle f-s-32 d-block mb-2"></i>
                                    <span>Nova Empresa</span>
                                </a>
                            </div>
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('empresas.index') }}" class="btn btn-outline-secondary w-100 p-3">
                                    <i class="ph-duotone ph-list f-s-32 d-block mb-2"></i>
                                    <span>Ver Empresas</span>
                                </a>
                            </div>
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('publicacoes.index') }}" class="btn btn-outline-success w-100 p-3">
                                    <i class="ph-duotone ph-broadcast f-s-32 d-block mb-2"></i>
                                    <span>Publicações</span>
                                </a>
                            </div>
                            <div class="col-md-3 mb-3">
                                <a href="{{ route('midias.index') }}" class="btn btn-outline-info w-100 p-3">
                                    <i class="ph-duotone ph-image f-s-32 d-block mb-2"></i>
                                    <span>Criativos</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Configurações do Sistema -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-dark text-white">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-gear me-2"></i>
                            Configurações do Sistema
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="card border">
                                    <div class="card-body">
                                        <h6 class="mb-3">
                                            <i class="ph ph-credit-card text-primary me-2"></i>
                                            Mercado Pago
                                        </h6>
                                        <p class="text-muted small mb-3">
                                            Configure as credenciais do Mercado Pago para cada empresa e habilite split de pagamentos.
                                        </p>
                                        <a href="{{ route('empresas.index') }}" class="btn btn-sm btn-outline-primary">
                                            <i class="ph ph-gear me-1"></i>
                                            Configurar
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="card border">
                                    <div class="card-body">
                                        <h6 class="mb-3">
                                            <i class="ph ph-wifi-high text-success me-2"></i>
                                            Hotspots
                                        </h6>
                                        <p class="text-muted small mb-3">
                                            Gerencie todos os hotspots WiFi instalados nas empresas e monitore o status.
                                        </p>
                                        <a href="{{ route('hotspots.index') }}" class="btn btn-sm btn-outline-success">
                                            <i class="ph ph-list me-1"></i>
                                            Ver Hotspots
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <style>
        .kpi-card {
            transition: transform 0.2s, box-shadow 0.2s;
            border: none;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        }

        .kpi-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .avatar-md {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .bg-light-primary {
            background-color: rgba(var(--bs-primary-rgb), 0.1);
        }

        .bg-light-success {
            background-color: rgba(var(--bs-success-rgb), 0.1);
        }

        .bg-light-info {
            background-color: rgba(var(--bs-info-rgb), 0.1);
        }

        .bg-light-warning {
            background-color: rgba(var(--bs-warning-rgb), 0.1);
        }
    </style>
@endsection
