@extends('layouts.master')
@section('title', 'Editar Empresa')
@section('main-content')
@use('Illuminate\Support\Facades\Storage')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5>@yield('title')</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('empresas.index') }}" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-buildings f-s-16"></i> Empresas</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">@yield('title')</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes da Empresa</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="{{ route('empresas.update', $empresa) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label">Nome <span class="text-danger">*</span></label>
                                        <input type="text" name="name" class="form-control" placeholder="Nome da Empresa" value="{{ old('name', $empresa->name) }}" required>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tipo de Empresa <span class="text-danger">*</span></label>
                                        <select name="tipo_empresa" class="form-select" required>
                                            <option value="">Selecione o tipo</option>
                                            <option value="matriz" {{ old('tipo_empresa', $empresa->tipo_empresa) == 'matriz' ? 'selected' : '' }}>🏛️ Matriz (Sede Principal)</option>
                                            <option value="franquia" {{ old('tipo_empresa', $empresa->tipo_empresa) == 'franquia' ? 'selected' : '' }}>🏢 Franquia</option>
                                            <option value="cliente" {{ old('tipo_empresa', $empresa->tipo_empresa) == 'cliente' ? 'selected' : '' }}>🏪 Cliente da Franquia</option>
                                        </select>
                                        <small class="form-text text-muted">
                                            <strong>Matriz:</strong> Sede principal da rede<br>
                                            <strong>Franquia:</strong> Unidade franqueada<br>
                                            <strong>Cliente:</strong> Cliente que usa os serviços da franquia
                                        </small>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Empresa Pai (Franquia/Matriz)</label>
                                        <select name="empresa_pai_id" class="form-select">
                                            <option value="">Nenhuma (empresa independente)</option>
                                            @foreach(\App\Models\Empresa::where('id', '!=', $empresa->id)->whereIn('tipo_empresa', ['matriz', 'franquia'])->orderBy('name')->get() as $emp)
                                                <option value="{{ $emp->id }}" {{ old('empresa_pai_id', $empresa->empresa_pai_id) == $emp->id ? 'selected' : '' }}>
                                                    {{ $emp->tipo_empresa == 'matriz' ? '🏛️' : '🏢' }} {{ $emp->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <small class="form-text text-muted">Se for cliente, selecione a franquia. Se for franquia, selecione a matriz.</small>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">E-mail</label>
                                        <input type="email" name="email" class="form-control" placeholder="E-mail da Empresa" value="{{ old('email', $empresa->email) }}">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Telefone</label>
                                        <input type="text" name="phone" class="form-control" placeholder="Telefone da Empresa" value="{{ old('phone', $empresa->phone) }}">
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label">Logomarca</label>
                                        @if($empresa->logomarca)
                                            <div class="mb-2">
                                                <img src="{{ Storage::url($empresa->logomarca) }}" alt="Logomarca atual" class="img-thumbnail" style="max-height: 100px;">
                                                <p class="text-muted mt-1 mb-0">Logomarca atual</p>
                                            </div>
                                        @endif
                                        <input type="file" name="logomarca" class="form-control" accept="image/*">
                                        <small class="form-text text-muted">Formatos aceitos: JPEG, PNG, JPG, GIF. Tamanho máximo: 2MB. A imagem será redimensionada para máximo 350px de largura.</small>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <!-- Botão Mercado Pago -->
                                        <a href="{{ route('empresas.mercadopago.edit', $empresa) }}" class="btn btn-info">
                                            <i class="ph-duotone ph-credit-card me-2"></i>Configurar Mercado Pago
                                            @if($empresa->mp_ativo)
                                                <span class="badge bg-success ms-1">Ativo</span>
                                            @else
                                                <span class="badge bg-secondary ms-1">Inativo</span>
                                            @endif
                                        </a>

                                        <!-- Botões de ação -->
                                        <div class="btn-group" role="group">
                                            <button type="submit" class="btn btn-success"><i class="ph-duotone ph-check-circle me-2"></i>Salvar Alterações</button>
                                            <a href="{{ route('empresas.index') }}" class="btn btn-secondary"><i class="ph-duotone ph-x-circle me-2"></i>Cancelar</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    $(document).ready(function(){
        var SPMaskBehavior = function (val) {
          return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        },
        spOptions = {
          onKeyPress: function(val, e, field, options) {
              field.mask(SPMaskBehavior.apply({}, arguments), options);
            }
        };

        $('input[name="phone"]').mask(SPMaskBehavior, spOptions);
    });
</script>
@endpush
