@extends('layouts.master')
@section('title', isset($empresa) ? 'Edit Empresa' : 'Create Empresa')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5>@yield('title')</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('empresas.index') }}" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-buildings f-s-16"></i> Empresas</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">@yield('title')</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Empresa Details</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="{{ isset($empresa) ? route('empresas.update', $empresa) : route('empresas.store') }}" method="POST">
                            @csrf
                            @if(isset($empresa))
                                @method('PUT')
                            @endif
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label">Name</label>
                                        <input type="text" name="name" class="form-control" placeholder="Empresa Name" value="{{ old('name', $empresa->name ?? '') }}" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Email</label>
                                        <input type="email" name="email" class="form-control" placeholder="Empresa Email" value="{{ old('email', $empresa->email ?? '') }}">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Phone</label>
                                        <input type="text" name="phone" class="form-control" placeholder="Empresa Phone" value="{{ old('phone', $empresa->phone ?? '') }}">
                                    </div>
                                </div>

                                <div class="col-12 text-end">
                                    <button type="submit" class="btn btn-success">Submit</button>
                                    <a href="{{ route('empresas.index') }}" class="btn btn-secondary">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
