@extends('layouts.master')
@section('title', 'Configurar Mercado Pago')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5>@yield('title') - {{ $empresa->name }}</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('empresas.index') }}" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-buildings f-s-16"></i> Empresas</span>
                        </a>
                    </li>
                    <li class="">
                        <a href="{{ route('empresas.edit', $empresa) }}" class="f-s-14 f-w-500">
                            <span>{{ $empresa->name }}</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">@yield('title')</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="ph-duotone ph-check-circle me-2"></i>
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ph-duotone ph-x-circle me-2"></i>
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="row">
            <!-- Card de Informações -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="ph-duotone ph-info me-2"></i>Sobre o Mercado Pago</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">Configure as credenciais do Mercado Pago para habilitar pagamentos online para esta empresa.</p>

                        <div class="alert alert-info mt-3">
                            <strong><i class="ph-duotone ph-lightbulb me-2"></i>Onde encontrar as credenciais?</strong>
                            <ol class="mt-2 mb-0">
                                <li>Acesse sua <a href="https://www.mercadopago.com.br/developers/panel" target="_blank">conta Mercado Pago</a></li>
                                <li>Vá em "Suas integrações"</li>
                                <li>Selecione sua aplicação</li>
                                <li>Copie as credenciais</li>
                            </ol>
                        </div>

                        @if($empresa->mp_ativo)
                            <div class="alert alert-success">
                                <i class="ph-duotone ph-check-circle me-2"></i>
                                <strong>Mercado Pago Ativo</strong>
                                <p class="mb-0 mt-1">Esta empresa está configurada para receber pagamentos</p>
                            </div>

                            <button type="button" class="btn btn-warning btn-sm w-100 mt-2" onclick="testarConexao()">
                                <i class="ph-duotone ph-plug me-2"></i>Testar Conexão
                            </button>
                        @else
                            <div class="alert alert-warning">
                                <i class="ph-duotone ph-warning me-2"></i>
                                <strong>Mercado Pago Inativo</strong>
                                <p class="mb-0 mt-1">Configure as credenciais abaixo para ativar</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Card Split Info -->
                @if($empresa->tipo_empresa !== 'matriz')
                <div class="card mt-3">
                    <div class="card-header">
                        <h5><i class="ph-duotone ph-split-horizontal me-2"></i>Split de Pagamentos</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">O split permite dividir automaticamente os pagamentos entre esta empresa e outra (matriz ou franquia).</p>

                        @if($empresa->mp_split_habilitado && $empresa->empresaSplit)
                            <div class="alert alert-info">
                                <strong>Split Ativo</strong>
                                <p class="mb-0 mt-2">
                                    <strong>{{ $empresa->mp_percentual_split }}%</strong> vai para:<br>
                                    <strong>{{ $empresa->empresaSplit->name }}</strong>
                                </p>
                                <p class="mb-0 mt-1">
                                    <strong>{{ 100 - $empresa->mp_percentual_split }}%</strong> fica com:<br>
                                    <strong>{{ $empresa->name }}</strong>
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
                @endif
            </div>

            <!-- Card de Configuração -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5>Credenciais do Mercado Pago</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('empresas.mercadopago.update', $empresa) }}" method="POST" id="formMercadoPago">
                            @csrf
                            @method('PUT')

                            <!-- Ambiente -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <label class="form-label">Ambiente <span class="text-danger">*</span></label>
                                    <div class="d-flex gap-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="mp_ambiente" id="sandbox" value="sandbox"
                                                {{ old('mp_ambiente', $empresa->mp_ambiente) === 'sandbox' ? 'checked' : '' }} required>
                                            <label class="form-check-label" for="sandbox">
                                                <span class="badge bg-warning">Sandbox (Testes)</span>
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="mp_ambiente" id="production" value="production"
                                                {{ old('mp_ambiente', $empresa->mp_ambiente) === 'production' ? 'checked' : '' }} required>
                                            <label class="form-check-label" for="production">
                                                <span class="badge bg-success">Production (Produção)</span>
                                            </label>
                                        </div>
                                    </div>
                                    @error('mp_ambiente')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Public Key -->
                            <div class="row mb-3">
                                <div class="col-12">
                                    <label class="form-label">Public Key (Chave Pública)</label>
                                    <input type="text" name="mp_public_key" class="form-control @error('mp_public_key') is-invalid @enderror"
                                        placeholder="APP_USR-xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
                                        value="{{ old('mp_public_key', $empresa->mp_public_key) }}">
                                    @error('mp_public_key')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="text-muted">Usada no frontend para processar pagamentos</small>
                                </div>
                            </div>

                            <!-- Access Token -->
                            <div class="row mb-3">
                                <div class="col-12">
                                    <label class="form-label">Access Token (Token de Acesso)</label>
                                    <div class="input-group">
                                        <input type="password" name="mp_access_token" id="mp_access_token"
                                            class="form-control @error('mp_access_token') is-invalid @enderror"
                                            placeholder="APP_USR-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
                                            value="{{ old('mp_access_token', $empresa->mp_access_token ? '••••••••••••••••' : '') }}">
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('mp_access_token')">
                                            <i class="ph-duotone ph-eye" id="icon-mp_access_token"></i>
                                        </button>
                                    </div>
                                    @error('mp_access_token')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                    <small class="text-muted">Token secreto - será criptografado no banco</small>
                                </div>
                            </div>

                            <!-- Ativar MP -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="mp_ativo" id="mp_ativo" value="1"
                                            {{ old('mp_ativo', $empresa->mp_ativo) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="mp_ativo">
                                            <strong>Ativar Mercado Pago</strong>
                                        </label>
                                    </div>
                                    <small class="text-muted">Habilita pagamentos via Mercado Pago para esta empresa</small>
                                </div>
                            </div>

                            <hr>

                            <!-- Split de Pagamentos -->
                            @if($empresa->tipo_empresa !== 'matriz')
                            <h6 class="mb-3"><i class="ph-duotone ph-split-horizontal me-2"></i>Configurar Split de Pagamentos</h6>

                            <div class="row mb-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="mp_split_habilitado" id="mp_split_habilitado" value="1"
                                            {{ old('mp_split_habilitado', $empresa->mp_split_habilitado) ? 'checked' : '' }}
                                            onchange="toggleSplitFields()">
                                        <label class="form-check-label" for="mp_split_habilitado">
                                            <strong>Habilitar Split de Pagamentos</strong>
                                        </label>
                                    </div>
                                    <small class="text-muted">Divide pagamentos automaticamente com outra empresa</small>
                                </div>
                            </div>

                            <div id="splitFields" style="{{ old('mp_split_habilitado', $empresa->mp_split_habilitado) ? '' : 'display: none;' }}">
                                <!-- Empresa que recebe o split -->
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Empresa que Recebe o Split <span class="text-danger">*</span></label>
                                        <select name="mp_empresa_split_id" class="form-select @error('mp_empresa_split_id') is-invalid @enderror">
                                            <option value="">Selecione...</option>
                                            @foreach($empresasSplit as $empSplit)
                                                <option value="{{ $empSplit->id }}"
                                                    {{ old('mp_empresa_split_id', $empresa->mp_empresa_split_id) == $empSplit->id ? 'selected' : '' }}>
                                                    {{ $empSplit->name }}
                                                    @if($empSplit->tipo_empresa === 'matriz')
                                                        <span class="badge bg-info">Matriz</span>
                                                    @elseif($empSplit->tipo_empresa === 'franquia')
                                                        <span class="badge bg-primary">Franquia</span>
                                                    @endif
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('mp_empresa_split_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <!-- Percentual do split -->
                                    <div class="col-md-6">
                                        <label class="form-label">Percentual do Split <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" name="mp_percentual_split" class="form-control @error('mp_percentual_split') is-invalid @enderror"
                                                placeholder="20" min="0" max="100" step="0.01"
                                                value="{{ old('mp_percentual_split', $empresa->mp_percentual_split) }}"
                                                onchange="calcularSplit()">
                                            <span class="input-group-text">%</span>
                                        </div>
                                        @error('mp_percentual_split')
                                            <div class="text-danger small mt-1">{{ $message }}</div>
                                        @enderror
                                        <small class="text-muted">Quanto vai para a empresa selecionada</small>
                                    </div>
                                </div>

                                <!-- Simulação de Split -->
                                <div class="alert alert-light border">
                                    <strong><i class="ph-duotone ph-calculator me-2"></i>Simulação:</strong>
                                    <div class="mt-2">
                                        <p class="mb-1">Para um pagamento de <strong>R$ 100,00</strong>:</p>
                                        <ul class="mb-0">
                                            <li id="splitEmpresa">Empresa selecionada: <strong>R$ <span id="valorSplit">0,00</span></strong></li>
                                            <li id="splitAtual">{{ $empresa->name }}: <strong>R$ <span id="valorAtual">100,00</span></strong></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <hr>

                            <!-- Botões -->
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="ph-duotone ph-floppy-disk me-2"></i>Salvar Configurações
                                </button>

                                <a href="{{ route('empresas.edit', $empresa) }}" class="btn btn-secondary">
                                    <i class="ph-duotone ph-arrow-left me-2"></i>Voltar
                                </a>

                                @if($empresa->mp_ativo)
                                <button type="button" class="btn btn-danger ms-auto" onclick="desativarMP()">
                                    <i class="ph-duotone ph-x-circle me-2"></i>Desativar Mercado Pago
                                </button>
                                @endif
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
<script>
// Toggle split fields
function toggleSplitFields() {
    const checkbox = document.getElementById('mp_split_habilitado');
    const fields = document.getElementById('splitFields');
    fields.style.display = checkbox.checked ? 'block' : 'none';

    if (!checkbox.checked) {
        document.querySelector('input[name="mp_percentual_split"]').value = '';
        document.querySelector('select[name="mp_empresa_split_id"]').value = '';
    }
}

// Toggle password visibility
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = document.getElementById('icon-' + fieldId);

    if (field.type === 'password') {
        field.type = 'text';
        icon.className = 'ph-duotone ph-eye-slash';
    } else {
        field.type = 'password';
        icon.className = 'ph-duotone ph-eye';
    }
}

// Calcular split
function calcularSplit() {
    const percentual = parseFloat(document.querySelector('input[name="mp_percentual_split"]').value) || 0;
    const valorTotal = 100;
    const valorSplit = (valorTotal * percentual / 100).toFixed(2);
    const valorAtual = (valorTotal - valorSplit).toFixed(2);

    document.getElementById('valorSplit').textContent = valorSplit.replace('.', ',');
    document.getElementById('valorAtual').textContent = valorAtual.replace('.', ',');
}

// Testar conexão
function testarConexao() {
    fetch('{{ route("empresas.mercadopago.testar", $empresa) }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
        },
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('✅ ' + data.message + '\nAmbiente: ' + data.ambiente);
        } else {
            alert('❌ ' + data.message);
        }
    })
    .catch(error => {
        alert('❌ Erro ao testar conexão: ' + error.message);
    });
}

// Desativar MP
function desativarMP() {
    if (!confirm('Tem certeza que deseja desativar o Mercado Pago para esta empresa?\n\nIsso impedirá novos pagamentos até que seja reativado.')) {
        return;
    }

    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '{{ route("empresas.mercadopago.desativar", $empresa) }}';

    const csrf = document.createElement('input');
    csrf.type = 'hidden';
    csrf.name = '_token';
    csrf.value = '{{ csrf_token() }}';
    form.appendChild(csrf);

    document.body.appendChild(form);
    form.submit();
}

// Inicializar cálculo do split
document.addEventListener('DOMContentLoaded', function() {
    calcularSplit();
});
</script>
@endpush
