@extends('layouts.master')
@section('title', 'Relatório por Publicação')

@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-file-text f-s-16 me-2"></i>Relatório por Publicação</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li>
                        <a href="{{ route('estatisticas.dashboard') }}" class="f-s-14 f-w-500">
                            <span>Dashboard</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Por Publicação</a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Filtros -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form method="GET" action="{{ route('estatisticas.por-publicacao') }}" class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Data Início</label>
                                <input type="date" 
                                       name="data_inicio" 
                                       class="form-control" 
                                       value="{{ request('data_inicio', now()->subDays(30)->format('Y-m-d')) }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Data Fim</label>
                                <input type="date" 
                                       name="data_fim" 
                                       class="form-control" 
                                       value="{{ request('data_fim', now()->format('Y-m-d')) }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-control">
                                    <option value="">Todos</option>
                                    <option value="ativa" {{ request('status') == 'ativa' ? 'selected' : '' }}>Ativa</option>
                                    <option value="pausada" {{ request('status') == 'pausada' ? 'selected' : '' }}>Pausada</option>
                                    <option value="expirada" {{ request('status') == 'expirada' ? 'selected' : '' }}>Expirada</option>
                                </select>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="ph-duotone ph-magnifying-glass me-2"></i>Filtrar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabela de Relatório -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Performance por Publicação</h5>
                        <div>
                            <button class="btn btn-sm btn-outline-success" onclick="exportarExcel()">
                                <i class="ph-duotone ph-file-xls me-1"></i>Exportar Excel
                            </button>
                            <button class="btn btn-sm btn-outline-danger" onclick="exportarPDF()">
                                <i class="ph-duotone ph-file-pdf me-1"></i>Exportar PDF
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0" id="tabelaRelatorio">
                                <thead class="table-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Título</th>
                                        <th>Cliente</th>
                                        <th>Status</th>
                                        <th>Período</th>
                                        <th class="text-end">Impressões</th>
                                        <th class="text-end">Cliques</th>
                                        <th class="text-end">CTR</th>
                                        <th class="text-end">Valor</th>
                                        <th class="text-center">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($publicacoes ?? [] as $pub)
                                    <tr>
                                        <td><strong>#{{ $pub->id }}</strong></td>
                                        <td>
                                            <strong>{{ Str::limit($pub->titulo, 50) }}</strong>
                                        </td>
                                        <td>{{ $pub->cliente_name ?? 'N/A' }}</td>
                                        <td>
                                            <span class="badge bg-{{ $pub->status === 'ativa' ? 'success' : 'secondary' }}">
                                                {{ ucfirst($pub->status) }}
                                            </span>
                                        </td>
                                        <td>
                                            <small>
                                                {{ \Carbon\Carbon::parse($pub->data_inicio)->format('d/m/Y') }}
                                                <br>
                                                {{ \Carbon\Carbon::parse($pub->data_fim)->format('d/m/Y') }}
                                            </small>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-primary">
                                                {{ number_format($pub->total_impressoes ?? 0, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-success">
                                                {{ number_format($pub->total_cliques ?? 0, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            @php
                                                $ctr = isset($pub->total_impressoes) && $pub->total_impressoes > 0 
                                                    ? ($pub->total_cliques / $pub->total_impressoes) * 100 
                                                    : 0;
                                            @endphp
                                            <span class="badge bg-{{ $ctr >= 5 ? 'success' : ($ctr >= 2 ? 'warning' : 'secondary') }}">
                                                {{ number_format($ctr, 2, ',', '.') }}%
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            @if($pub->valor_contrato)
                                                R$ {{ number_format($pub->valor_contrato, 2, ',', '.') }}
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('publicacoes.estatisticas', $pub->id) }}" 
                                                   class="btn btn-outline-primary" 
                                                   title="Ver Estatísticas">
                                                    <i class="ph-duotone ph-chart-line"></i>
                                                </a>
                                                <a href="{{ route('publicacoes.show', $pub->id) }}" 
                                                   class="btn btn-outline-info" 
                                                   title="Ver Detalhes">
                                                    <i class="ph-duotone ph-eye"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="10" class="text-center text-muted py-5">
                                            <i class="ph-duotone ph-info me-2" style="font-size: 2rem;"></i>
                                            <p class="mb-0">Nenhuma publicação encontrada no período selecionado</p>
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                                @if(isset($publicacoes) && $publicacoes->count() > 0)
                                <tfoot class="table-light">
                                    <tr>
                                        <th colspan="5" class="text-end">TOTAIS:</th>
                                        <th class="text-end">
                                            {{ number_format($publicacoes->sum('total_impressoes') ?? 0, 0, ',', '.') }}
                                        </th>
                                        <th class="text-end">
                                            {{ number_format($publicacoes->sum('total_cliques') ?? 0, 0, ',', '.') }}
                                        </th>
                                        <th class="text-end">
                                            @php
                                                $totalImp = $publicacoes->sum('total_impressoes') ?? 0;
                                                $totalClq = $publicacoes->sum('total_cliques') ?? 0;
                                                $ctrTotal = $totalImp > 0 ? ($totalClq / $totalImp) * 100 : 0;
                                            @endphp
                                            {{ number_format($ctrTotal, 2, ',', '.') }}%
                                        </th>
                                        <th class="text-end">
                                            R$ {{ number_format($publicacoes->sum('valor_contrato') ?? 0, 2, ',', '.') }}
                                        </th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    function exportarExcel() {
        alert('Funcionalidade de exportação em desenvolvimento');
        // TODO: Implementar exportação Excel
    }

    function exportarPDF() {
        alert('Funcionalidade de exportação em desenvolvimento');
        // TODO: Implementar exportação PDF
    }
</script>
@endpush
