@extends('layouts.master')
@section('title', 'Group Permissions: ' . $group->name)
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5>@yield('title')</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('groups.index') }}" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-users-three f-s-16"></i> Groups</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Permissions</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Permission Matrix for group: <strong>{{ $group->name }}</strong></h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('groups.permissions.update', $group->id) }}">
                            @csrf
                            @foreach($permissions as $subsystem => $list)
                                <div class="card mb-3">
                                    <div class="card-header"><strong>{{ __($subsystem) }}</strong></div>
                                    <div class="card-body">
                                        @foreach($list as $p)
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" name="permissions[]" id="perm{{ $p->id }}" value="{{ $p->id }}" {{ in_array($p->id, $current) ? 'checked' : '' }}>
                                                <label class="form-check-label" for="perm{{ $p->id }}">{{ $p->action }} ({{ $p->name }})</label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                            <div class="col-12 text-end">
                                <button type="submit" class="btn btn-success">Save Permissions</button>
                                <a href="{{ route('groups.index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
