@extends('layouts.master')
@section('title', 'Hierarquia do Negócio')

@push('styles')
<style>
    /* ========================================
       CONTAINER PRINCIPAL
       ======================================== */
    .orgchart-container {
        overflow-x: auto;
        overflow-y: visible;
        padding: 60px 40px;
        min-height: 600px;
        background: linear-gradient(135deg, #e8ddd3 0%, #d4c5b9 100%);
        border-radius: 12px;
        position: relative;
    }

    .orgchart-wrapper {
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: fit-content;
        padding: 20px;
    }

    /* ========================================
       NÍVEL 1: FRANQUIA (TOPO - VERTICAL)
       ======================================== */
    .level-franchise {
        display: flex;
        flex-direction: column;
        align-items: center;
        position: relative;
        margin-bottom: 80px;
    }

    /* Linha vertical descendo da franquia */
    .level-franchise::after {
        content: '';
        position: absolute;
        width: 3px;
        height: 60px;
        background: #c17767;
        bottom: -60px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 1;
    }

    /* ========================================
       NÍVEL 2: CLIENTES (HORIZONTAL)
       ======================================== */
    .level-clients {
        display: flex;
        flex-direction: row;
        gap: 80px;
        position: relative;
        align-items: flex-start;
        justify-content: center;
    }

    /* Linha horizontal conectando todos os clientes */
    .level-clients::before {
        content: '';
        position: absolute;
        height: 3px;
        background: #c17767;
        top: 0;
        left: 40px;
        right: 40px;
        z-index: 1;
    }

    /* Linha vertical subindo de cada cliente para o eixo horizontal */
    .client-column::before {
        content: '';
        position: absolute;
        width: 3px;
        height: 20px;
        background: #c17767;
        top: -20px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 1;
    }

    /* Ocultar linha do primeiro e último cliente (decoração) */
    .client-column:first-child::after,
    .client-column:last-child::after {
        content: '';
        position: absolute;
        width: 3px;
        height: 3px;
        background: #c17767;
        top: -20px;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 50%;
    }

    .client-column {
        display: flex;
        flex-direction: column;
        align-items: center;
        position: relative;
        margin-top: 20px;
    }

    .client-node {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-bottom: 60px;
        position: relative;
    }

    /* Linha vertical descendo do cliente para usuários */
    .client-node.has-users::after {
        content: '';
        position: absolute;
        width: 3px;
        height: 40px;
        background: #e8a696;
        bottom: -40px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 1;
    }

    /* ========================================
       NÍVEL 3: USUÁRIOS (VERTICAL)
       ======================================== */
    .level-users {
        display: flex;
        flex-direction: column;
        gap: 32px;
        align-items: center;
        position: relative;
    }

    /* Linha vertical conectando todos os usuários */
    .level-users::before {
        content: '';
        position: absolute;
        width: 3px;
        background: #e8a696;
        left: 50%;
        transform: translateX(-50%);
        top: 0;
        bottom: 0;
        z-index: 1;
    }

    /* Ocultar linha se houver apenas 1 usuário */
    .level-users.single-user::before {
        display: none;
    }

    .user-node {
        display: flex;
        flex-direction: row;
        align-items: center;
        gap: 16px;
        position: relative;
        z-index: 2;
    }

    /* ========================================
       AVATARES CIRCULARES
       ======================================== */
    .org-avatar {
        position: relative;
        border-radius: 50%;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    /* Avatar Franquia - Grande (180px) */
    .org-avatar-main {
        width: 180px;
        height: 180px;
        box-shadow:
            0 0 0 8px white,
            0 0 0 14px #c17767,
            0 8px 24px rgba(193, 119, 103, 0.3);
        transition: all 0.3s ease;
        z-index: 3;
    }

    .org-avatar-main:hover {
        transform: scale(1.05);
        box-shadow:
            0 0 0 8px white,
            0 0 0 14px #c17767,
            0 12px 32px rgba(193, 119, 103, 0.4);
    }

    .org-avatar-main .avatar-placeholder {
        width: 160px;
        height: 160px;
        border-radius: 50%;
        background: linear-gradient(135deg, #c17767 0%, #a86556 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 64px;
        font-weight: 700;
        color: white;
    }

    /* Avatar Cliente - Médio (140px) */
    .org-avatar-medium {
        width: 140px;
        height: 140px;
        box-shadow:
            0 0 0 6px white,
            0 0 0 10px #e8a696,
            0 6px 20px rgba(232, 166, 150, 0.3);
        transition: all 0.3s ease;
        z-index: 3;
    }

    .org-avatar-medium:hover {
        transform: scale(1.05);
    }

    .org-avatar-medium .avatar-placeholder {
        width: 124px;
        height: 124px;
        border-radius: 50%;
        background: linear-gradient(135deg, #e8a696 0%, #d4897a 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 48px;
        font-weight: 700;
        color: white;
    }

    /* Avatar Usuário - Pequeno (80px) */
    .org-avatar-small {
        width: 80px;
        height: 80px;
        box-shadow:
            0 0 0 4px white,
            0 0 0 7px #e8a696,
            0 4px 12px rgba(232, 166, 150, 0.2);
        transition: all 0.3s ease;
        z-index: 3;
    }

    .org-avatar-small:hover {
        transform: scale(1.05);
    }

    .org-avatar-small .avatar-placeholder {
        width: 68px;
        height: 68px;
        border-radius: 50%;
        background: linear-gradient(135deg, #f5c3b3 0%, #e8a696 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        font-weight: 700;
        color: white;
    }

    /* ========================================
       CARDS DE INFORMAÇÃO
       ======================================== */
    .org-info {
        background: white;
        border-radius: 12px;
        padding: 16px 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        min-width: 240px;
        max-width: 280px;
        position: relative;
        z-index: 2;
    }

    .org-info-main {
        text-align: center;
        margin-top: 20px;
    }

    .org-info h5 {
        margin: 0 0 8px 0;
        font-size: 16px;
        font-weight: 600;
        color: #4a3f35;
    }

    .org-info p {
        margin: 4px 0;
        font-size: 12px;
        color: #6b5d53;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .org-info p i {
        color: #9b8b7e;
        font-size: 14px;
    }

    /* ========================================
       BADGES
       ======================================== */
    .org-badge {
        display: inline-block;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 8px;
    }

    .org-badge-franquia {
        background: linear-gradient(135deg, #c17767 0%, #8b5e4f 100%);
        color: white;
    }

    .org-badge-aprovado {
        background: linear-gradient(135deg, #e8a696 0%, #d4897a 100%);
        color: white;
    }

    .org-badge-pendente {
        background: linear-gradient(135deg, #f5b895 0%, #e8a67d 100%);
        color: white;
    }

    .org-badge-rejeitado {
        background: #c17767;
        color: white;
    }

    .org-counter {
        text-align: center;
        padding: 8px 12px;
        background: #f5ede7;
        border-radius: 8px;
        margin-top: 8px;
        font-size: 12px;
        color: #6b5d53;
    }

    .org-counter strong {
        color: #4a3f35;
        font-size: 14px;
    }

    /* ========================================
       STATS CARDS
       ======================================== */
    .stats-card {
        border-radius: 12px;
        padding: 20px;
        background: white;
        border: 1px solid #e9e5e1;
        transition: all 0.3s ease;
    }

    .stats-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }

    .stats-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
    }

    /* ========================================
       EMPTY STATE
       ======================================== */
    .orgchart-empty {
        text-align: center;
        padding: 60px 40px;
        color: #6b5d53;
    }

    .orgchart-empty i {
        font-size: 64px;
        color: #c5b5a7;
        margin-bottom: 16px;
    }

    /* ========================================
       RESPONSIVE
       ======================================== */
    @media (max-width: 1400px) {
        .level-clients {
            gap: 60px;
        }
    }

    @media (max-width: 1200px) {
        .level-clients {
            flex-direction: column;
            gap: 40px;
            align-items: center;
        }

        /* Ocultar todas as linhas conectoras em mobile */
        .level-franchise::after,
        .level-clients::before,
        .client-column::before,
        .client-node.has-users::after,
        .level-users::before {
            display: none !important;
        }

        .client-column {
            margin-top: 0;
        }
    }
</style>
@endpush

@section('main-content')
<div class="container-fluid">
    <!-- Breadcrumb -->
    <div class="row m-1">
        <div class="col-12">
            <h5><i class="ph-duotone ph-tree-structure f-s-16 me-2"></i>Hierarquia do Negócio</h5>
            <ul class="app-line-breadcrumbs mb-3">
                <li>
                    <a href="{{ route('dashboard') }}" class="f-s-14 f-w-500">
                        <span>Dashboard</span>
                    </a>
                </li>
                <li class="active">
                    <a href="#" class="f-s-14 f-w-500">Hierarquia</a>
                </li>
            </ul>
        </div>
    </div>

    @if($tipo === 'franquia')
        <!-- VISUALIZAÇÃO FRANQUEADO -->

        <!-- Estatísticas Rápidas -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="d-flex align-items-center">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #c17767 0%, #8b5e4f 100%); color: white;">
                            <i class="ph-duotone ph-buildings"></i>
                        </div>
                        <div class="ms-3">
                            <h6 class="mb-0 text-muted">Clientes</h6>
                            <h3 class="mb-0">{{ $totalClientes }}</h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="d-flex align-items-center">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #e8a696 0%, #d4897a 100%); color: white;">
                            <i class="ph-duotone ph-users"></i>
                        </div>
                        <div class="ms-3">
                            <h6 class="mb-0 text-muted">Total Usuários</h6>
                            <h3 class="mb-0">{{ $totalUsuarios }}</h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="d-flex align-items-center">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #a8d8a8 0%, #7ec77e 100%); color: white;">
                            <i class="ph-duotone ph-check-circle"></i>
                        </div>
                        <div class="ms-3">
                            <h6 class="mb-0 text-muted">Ativos</h6>
                            <h3 class="mb-0">{{ $clientesAtivos }}</h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <div class="d-flex align-items-center">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #f5b895 0%, #e8a67d 100%); color: white;">
                            <i class="ph-duotone ph-clock"></i>
                        </div>
                        <div class="ms-3">
                            <h6 class="mb-0 text-muted">Pendentes</h6>
                            <h3 class="mb-0">{{ $clientesPendentes }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Organograma -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #c17767 0%, #8b5e4f 100%); color: white;">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-tree-structure me-2"></i>
                            Organograma - Layout Misto
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="orgchart-container">
                            @if($clientes->count() > 0)
                                <div class="orgchart-wrapper">

                                    <!-- NÍVEL 1: FRANQUIA (TOPO) -->
                                    <div class="level-franchise">
                                        <div class="org-avatar org-avatar-main">
                                            <div class="avatar-placeholder">
                                                {{ strtoupper(substr($franquia->name, 0, 1)) }}
                                            </div>
                                        </div>
                                        <div class="org-info org-info-main">
                                            <h5>{{ $franquia->name }}</h5>
                                            <span class="org-badge org-badge-franquia">FRANQUIA</span>
                                            @if($franquia->email)
                                                <p><i class="ph ph-at"></i> {{ Str::limit($franquia->email, 22) }}</p>
                                            @endif
                                            @if($franquia->phone)
                                                <p><i class="ph ph-phone"></i> {{ $franquia->phone }}</p>
                                            @endif
                                            <div class="org-counter">
                                                <strong>{{ $usuariosFranquia->count() }}</strong> usuário(s)
                                            </div>
                                        </div>
                                    </div>

                                    <!-- NÍVEL 2: CLIENTES (HORIZONTAL) -->
                                    <div class="level-clients">
                                        @foreach($clientes as $cliente)
                                            <div class="client-column">
                                                <div class="client-node {{ $cliente->usuarios->count() > 0 ? 'has-users' : '' }}">
                                                    <div class="org-avatar org-avatar-medium">
                                                        <div class="avatar-placeholder">
                                                            {{ strtoupper(substr($cliente->name, 0, 1)) }}
                                                        </div>
                                                    </div>

                                                    <div class="org-info" style="margin-top: 16px; text-align: center;">
                                                        <h5>{{ Str::limit($cliente->name, 22) }}</h5>
                                                        @if($cliente->status_aprovacao === 'aprovado')
                                                            <span class="org-badge org-badge-aprovado">Aprovado</span>
                                                        @elseif($cliente->status_aprovacao === 'pendente')
                                                            <span class="org-badge org-badge-pendente">Pendente</span>
                                                        @else
                                                            <span class="org-badge org-badge-rejeitado">Rejeitado</span>
                                                        @endif
                                                        @if($cliente->email)
                                                            <p><i class="ph ph-at"></i> {{ Str::limit($cliente->email, 20) }}</p>
                                                        @endif
                                                        @if($cliente->phone)
                                                            <p><i class="ph ph-phone"></i> {{ $cliente->phone }}</p>
                                                        @endif
                                                        <div class="org-counter">
                                                            <strong>{{ $cliente->usuarios->count() }}</strong> usuário(s)
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- NÍVEL 3: USUÁRIOS (VERTICAL) -->
                                                @if($cliente->usuarios->count() > 0)
                                                    <div class="level-users {{ $cliente->usuarios->count() == 1 ? 'single-user' : '' }}">
                                                        @foreach($cliente->usuarios as $usuario)
                                                            <div class="user-node">
                                                                <div class="org-avatar org-avatar-small">
                                                                    <div class="avatar-placeholder">
                                                                        {{ strtoupper(substr($usuario->name, 0, 1)) }}
                                                                    </div>
                                                                </div>

                                                                <div class="org-info" style="min-width: 200px; max-width: 220px;">
                                                                    <h5>{{ $usuario->name }}</h5>
                                                                    <p style="font-size: 11px;">{{ Str::limit($usuario->email, 20) }}</p>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>

                                </div>
                            @else
                                <div class="orgchart-empty">
                                    <i class="ph-duotone ph-buildings"></i>
                                    <h5>Nenhum cliente cadastrado</h5>
                                    <p class="mb-0">Esta franquia ainda não possui clientes vinculados.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @else
        <!-- VISUALIZAÇÃO SUPERADMIN -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header" style="background: linear-gradient(135deg, #c17767 0%, #8b5e4f 100%); color: white;">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-tree-structure me-2"></i>
                            Visão Geral - Todas as Franquias
                        </h5>
                    </div>
                    <div class="card-body p-4">
                        <div class="alert alert-info">
                            <i class="ph ph-info me-2"></i>
                            <strong>{{ $totalFranquias }}</strong> franquias |
                            <strong>{{ $totalClientes }}</strong> clientes |
                            <strong>{{ $totalUsuarios }}</strong> usuários no sistema
                        </div>

                        @foreach($franquias as $franquia)
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h5 class="mb-3">
                                        <i class="ph-duotone ph-buildings me-2" style="color: #c17767;"></i>
                                        {{ $franquia->name }}
                                        <span class="badge" style="background: #c17767;">{{ $franquia->clientes_count }} clientes</span>
                                    </h5>

                                    @if($franquia->clientes->count() > 0)
                                        <div class="row g-3">
                                            @foreach($franquia->clientes as $cliente)
                                                <div class="col-md-4">
                                                    <div class="card border-start border-3" style="border-color: #e8a696 !important;">
                                                        <div class="card-body p-3">
                                                            <h6 class="mb-1">{{ $cliente->name }}</h6>
                                                            <small class="text-muted">{{ $cliente->usuarios->count() }} usuário(s)</small>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @else
                                        <p class="text-muted mb-0">Nenhum cliente cadastrado.</p>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
