<!-- Menu Navigation starts -->
<nav>
    <div class="app-logo">
        <a class="logo d-inline-block freefi-logo-link" href="{{route('dashboard')}}">
            <img alt="FreeFi Logo" src="{{asset('assets/images/logo/freefi-logo.png')}}" class="freefi-logo-img">
        </a>

        <span class="bg-light-primary toggle-semi-nav d-flex-center">
                <i class="ti ti-chevron-right"></i>
            </span>

        <div class="d-flex align-items-center nav-profile p-3">
                <span class="h-45 w-45 d-flex-center b-r-10 position-relative bg-danger m-auto">
                    <img alt="avatar" class="img-fluid b-r-10" src="{{asset('assets/images/avatar/' . (Auth::user()->avatar ?? '1.png'))}}">
                    <span class="position-absolute top-0 end-0 p-1 bg-success border border-light rounded-circle"></span>
                </span>
            <div class="flex-grow-1 ps-2">
                <h6 class="text-primary mb-0"> {{ Auth::user()->name }}</h6>
            </div>


            <div class="dropdown profile-menu-dropdown">
                <a aria-expanded="false" data-bs-auto-close="true" data-bs-placement="top" data-bs-toggle="dropdown"
                   role="button">
                    <i class="ti ti-settings fs-5"></i>
                </a>
                <ul class="dropdown-menu">
                    <li class="dropdown-item">
                        <a class="f-w-500" href="{{ route('profile.edit') }}">
                            <i class="ph-duotone  ph-user-circle pe-1 f-s-20"></i> {{ __('Profile') }}
                        </a>
                    </li>
                    <li class="dropdown-item">
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf

                            <a class="mb-0 text-danger" href="{{ route('logout') }}"
                                    onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                <i class="ph-duotone  ph-sign-out pe-1 f-s-20"></i> {{ __('Log Out') }}
                            </a>
                        </form>
                    </li>
                </ul>
            </div>

        </div>
    </div>
    <div class="app-nav" id="app-simple-bar">
        <ul class="main-nav p-0 mt-2">
            <li class="no-sub">
                <a href="{{route('dashboard')}}">
                    <svg stroke="currentColor" stroke-width="1.5">
                        <use xlink:href="{{asset('assets/svg/_sprite.svg#home')}}"></use>
                    </svg>
                    <span>{{ __('Dashboard') }}</span>
                </a>
            </li>
            {{-- Menu condicional baseado no tipo de usuário --}}

            @if(Auth::user()->is_superadmin)
                {{-- ============================================ --}}
                {{-- MENU SUPERADMIN --}}
                {{-- ============================================ --}}
                <li class="no-sub">
                    <a href="{{route('hierarchy.index')}}">
                        <i class="ph-duotone ph-tree-structure f-s-20"></i>
                        <span>Hierarquia Global</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{route('users.index')}}">
                        <i class="ph-duotone ph-users f-s-20"></i>
                        <span>{{ __('Users') }}</span>
                    </a>
                </li>
                <li>
                    <a aria-expanded="false" data-bs-toggle="collapse" href="#franchise">
                        <i class="ph-duotone ph-buildings f-s-20"></i>
                        Empresas
                    </a>
                    <ul class="collapse" id="franchise">
                        <li><a href="{{ route('empresas.index') }}">Todas as Empresas</a></li>
                        <li><a href="{{ route('empresas.index', ['tipo' => 'franquia']) }}">Franquias</a></li>
                        <li><a href="{{ route('empresas.index', ['tipo' => 'cliente']) }}">Clientes</a></li>
                    </ul>
                </li>
                <li class="no-sub">
                    <a href="{{route('hotspots.index')}}">
                        <i class="ph-duotone ph-wifi-high f-s-20"></i>
                        <span>Hotspots</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('midias.index') }}">
                        <i class="ph-duotone ph-image f-s-20"></i>
                        <span>Criativos</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('publicacoes.index') }}">
                        <i class="ph-duotone ph-broadcast f-s-20"></i>
                        <span>Publicações</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('tawkto.index') }}">
                        <i class="ph-duotone ph-chat-circle-dots f-s-20"></i>
                        <span>Chat Tawk.to</span>
                    </a>
                </li>

            @elseif(Auth::user()->isFranchiseUser())
                {{-- ============================================ --}}
                {{-- MENU FRANQUIA --}}
                {{-- Suporta empresa_id (legado) E empresa_user (múltiplas franquias) --}}
                {{-- ============================================ --}}
                <li class="no-sub">
                    <a href="{{route('hierarchy.index')}}">
                        <i class="ph-duotone ph-tree-structure f-s-20"></i>
                        <span>Hierarquia do Negócio</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{route('users.index')}}">
                        <i class="ph-duotone ph-users f-s-20"></i>
                        <span>Meus Usuários</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{route('clientes.index')}}">
                        <i class="ph-duotone ph-buildings f-s-20"></i>
                        <span>Meus Clientes</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{route('hotspots.index')}}">
                        <i class="ph-duotone ph-wifi-high f-s-20"></i>
                        <span>Hotspots</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('midias.index') }}">
                        <i class="ph-duotone ph-image f-s-20"></i>
                        <span>Criativos</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('publicacoes.index') }}">
                        <i class="ph-duotone ph-broadcast f-s-20"></i>
                        <span>Publicações</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('tawkto.index') }}">
                        <i class="ph-duotone ph-chat-circle-dots f-s-20"></i>
                        <span>Chat Tawk.to</span>
                    </a>
                </li>

            @elseif(Auth::user()->empresa && Auth::user()->empresa->tipo_empresa === 'cliente')
                {{-- ============================================ --}}
                {{-- MENU CLIENTE --}}
                {{-- ============================================ --}}
                <li class="no-sub">
                    <a href="{{ route('midias.index') }}">
                        <i class="ph-duotone ph-image f-s-20"></i>
                        <span>Criativos</span>
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('publicacoes.index') }}">
                        <i class="ph-duotone ph-broadcast f-s-20"></i>
                        <span>Publicações</span>
                    </a>
                </li>

            @else
                {{-- ============================================ --}}
                {{-- MENU FALLBACK (usuário sem empresa) --}}
                {{-- ============================================ --}}
                <li class="no-sub">
                    <a href="#">
                        <i class="ph-duotone ph-warning f-s-20"></i>
                        <span>Sem Permissões</span>
                    </a>
                </li>
            @endif
            {{-- 
                Access Control menu removido temporariamente (17/10/2025)
                Sistema de Groups/Permissions será implementado na FASE 3
                Ver: ANALISE-GROUPS-PERMISSIONS.md
            --}}
        </ul>
    </div>

    <div class="menu-navs">
        <span class="menu-previous"><i class="ti ti-chevron-left"></i></span>
        <span class="menu-next"><i class="ti ti-chevron-right"></i></span>
    </div>

</nav>
<!-- Menu Navigation ends -->

<style>
/* FreeFi Logo Customization - Optimized for Sidebar */
.app-logo {
    padding: 10px 0 !important;
}

.freefi-logo-link {
    display: flex !important;
    align-items: center;
    justify-content: center;
    width: 100%;
    padding: 5px 10px !important;
    margin: 0 !important;
}

.freefi-logo-img {
    width: 100% !important;
    max-width: 180px !important;
    height: auto !important;
    object-fit: contain;
    object-position: center;
}

/* Responsivo - quando sidebar minimiza */
nav.mini-nav .freefi-logo-img {
    max-width: 50px !important;
}

/* Dark mode support */
[data-theme="dark"] .freefi-logo-img {
    filter: brightness(1.1);
}
</style>
