<section>
    @if (session('status') === 'profile-updated')
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="ph-duotone ph-check-circle me-2"></i>
            Perfil atualizado com sucesso!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <form id="send-verification" method="post" action="{{ route('verification.send') }}">
        @csrf
    </form>

    <form method="post" action="{{ route('profile.update') }}" class="app-form">
        @csrf
        @method('patch')

        <div class="row">
            <!-- Avatar Selection -->
            <div class="col-12 mb-4">
                <label class="form-label fw-bold">Avatar</label>
                <p class="text-muted small">Escolha um avatar para seu perfil</p>
                
                <div class="row g-3">
                    @php
                        $avatars = ['1.png', '2.png', '3.png', '4.png', '5.png', '6.png', '07.png', '08.png', '09.png', '10.png', '11.png', '12.png', '13.png', '14.png', '15.png', '16.png'];
                        $currentAvatar = old('avatar', $user->avatar ?? '1.png');
                    @endphp
                    
                    @foreach($avatars as $avatar)
                        <div class="col-6 col-sm-4 col-md-3 col-lg-2">
                            <label class="avatar-option">
                                <input type="radio" name="avatar" value="{{ $avatar }}" 
                                       @if($currentAvatar == $avatar) checked @endif
                                       class="avatar-radio">
                                <div class="avatar-wrapper {{ $currentAvatar == $avatar ? 'selected' : '' }}">
                                    <img src="{{ asset('assets/images/avatar/' . $avatar) }}" 
                                         alt="Avatar {{ $avatar }}" 
                                         class="img-fluid rounded-circle">
                                    <div class="avatar-check">
                                        <i class="ph-duotone ph-check-circle"></i>
                                    </div>
                                </div>
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Name -->
            <div class="col-md-6 mb-3">
                <label for="name" class="form-label">Nome <span class="text-danger">*</span></label>
                <input id="name" name="name" type="text" class="form-control @error('name') is-invalid @enderror" 
                       value="{{ old('name', $user->name) }}" required autofocus autocomplete="name">
                @error('name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <!-- Email -->
            <div class="col-md-6 mb-3">
                <label for="email" class="form-label">E-mail <span class="text-danger">*</span></label>
                <input id="email" name="email" type="email" class="form-control @error('email') is-invalid @enderror" 
                       value="{{ old('email', $user->email) }}" required autocomplete="username">
                @error('email')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror

                @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                    <div class="alert alert-warning mt-2 mb-0">
                        <small>
                            Seu endereço de e-mail não está verificado.
                            <button type="button" form="send-verification" class="btn btn-link btn-sm p-0 m-0 align-baseline text-decoration-underline">
                                Clique aqui para reenviar o e-mail de verificação.
                            </button>
                        </small>
                    </div>

                    @if (session('status') === 'verification-link-sent')
                        <div class="alert alert-info mt-2 mb-0">
                            <small>Um novo link de verificação foi enviado para seu endereço de e-mail.</small>
                        </div>
                    @endif
                @endif
            </div>
        </div>

        <div class="d-flex align-items-center gap-3 mt-3">
            <button type="submit" class="btn btn-primary">
                <i class="ph-duotone ph-floppy-disk me-2"></i>
                Salvar Alterações
            </button>

            @if (session('status') === 'profile-updated')
                <span class="text-success small">
                    <i class="ph-duotone ph-check-circle me-1"></i>
                    Salvo.
                </span>
            @endif
        </div>
    </form>
</section>

<style>
    .avatar-option {
        cursor: pointer;
        display: block;
        position: relative;
        margin-bottom: 0;
    }

    .avatar-radio {
        position: absolute;
        opacity: 0;
        pointer-events: none;
    }

    .avatar-wrapper {
        position: relative;
        border: 3px solid transparent;
        border-radius: 50%;
        padding: 3px;
        transition: all 0.3s ease;
        background: #fff;
    }

    .avatar-wrapper:hover {
        border-color: #e9ecef;
        transform: scale(1.05);
    }

    .avatar-wrapper.selected {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }

    .avatar-wrapper img {
        width: 100%;
        height: auto;
        display: block;
    }

    .avatar-check {
        position: absolute;
        top: -5px;
        right: -5px;
        background: #0d6efd;
        color: white;
        border-radius: 50%;
        width: 28px;
        height: 28px;
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transform: scale(0);
        transition: all 0.3s ease;
        font-size: 18px;
    }

    .avatar-wrapper.selected .avatar-check {
        opacity: 1;
        transform: scale(1);
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const radioInputs = document.querySelectorAll('.avatar-radio');
        
        radioInputs.forEach(radio => {
            radio.addEventListener('change', function() {
                // Remove selected class from all wrappers
                document.querySelectorAll('.avatar-wrapper').forEach(wrapper => {
                    wrapper.classList.remove('selected');
                });
                
                // Add selected class to the checked radio's wrapper
                if (this.checked) {
                    this.closest('.avatar-option').querySelector('.avatar-wrapper').classList.add('selected');
                }
            });
        });
    });
</script>
