@extends('layouts.master')
@section('title', 'Editar Publicação')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-broadcast f-s-16 me-2"></i>Editar Publicação</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li>
                        <a href="{{ route('publicacoes.index') }}" class="f-s-14 f-w-500">
                            <span>Publicações</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Editar</a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes da Publicação</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="{{ route('publicacoes.update', $publicacao) }}" method="POST">
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <!-- Criativo -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Criativo <span class="text-danger">*</span></label>
                                        <select id="criativo_id_select" name="criativo_id" class="form-control @error('criativo_id') is-invalid @enderror" required>
                                            <option value="">Selecione um criativo...</option>
                                            @foreach($criativos as $criativo)
                                                <option value="{{ $criativo->id }}" @if(old('criativo_id', $publicacao->criativo_id) == $criativo->id) selected @endif>
                                                    {{ $criativo->title }} ({{ ucfirst($criativo->tipo ?? 'imagem') }})
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('criativo_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">
                                            Apenas criativos aprovados estão disponíveis
                                        </small>
                                    </div>
                                </div>

                                <!-- Preview do Criativo -->
                                <div class="col-md-6">
                                    <div id="criativo-preview-container" style="display: none;" class="mb-3">
                                        <div class="card bg-light h-100">
                                            <div class="card-body p-2">
                                                <h6 class="card-title mb-2 f-s-12">
                                                    <i class="ph-duotone ph-image me-1"></i>Preview
                                                </h6>
                                                <div id="criativo-preview-media" style="min-height: 150px; display: flex; align-items: center; justify-content: center; background-color: #f8f9fa; border-radius: 4px; overflow: hidden;">
                                                    <span class="text-muted f-s-12">Carregando...</span>
                                                </div>
                                                <div class="criativo-details mt-2">
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Título:</strong> <span id="criativo-title"></span>
                                                    </p>
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Tipo:</strong> <span id="criativo-type"></span>
                                                    </p>
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Empresa:</strong> <span id="criativo-empresa"></span>
                                                    </p>
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Dimensões:</strong> <span id="criativo-dimensions"></span>
                                                    </p>
                                                    <p class="mb-0 f-s-11">
                                                        <strong>Tamanho:</strong> <span id="criativo-size"></span>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Título -->
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">Título da Campanha <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               name="titulo" 
                                               class="form-control @error('titulo') is-invalid @enderror" 
                                               placeholder="Ex: Campanha Black Friday 2025" 
                                               value="{{ old('titulo', $publicacao->titulo) }}" 
                                               required>
                                        @error('titulo')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Relacionamentos</h6></div>

                                <!-- Franquia -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Franquia (Vendedor) <span class="text-danger">*</span></label>
                                        <select name="franquia_id" class="form-control @error('franquia_id') is-invalid @enderror" required>
                                            <option value="">Selecione uma franquia...</option>
                                            @foreach($franquias as $franquia)
                                                <option value="{{ $franquia->id }}" @if(old('franquia_id', $publicacao->franquia_id) == $franquia->id) selected @endif>
                                                    {{ $franquia->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('franquia_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Cliente -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Cliente (Comprador) <span class="text-danger">*</span></label>
                                        <select name="cliente_id" class="form-control @error('cliente_id') is-invalid @enderror" required>
                                            <option value="">Selecione um cliente...</option>
                                            @foreach($clientes as $cliente)
                                                <option value="{{ $cliente->id }}" @if(old('cliente_id', $publicacao->cliente_id) == $cliente->id) selected @endif>
                                                    {{ $cliente->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('cliente_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Alcance da Publicação</h6></div>

                                <!-- Tipo de Alcance -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Tipo de Alcance <span class="text-danger">*</span></label>
                                        <select name="tipo_alcance" id="tipo_alcance" class="form-control @error('tipo_alcance') is-invalid @enderror" required>
                                            <option value="todos" @if(old('tipo_alcance', $publicacao->tipo_alcance) == 'todos') selected @endif>Todos os equipamentos</option>
                                            <option value="serial_especifico" @if(old('tipo_alcance', $publicacao->tipo_alcance) == 'serial_especifico') selected @endif>Serial Específico</option>
                                            <option value="empresa" @if(old('tipo_alcance', $publicacao->tipo_alcance) == 'empresa') selected @endif>Empresa Específica</option>
                                        </select>
                                        @error('tipo_alcance')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">
                                            Define se a publicação será exibida em todos equipamentos, apenas um específico ou em todos os equipamentos de uma empresa
                                        </small>
                                    </div>
                                </div>

                                <!-- Equipment Serial (condicional) -->
                                <div class="col-md-4" id="serial_field" style="display: {{ old('tipo_alcance', $publicacao->tipo_alcance) == 'serial_especifico' ? 'block' : 'none' }};">
                                    <div class="mb-3">
                                        <label class="form-label">Serial do Equipamento <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               name="equipment_serial" 
                                               class="form-control @error('equipment_serial') is-invalid @enderror" 
                                               placeholder="Ex: ABC123456" 
                                               value="{{ old('equipment_serial', $publicacao->equipment_serial) }}">
                                        @error('equipment_serial')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Empresa Específica (condicional) -->
                                <div class="col-md-4" id="empresa_field" style="display: {{ old('tipo_alcance', $publicacao->tipo_alcance) == 'empresa' ? 'block' : 'none' }};">
                                    <div class="mb-3">
                                        <label class="form-label">Empresa <span class="text-danger">*</span></label>
                                        <select name="empresa_alcance_id" 
                                               class="form-control @error('empresa_alcance_id') is-invalid @enderror">
                                            <option value="">Selecione uma empresa</option>
                                            @foreach($clientes as $cliente)
                                                <option value="{{ $cliente->id }}" @if(old('empresa_alcance_id', $publicacao->empresa_alcance_id) == $cliente->id) selected @endif>
                                                    {{ $cliente->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('empresa_alcance_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">
                                            Sistema de grupos será implementado futuramente
                                        </small>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Configuração de Tracking e Cliques</h6></div>

                                <!-- Link de Destino -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Link de Destino (URL)</label>
                                        <input type="text"
                                               name="link_destino"
                                               id="link_destino"
                                               class="form-control @error('link_destino') is-invalid @enderror"
                                               placeholder="https://exemplo.com/oferta ou # para desabilitar"
                                               value="{{ old('link_destino', $publicacao->link_destino) }}">
                                        @error('link_destino')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">
                                            URL para onde o usuário será redirecionado ao clicar no anúncio. Use # para link inativo.
                                        </small>
                                    </div>
                                </div>

                                <!-- Habilitar Clique -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label d-block">Opções de Interação</label>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="habilitar_clique" 
                                                   id="habilitar_clique"
                                                   value="1"
                                                   {{ old('habilitar_clique', $publicacao->habilitar_clique) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="habilitar_clique">
                                                🖱️ Habilitar cliques no anúncio
                                            </label>
                                        </div>
                                        <div class="form-check form-switch mt-2">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="track_impressoes" 
                                                   id="track_impressoes"
                                                   value="1"
                                                   {{ old('track_impressoes', $publicacao->track_impressoes) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="track_impressoes">
                                                👁️ Rastrear impressões (visualizações)
                                            </label>
                                        </div>
                                        <div class="form-check form-switch mt-2">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="track_cliques" 
                                                   id="track_cliques"
                                                   value="1"
                                                   {{ old('track_cliques', $publicacao->track_cliques) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="track_cliques">
                                                🎯 Rastrear cliques no anúncio
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12">
                                    <h6 class="mb-2">
                                        Walled Garden - Domínios/IPs Liberados
                                        <small class="text-muted">(Opcional)</small>
                                    </h6>
                                    <p class="text-muted small mb-3">
                                        <i class="ph-duotone ph-shield-check me-1"></i>
                                        Configure domínios, IPs ou subnets que serão liberados no hotspot 
                                        <strong>antes da autenticação</strong> para permitir carregamento de conteúdo externo.
                                    </p>
                                </div>

                                <!-- Container de Walled Gardens -->
                                <div class="col-12">
                                    <div id="walledGardensContainer">
                                        <!-- Items serão adicionados aqui via JavaScript -->
                                    </div>
                                    
                                    <button type="button" 
                                            class="btn btn-outline-primary btn-sm mt-2" 
                                            id="addWalledGarden">
                                        <i class="ph-duotone ph-plus-circle me-1"></i>Adicionar Domínio/IP
                                    </button>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Período de Exibição</h6></div>

                                <!-- Data Início -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data de Início <span class="text-danger">*</span></label>
                                        <input type="date" 
                                               name="data_inicio" 
                                               class="form-control @error('data_inicio') is-invalid @enderror" 
                                               value="{{ old('data_inicio', $publicacao->data_inicio->format('Y-m-d')) }}" 
                                               required>
                                        @error('data_inicio')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Data Fim -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data de Término <span class="text-danger">*</span></label>
                                        <input type="date" 
                                               name="data_fim" 
                                               class="form-control @error('data_fim') is-invalid @enderror" 
                                               value="{{ old('data_fim', $publicacao->data_fim->format('Y-m-d')) }}" 
                                               required>
                                        @error('data_fim')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Valores Comerciais</h6></div>

                                <!-- Valor do Contrato -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Valor do Contrato (R$)</label>
                                        <input type="number" 
                                               name="valor_contrato" 
                                               class="form-control @error('valor_contrato') is-invalid @enderror" 
                                               placeholder="0.00" 
                                               step="0.01"
                                               min="0"
                                               value="{{ old('valor_contrato', $publicacao->valor_contrato) }}">
                                        @error('valor_contrato')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Impressões Contratadas -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Impressões Contratadas</label>
                                        <input type="number" 
                                               name="impressoes_contratadas" 
                                               class="form-control @error('impressoes_contratadas') is-invalid @enderror" 
                                               placeholder="0" 
                                               min="0"
                                               value="{{ old('impressoes_contratadas', $publicacao->impressoes_contratadas) }}">
                                        @error('impressoes_contratadas')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Status -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Status <span class="text-danger">*</span></label>
                                        <select name="status" class="form-control @error('status') is-invalid @enderror" required>
                                            <option value="ativa" @if(old('status', $publicacao->status) == 'ativa') selected @endif>Ativa</option>
                                            <option value="pausada" @if(old('status', $publicacao->status) == 'pausada') selected @endif>Pausada</option>
                                            <option value="expirada" @if(old('status', $publicacao->status) == 'expirada') selected @endif>Expirada</option>
                                            <option value="cancelada" @if(old('status', $publicacao->status) == 'cancelada') selected @endif>Cancelada</option>
                                        </select>
                                        @error('status')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Info adicional -->
                                @if($publicacao->publicadoPor)
                                    <div class="col-12">
                                        <div class="alert alert-info">
                                            <i class="ph-duotone ph-info me-2"></i>
                                            <strong>Publicado por:</strong> {{ $publicacao->publicadoPor->name }} 
                                            em {{ $publicacao->publicada_em->format('d/m/Y H:i') }}
                                        </div>
                                    </div>
                                @endif

                                <div class="col-12 text-end mt-3">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-success">
                                            <i class="ph-duotone ph-floppy-disk me-2"></i>Atualizar Publicação
                                        </button>
                                        <a href="{{ route('publicacoes.index') }}" class="btn btn-secondary">
                                            <i class="ph-duotone ph-x-circle me-2"></i>Cancelar
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // === WALLED GARDENS DINÂMICOS ===
        let walledGardenCounter = 0;

        function createWalledGardenRow(data = {}) {
            const index = data.id ? `existing_${data.id}` : `new_${walledGardenCounter++}`;
            const row = document.createElement('div');
            row.className = 'card mb-3 walled-garden-item';
            row.dataset.index = index;
            
            row.innerHTML = `
                <div class="card-body">
                    <div class="row align-items-end">
                        ${data.id ? `<input type="hidden" name="walled_gardens[${index}][id]" value="${data.id}">` : ''}
                        <div class="col-md-3">
                            <label class="form-label">Tipo</label>
                            <select name="walled_gardens[${index}][tipo]" 
                                    class="form-control walled-garden-tipo" 
                                    data-index="${index}">
                                <option value="domain" ${data.tipo === 'domain' ? 'selected' : ''}>🌐 Domínio</option>
                                <option value="ip" ${data.tipo === 'ip' ? 'selected' : ''}>📡 IP</option>
                                <option value="subnet" ${data.tipo === 'subnet' ? 'selected' : ''}>🔒 Subnet</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Endereço <span class="text-danger">*</span></label>
                            <input type="text" 
                                   name="walled_gardens[${index}][endereco]" 
                                   class="form-control walled-garden-endereco"
                                   placeholder="exemplo.com"
                                   value="${data.endereco || ''}"
                                   required>
                            <small class="form-text text-muted walled-garden-hint">
                                Ex: exemplo.com
                            </small>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Descrição (Opcional)</label>
                            <input type="text" 
                                   name="walled_gardens[${index}][descricao]" 
                                   class="form-control"
                                   placeholder="Ex: CDN de imagens"
                                   value="${data.descricao || ''}">
                        </div>
                        <div class="col-md-1">
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="walled_gardens[${index}][ativo]" 
                                       value="1"
                                       ${data.ativo !== false ? 'checked' : ''}
                                       title="Ativo">
                            </div>
                        </div>
                        <div class="col-md-1">
                            <button type="button" 
                                    class="btn btn-danger btn-sm w-100 remove-walled-garden"
                                    title="Remover">
                                <i class="ph-duotone ph-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            `;
            
            return row;
        }

        // Adicionar evento para atualizar placeholder baseado no tipo
        document.addEventListener('change', function(e) {
            if(e.target.classList.contains('walled-garden-tipo')) {
                const container = e.target.closest('.card-body');
                const enderecoInput = container.querySelector('.walled-garden-endereco');
                const hint = container.querySelector('.walled-garden-hint');
                const tipo = e.target.value;
                
                switch(tipo) {
                    case 'domain':
                        enderecoInput.placeholder = 'exemplo.com';
                        hint.textContent = 'Ex: exemplo.com ou cdn.exemplo.com';
                        break;
                    case 'ip':
                        enderecoInput.placeholder = '192.168.1.1';
                        hint.textContent = 'Ex: 192.168.1.1 ou 200.200.200.200';
                        break;
                    case 'subnet':
                        enderecoInput.placeholder = '192.168.1.0/24';
                        hint.textContent = 'Ex: 192.168.1.0/24 ou 10.0.0.0/8';
                        break;
                }
            }
        });

        // Botão adicionar walled garden
        document.getElementById('addWalledGarden').addEventListener('click', function() {
            const container = document.getElementById('walledGardensContainer');
            const row = createWalledGardenRow();
            container.appendChild(row);
            
            // Animar entrada
            row.style.opacity = '0';
            row.style.transform = 'translateY(-10px)';
            setTimeout(() => {
                row.style.transition = 'all 0.3s ease';
                row.style.opacity = '1';
                row.style.transform = 'translateY(0)';
            }, 10);
        });

        // Remover walled garden (delegação de evento)
        document.addEventListener('click', function(e) {
            if(e.target.closest('.remove-walled-garden')) {
                const item = e.target.closest('.walled-garden-item');
                
                // Animar saída
                item.style.transition = 'all 0.3s ease';
                item.style.opacity = '0';
                item.style.transform = 'translateX(20px)';
                
                setTimeout(() => {
                    item.remove();
                }, 300);
            }
        });

        // Carregar walled gardens existentes do banco de dados
        document.addEventListener('DOMContentLoaded', function() {
            const container = document.getElementById('walledGardensContainer');
            
            // Carregar walled gardens existentes
            @if($publicacao->walledGardens && $publicacao->walledGardens->count() > 0)
                const existingData = @json($publicacao->walledGardens->toArray());
                
                existingData.forEach(wg => {
                    const row = createWalledGardenRow(wg);
                    container.appendChild(row);
                });
            @endif
            
            // Carregar old() se houver (após validação falhada)
            @if(old('walled_gardens'))
                // Limpar existentes se há old data
                container.innerHTML = '';
                
                const oldData = @json(old('walled_gardens'));
                
                Object.values(oldData).forEach(wg => {
                    const row = createWalledGardenRow(wg);
                    container.appendChild(row);
                });
            @endif
        });

        // === CONTROLE DE CAMPOS CONDICIONAIS ===
        // Controlar exibição de campos condicionais baseado no tipo de alcance
        document.addEventListener('DOMContentLoaded', function() {
            const tipoAlcanceSelect = document.getElementById('tipo_alcance');
            const serialField = document.getElementById('serial_field');
            const grupoField = document.getElementById('empresa_field');
            
            function updateFields() {
                const value = tipoAlcanceSelect.value;
                
                // Ocultar todos primeiro
                serialField.style.display = 'none';
                grupoField.style.display = 'none';
                
                // Mostrar campo relevante
                if (value === 'serial_especifico') {
                    serialField.style.display = 'block';
                } else if (value === 'empresa') {
                    grupoField.style.display = 'block';
                }
            }
            
            // Executar ao carregar (já feito pelo PHP, mas garantir)
            updateFields();
            
            // Executar ao mudar
            tipoAlcanceSelect.addEventListener('change', updateFields);
        });

        // === PREVIEW DO CRIATIVO ===
        document.addEventListener('DOMContentLoaded', function() {
            const criativoSelect = document.getElementById('criativo_id_select');
            const previewContainer = document.getElementById('criativo-preview-container');
            
            // Função para carregar e exibir preview
            function loadCriativoPreview(criativoId) {
                if (!criativoId) {
                    previewContainer.style.display = 'none';
                    return;
                }

                fetch(`/publicacoes/criativo/${criativoId}`)
                    .then(response => {
                        if (!response.ok) throw new Error('Erro ao carregar criativo');
                        return response.json();
                    })
                    .then(data => {
                        // Preencher detalhes
                        document.getElementById('criativo-title').textContent = data.title || '-';
                        document.getElementById('criativo-type').textContent = (data.tipo || 'imagem').toUpperCase();
                        document.getElementById('criativo-empresa').textContent = data.empresa || '-';
                        document.getElementById('criativo-dimensions').textContent = `${data.width} x ${data.height}px`;
                        document.getElementById('criativo-size').textContent = data.size ? formatBytes(data.size) : '-';

                        // Exibir mídia (imagem ou vídeo)
                        const mediaContainer = document.getElementById('criativo-preview-media');
                        mediaContainer.innerHTML = '';

                        if (data.path) {
                            if (data.tipo === 'video') {
                                const video = document.createElement('video');
                                video.src = data.path;
                                video.style.maxWidth = '100%';
                                video.style.maxHeight = '300px';
                                video.controls = true;
                                mediaContainer.appendChild(video);
                            } else {
                                const img = document.createElement('img');
                                img.src = data.path;
                                img.style.maxWidth = '100%';
                                img.style.maxHeight = '300px';
                                img.style.objectFit = 'contain';
                                mediaContainer.appendChild(img);
                            }
                        } else {
                            mediaContainer.innerHTML = '<span class="text-muted">Sem arquivo disponível</span>';
                        }

                        previewContainer.style.display = 'block';
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        previewContainer.style.display = 'none';
                    });
            }

            // Converter bytes para formato legível
            function formatBytes(bytes, decimals = 2) {
                if (bytes === 0) return '0 Bytes';
                const k = 1024;
                const dm = decimals < 0 ? 0 : decimals;
                const sizes = ['Bytes', 'KB', 'MB', 'GB'];
                const i = Math.floor(Math.log(bytes) / Math.log(k));
                return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
            }

            // Carregar preview ao mudar seleção
            criativoSelect.addEventListener('change', function() {
                loadCriativoPreview(this.value);
            });

            // Carregar preview inicial se houver criativo selecionado
            if (criativoSelect.value) {
                loadCriativoPreview(criativoSelect.value);
            }
        });
    </script>
@endsection
