@extends('layouts.master')
@section('title', 'Nova Configuração Tawk.to')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-chat-circle-dots f-s-16 me-2"></i>Nova Configuração Tawk.to</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Configurações</span>
                        </a>
                    </li>
                    <li class="">
                        <a href="{{ route('tawkto.index') }}" class="f-s-14 f-w-500">Tawk.to</a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Nova Configuração</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <form action="{{ route('tawkto.store') }}" method="POST">
            @csrf

            <div class="row">
                <!-- Formulário Principal -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h5>Informações da Configuração</h5>
                        </div>
                        <div class="card-body">

                            <!-- Empresa -->
                            <div class="mb-3">
                                <label for="empresa_id" class="form-label">
                                    Empresa/Franquia <span class="text-danger">*</span>
                                </label>
                                <select class="form-select @error('empresa_id') is-invalid @enderror"
                                        id="empresa_id"
                                        name="empresa_id"
                                        required>
                                    <option value="">Selecione uma empresa...</option>

                                    @if($empresas->has('matriz'))
                                        <optgroup label="📍 Matrizes">
                                            @foreach($empresas->get('matriz') as $empresa)
                                                <option value="{{ $empresa->id }}" {{ old('empresa_id') == $empresa->id ? 'selected' : '' }}>
                                                    {{ $empresa->name }} ({{ $empresa->codigo }})
                                                </option>
                                            @endforeach
                                        </optgroup>
                                    @endif

                                    @if($empresas->has('franquia'))
                                        <optgroup label="🏢 Franquias">
                                            @foreach($empresas->get('franquia') as $empresa)
                                                <option value="{{ $empresa->id }}" {{ old('empresa_id') == $empresa->id ? 'selected' : '' }}>
                                                    {{ $empresa->name }} ({{ $empresa->codigo }})
                                                </option>
                                            @endforeach
                                        </optgroup>
                                    @endif

                                    @if($empresas->has('cliente'))
                                        <optgroup label="👥 Clientes">
                                            @foreach($empresas->get('cliente') as $empresa)
                                                <option value="{{ $empresa->id }}" {{ old('empresa_id') == $empresa->id ? 'selected' : '' }}>
                                                    {{ $empresa->name }} ({{ $empresa->codigo }})
                                                </option>
                                            @endforeach
                                        </optgroup>
                                    @endif
                                </select>
                                @error('empresa_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Selecione a empresa que terá o chat Tawk.to configurado
                                </small>
                            </div>

                            <!-- Property ID -->
                            <div class="mb-3">
                                <label for="property_id" class="form-label">
                                    Property ID <span class="text-danger">*</span>
                                    <i class="ph ph-info text-info ms-1"
                                       data-bs-toggle="tooltip"
                                       title="ID do site no Tawk.to (encontrado no código de instalação)"></i>
                                </label>
                                <input type="text"
                                       class="form-control @error('property_id') is-invalid @enderror"
                                       id="property_id"
                                       name="property_id"
                                       value="{{ old('property_id') }}"
                                       placeholder="Ex: 5e8f7a1b2c9d3e0001234567"
                                       required>
                                @error('property_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Copie do script fornecido pelo Tawk.to: https://embed.tawk.to/<strong>PROPERTY_ID</strong>/WIDGET_ID
                                </small>
                            </div>

                            <!-- Widget ID -->
                            <div class="mb-3">
                                <label for="widget_id" class="form-label">
                                    Widget ID <span class="text-danger">*</span>
                                    <i class="ph ph-info text-info ms-1"
                                       data-bs-toggle="tooltip"
                                       title="ID do widget no Tawk.to (encontrado no código de instalação)"></i>
                                </label>
                                <input type="text"
                                       class="form-control @error('widget_id') is-invalid @enderror"
                                       id="widget_id"
                                       name="widget_id"
                                       value="{{ old('widget_id') }}"
                                       placeholder="Ex: default"
                                       required>
                                @error('widget_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Copie do script fornecido pelo Tawk.to: https://embed.tawk.to/PROPERTY_ID/<strong>WIDGET_ID</strong>
                                </small>
                            </div>

                            <!-- Páginas Habilitadas -->
                            <div class="mb-3">
                                <label class="form-label">
                                    Páginas Habilitadas
                                    <i class="ph ph-info text-info ms-1"
                                       data-bs-toggle="tooltip"
                                       title="Selecione em quais páginas do hotspot o chat será exibido"></i>
                                </label>
                                <div class="border rounded p-3">
                                    @foreach($paginasDisponiveis as $key => $label)
                                        <div class="form-check">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   name="paginas_habilitadas[]"
                                                   value="{{ $key }}"
                                                   id="pagina_{{ $key }}"
                                                   {{ in_array($key, old('paginas_habilitadas', ['index','cadastro','login','welcome'])) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="pagina_{{ $key }}">
                                                <i class="ph ph-file me-1"></i>{{ $label }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                                <small class="form-text text-muted">
                                    O chat só aparecerá nas páginas selecionadas
                                </small>
                            </div>

                        </div>
                    </div>

                    <!-- Customização -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h5>Customização Visual</h5>
                        </div>
                        <div class="card-body">

                            <!-- Cor Primária -->
                            <div class="mb-3">
                                <label for="customizacao_primaryColor" class="form-label">
                                    Cor Primária do Chat
                                </label>
                                <div class="input-group">
                                    <input type="color"
                                           class="form-control form-control-color"
                                           id="customizacao_primaryColor"
                                           name="customizacao[primaryColor]"
                                           value="{{ old('customizacao.primaryColor', '#3B87C6') }}">
                                    <input type="text"
                                           class="form-control"
                                           id="customizacao_primaryColor_text"
                                           value="{{ old('customizacao.primaryColor', '#3B87C6') }}"
                                           readonly>
                                </div>
                                <small class="form-text text-muted">
                                    Cor padrão do tema FreeFi: #3B87C6
                                </small>
                            </div>

                            <!-- Posição -->
                            <div class="mb-3">
                                <label for="customizacao_position" class="form-label">
                                    Posição do Widget
                                </label>
                                <select class="form-select"
                                        id="customizacao_position"
                                        name="customizacao[position]">
                                    <option value="br" {{ old('customizacao.position', 'br') == 'br' ? 'selected' : '' }}>
                                        Inferior Direito (Padrão)
                                    </option>
                                    <option value="bl" {{ old('customizacao.position') == 'bl' ? 'selected' : '' }}>
                                        Inferior Esquerdo
                                    </option>
                                    <option value="tr" {{ old('customizacao.position') == 'tr' ? 'selected' : '' }}>
                                        Superior Direito
                                    </option>
                                    <option value="tl" {{ old('customizacao.position') == 'tl' ? 'selected' : '' }}>
                                        Superior Esquerdo
                                    </option>
                                </select>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-lg-4">
                    <!-- Status -->
                    <div class="card">
                        <div class="card-header">
                            <h5>Status e Publicação</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-check form-switch">
                                <input class="form-check-input"
                                       type="checkbox"
                                       name="ativo"
                                       id="ativo"
                                       {{ old('ativo', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="ativo">
                                    <strong>Configuração Ativa</strong>
                                </label>
                            </div>
                            <small class="form-text text-muted d-block mt-2">
                                Desative para pausar temporariamente o chat sem remover a configuração
                            </small>
                        </div>
                    </div>

                    <!-- Instruções -->
                    <div class="card mt-3">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="ph ph-info me-2"></i>Como obter os IDs</h6>
                        </div>
                        <div class="card-body">
                            <ol class="mb-0">
                                <li class="mb-2">Acesse <a href="https://www.tawk.to" target="_blank">Tawk.to</a></li>
                                <li class="mb-2">Faça login na sua conta</li>
                                <li class="mb-2">Vá em <strong>Administration</strong> → <strong>Channels</strong> → <strong>Chat Widget</strong></li>
                                <li class="mb-2">Copie o código fornecido</li>
                                <li>Extraia o PROPERTY_ID e WIDGET_ID do script</li>
                            </ol>
                        </div>
                    </div>

                    <!-- Botões de Ação -->
                    <div class="card mt-3">
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="ph ph-floppy-disk me-2"></i>Salvar Configuração
                                </button>
                                <a href="{{ route('tawkto.index') }}" class="btn btn-outline-secondary">
                                    <i class="ph ph-arrow-left me-2"></i>Cancelar
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    </div>

    @push('scripts')
    <script>
        // Sincronizar color picker com input text
        document.getElementById('customizacao_primaryColor').addEventListener('input', function() {
            document.getElementById('customizacao_primaryColor_text').value = this.value;
        });

        // Inicializar tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    </script>
    @endpush
@endsection
