@extends('layouts.master')
@section('title', 'Editar Configuração Tawk.to')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-chat-circle-dots f-s-16 me-2"></i>Editar Configuração Tawk.to</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Configurações</span>
                        </a>
                    </li>
                    <li class="">
                        <a href="{{ route('tawkto.index') }}" class="f-s-14 f-w-500">Tawk.to</a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Editar</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <form action="{{ route('tawkto.update', $tawkto) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <!-- Formulário Principal -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5>Informações da Configuração</h5>
                                <span class="badge bg-light text-dark border">
                                    <i class="ph ph-buildings me-1"></i>{{ $tawkto->empresa->name }}
                                </span>
                            </div>
                        </div>
                        <div class="card-body">

                            <!-- Empresa (readonly) -->
                            <div class="mb-3">
                                <label class="form-label">Empresa/Franquia</label>
                                <input type="text"
                                       class="form-control"
                                       value="{{ $tawkto->empresa->name }} ({{ $tawkto->empresa->codigo }})"
                                       readonly>
                                <small class="form-text text-muted">
                                    A empresa não pode ser alterada. Crie uma nova configuração se necessário.
                                </small>
                            </div>

                            <!-- Property ID -->
                            <div class="mb-3">
                                <label for="property_id" class="form-label">
                                    Property ID <span class="text-danger">*</span>
                                    <i class="ph ph-info text-info ms-1"
                                       data-bs-toggle="tooltip"
                                       title="ID do site no Tawk.to (encontrado no código de instalação)"></i>
                                </label>
                                <input type="text"
                                       class="form-control @error('property_id') is-invalid @enderror"
                                       id="property_id"
                                       name="property_id"
                                       value="{{ old('property_id', $tawkto->property_id) }}"
                                       placeholder="Ex: 5e8f7a1b2c9d3e0001234567"
                                       required>
                                @error('property_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Widget ID -->
                            <div class="mb-3">
                                <label for="widget_id" class="form-label">
                                    Widget ID <span class="text-danger">*</span>
                                    <i class="ph ph-info text-info ms-1"
                                       data-bs-toggle="tooltip"
                                       title="ID do widget no Tawk.to (encontrado no código de instalação)"></i>
                                </label>
                                <input type="text"
                                       class="form-control @error('widget_id') is-invalid @enderror"
                                       id="widget_id"
                                       name="widget_id"
                                       value="{{ old('widget_id', $tawkto->widget_id) }}"
                                       placeholder="Ex: default"
                                       required>
                                @error('widget_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Páginas Habilitadas -->
                            <div class="mb-3">
                                <label class="form-label">
                                    Páginas Habilitadas
                                    <i class="ph ph-info text-info ms-1"
                                       data-bs-toggle="tooltip"
                                       title="Selecione em quais páginas do hotspot o chat será exibido"></i>
                                </label>
                                <div class="border rounded p-3">
                                    @foreach($paginasDisponiveis as $key => $label)
                                        <div class="form-check">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   name="paginas_habilitadas[]"
                                                   value="{{ $key }}"
                                                   id="pagina_{{ $key }}"
                                                   {{ in_array($key, old('paginas_habilitadas', $tawkto->paginas_habilitadas ?? [])) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="pagina_{{ $key }}">
                                                <i class="ph ph-file me-1"></i>{{ $label }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                        </div>
                    </div>

                    <!-- Customização -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h5>Customização Visual</h5>
                        </div>
                        <div class="card-body">

                            <!-- Cor Primária -->
                            <div class="mb-3">
                                <label for="customizacao_primaryColor" class="form-label">
                                    Cor Primária do Chat
                                </label>
                                <div class="input-group">
                                    <input type="color"
                                           class="form-control form-control-color"
                                           id="customizacao_primaryColor"
                                           name="customizacao[primaryColor]"
                                           value="{{ old('customizacao.primaryColor', $tawkto->customizacao['primaryColor'] ?? '#3B87C6') }}">
                                    <input type="text"
                                           class="form-control"
                                           id="customizacao_primaryColor_text"
                                           value="{{ old('customizacao.primaryColor', $tawkto->customizacao['primaryColor'] ?? '#3B87C6') }}"
                                           readonly>
                                </div>
                            </div>

                            <!-- Posição -->
                            <div class="mb-3">
                                <label for="customizacao_position" class="form-label">
                                    Posição do Widget
                                </label>
                                <select class="form-select"
                                        id="customizacao_position"
                                        name="customizacao[position]">
                                    @php
                                        $position = old('customizacao.position', $tawkto->customizacao['position'] ?? 'br');
                                    @endphp
                                    <option value="br" {{ $position == 'br' ? 'selected' : '' }}>
                                        Inferior Direito (Padrão)
                                    </option>
                                    <option value="bl" {{ $position == 'bl' ? 'selected' : '' }}>
                                        Inferior Esquerdo
                                    </option>
                                    <option value="tr" {{ $position == 'tr' ? 'selected' : '' }}>
                                        Superior Direito
                                    </option>
                                    <option value="tl" {{ $position == 'tl' ? 'selected' : '' }}>
                                        Superior Esquerdo
                                    </option>
                                </select>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-lg-4">
                    <!-- Status -->
                    <div class="card">
                        <div class="card-header">
                            <h5>Status e Publicação</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-check form-switch">
                                <input class="form-check-input"
                                       type="checkbox"
                                       name="ativo"
                                       id="ativo"
                                       {{ old('ativo', $tawkto->ativo) ? 'checked' : '' }}>
                                <label class="form-check-label" for="ativo">
                                    <strong>Configuração Ativa</strong>
                                </label>
                            </div>
                            <small class="form-text text-muted d-block mt-2">
                                Desative para pausar temporariamente o chat sem remover a configuração
                            </small>
                        </div>
                    </div>

                    <!-- Informações -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="mb-0"><i class="ph ph-info me-2"></i>Informações</h6>
                        </div>
                        <div class="card-body">
                            <dl class="row mb-0">
                                <dt class="col-sm-5">Criado em:</dt>
                                <dd class="col-sm-7">{{ $tawkto->created_at->format('d/m/Y H:i') }}</dd>

                                <dt class="col-sm-5">Atualizado em:</dt>
                                <dd class="col-sm-7">{{ $tawkto->updated_at->format('d/m/Y H:i') }}</dd>

                                @if($tawkto->created_by)
                                <dt class="col-sm-5">Criado por:</dt>
                                <dd class="col-sm-7 mb-0">{{ $tawkto->creator->name ?? 'N/A' }}</dd>
                                @endif
                            </dl>
                        </div>
                    </div>

                    <!-- Botões de Ação -->
                    <div class="card mt-3">
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="ph ph-floppy-disk me-2"></i>Salvar Alterações
                                </button>
                                <a href="{{ route('tawkto.index') }}" class="btn btn-outline-secondary">
                                    <i class="ph ph-arrow-left me-2"></i>Voltar
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    </div>

    @push('scripts')
    <script>
        // Sincronizar color picker com input text
        document.getElementById('customizacao_primaryColor').addEventListener('input', function() {
            document.getElementById('customizacao_primaryColor_text').value = this.value;
        });

        // Inicializar tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    </script>
    @endpush
@endsection
