@extends('layouts.master')
@section('title', 'Configurações Tawk.to')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-chat-circle-dots f-s-16 me-2"></i>Configurações Tawk.to</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Configurações</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Tawk.to</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Mensagens de feedback -->
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="ph ph-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ph ph-warning-circle me-2"></i>{{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <!-- tables start  -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5>Configurações de Chat ao Vivo</h5>
                            <div class="d-flex align-items-center gap-2">
                                @can('create', App\Models\TawktoConfig::class)
                                <a href="{{ route('tawkto.create') }}" class="btn btn-primary">
                                    <i class="ph ph-plus me-1"></i>Nova Configuração
                                </a>
                                @endcan
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col">Empresa</th>
                                    <th scope="col">Property ID</th>
                                    <th scope="col">Páginas Habilitadas</th>
                                    <th scope="col" class="text-center">Status</th>
                                    <th scope="col" class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($configs as $index => $config)
                                <tr>
                                    <td class="text-center">{{ ($configs->currentPage() - 1) * $configs->perPage() + $index + 1 }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                @if($config->empresa->tipo_empresa === 'matriz')
                                                    <span class="badge bg-primary">
                                                        <i class="ph ph-crown"></i>
                                                    </span>
                                                @elseif($config->empresa->tipo_empresa === 'franquia')
                                                    <span class="badge bg-info">
                                                        <i class="ph ph-buildings"></i>
                                                    </span>
                                                @else
                                                    <span class="badge bg-secondary">
                                                        <i class="ph ph-storefront"></i>
                                                    </span>
                                                @endif
                                            </div>
                                            <div>
                                                <strong>{{ $config->empresa->name }}</strong><br>
                                                <small class="text-muted">{{ $config->empresa->codigo }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <code class="text-primary fw-bold" style="font-size: 0.85rem;">
                                            {{ Str::limit($config->property_id, 20) }}
                                        </code>
                                    </td>
                                    <td>
                                        @if($config->paginas_habilitadas && count($config->paginas_habilitadas) > 0)
                                            <div class="d-flex flex-wrap gap-1">
                                                @foreach($config->paginas_habilitadas as $pagina)
                                                    <span class="badge bg-light text-dark border">
                                                        <i class="ph ph-file me-1"></i>{{ ucfirst($pagina) }}
                                                    </span>
                                                @endforeach
                                            </div>
                                        @else
                                            <span class="text-muted">Nenhuma</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        @if($config->ativo)
                                            <span class="badge bg-success">
                                                <i class="ph ph-check-circle me-1"></i>Ativo
                                            </span>
                                        @else
                                            <span class="badge bg-danger">
                                                <i class="ph ph-x-circle me-1"></i>Inativo
                                            </span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group btn-group-sm" role="group">
                                            @can('update', $config)
                                            <a href="{{ route('tawkto.edit', $config) }}"
                                               class="btn btn-outline-primary"
                                               title="Editar">
                                                <i class="ph ph-pencil"></i>
                                            </a>
                                            @endcan

                                            @can('delete', $config)
                                            <form action="{{ route('tawkto.destroy', $config) }}"
                                                  method="POST"
                                                  class="d-inline"
                                                  onsubmit="return confirm('Tem certeza que deseja remover esta configuração?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit"
                                                        class="btn btn-outline-danger"
                                                        title="Remover">
                                                    <i class="ph ph-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center py-5">
                                        <div class="text-muted">
                                            <i class="ph ph-chat-circle-dots" style="font-size: 48px;"></i>
                                            <p class="mt-3 mb-0">Nenhuma configuração Tawk.to encontrada</p>
                                            @can('create', App\Models\TawktoConfig::class)
                                            <a href="{{ route('tawkto.create') }}" class="btn btn-sm btn-primary mt-2">
                                                <i class="ph ph-plus me-1"></i>Criar primeira configuração
                                            </a>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>

                    @if($configs->hasPages())
                    <div class="card-footer">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-muted">
                                Mostrando {{ $configs->firstItem() }} a {{ $configs->lastItem() }} de {{ $configs->total() }} registros
                            </div>
                            <div>
                                {{ $configs->links() }}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Info Card -->
        <div class="row mt-3">
            <div class="col-xl-12">
                <div class="card border-info">
                    <div class="card-body">
                        <h6 class="text-info"><i class="ph ph-info me-2"></i>Sobre o Tawk.to</h6>
                        <p class="mb-0">
                            O Tawk.to é uma plataforma de chat ao vivo gratuita que permite comunicação em tempo real
                            com os visitantes do seu hotspot. Configure para cada franquia/empresa e personalize quais
                            páginas terão o chat disponível.
                        </p>
                        <a href="https://www.tawk.to" target="_blank" class="btn btn-sm btn-outline-info mt-2">
                            <i class="ph ph-arrow-square-out me-1"></i>Acessar Tawk.to
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
