# ============================================
# FreeFi - Script de Agendamento (Scheduler)
# ============================================
# 
# PROPÓSITO:
# Agenda execução automática dos scripts FreeFi:
# - Heartbeat: a cada 5 minutos
# - Sincronização: a cada 1 hora
#
# PRÉ-REQUISITOS:
# ✅ Script 1_freefi_heartbeat.rsc importado
# ✅ Script 3_freefi_sync_publicacoes.rsc importado
#
# INSTALAÇÃO:
# 1. Importar scripts 1 e 3 ANTES deste
# 2. Copiar este arquivo para Mikrotik
# 3. Importar: /import 2_freefi_scheduler.rsc
#
# DATA: 2025-10-20
# ============================================

# ============================================
# SCHEDULER 1: Heartbeat (5 minutos)
# ============================================

/system scheduler add \
  name=freefi-heartbeat \
  interval=5m \
  start-time=startup \
  on-event="/system script run freefi_heartbeat" \
  comment="FreeFi: Envia heartbeat para API a cada 5 minutos"

:put "✅ Scheduler 'freefi-heartbeat' criado - Executa a cada 5 minutos"

# ============================================
# SCHEDULER 2: Sincronização (1 hora)
# ============================================

/system scheduler add \
  name=freefi-sync \
  interval=1h \
  start-time=startup \
  on-event="/system script run freefi_sync_publicacoes" \
  comment="FreeFi: Sincroniza publicações a cada 1 hora"

:put "✅ Scheduler 'freefi-sync' criado - Executa a cada 1 hora"

# ============================================
# EXECUTAR IMEDIATAMENTE (PRIMEIRO RUN)
# ============================================

:put "🚀 Executando heartbeat inicial..."
/system script run freefi_heartbeat
:delay 3s

:put "🚀 Executando sincronização inicial..."
/system script run freefi_sync_publicacoes
:delay 3s

# ============================================
# VALIDAÇÃO
# ============================================

:put ""
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
:put "✅ AGENDAMENTO CONFIGURADO COM SUCESSO!"
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
:put ""
:put "📋 SCHEDULERS ATIVOS:"
/system scheduler print where name~"freefi"
:put ""
:put "📋 VERIFICAR LOGS:"
:put "   /log print where topics~\"script\""
:put ""
:put "📋 EXECUTAR MANUALMENTE:"
:put "   /system script run freefi_heartbeat"
:put "   /system script run freefi_sync_publicacoes"
:put ""
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

# ============================================
# FIM DO SCRIPT
# ============================================
