# ============================================
# FreeFi - Script de Sincronização de Publicações
# ============================================
# 
# PROPÓSITO:
# Busca publicações ativas da API Laravel
# Salva JSON no Mikrotik (futuro: processar walled gardens)
#
# INSTALAÇÃO:
# 1. Copiar este arquivo via FTP/WinBox para Mikrotik
# 2. Importar: /import 3_freefi_sync_publicacoes.rsc
# 3. Ou copiar/colar direto no Terminal
#
# AGENDAMENTO:
# Executar script 2_freefi_scheduler.rsc para agendar
#
# DATA: 2025-10-20
# ============================================

/system script add name=freefi_sync_publicacoes source={
  # ============================================
  # CONFIGURAÇÕES
  # ============================================
  
  # URL base da API Laravel
  :local apiBaseUrl "https://admin.freefi.com.br/api/hotspot";
  
  # Se usar HTTP local (desenvolvimento):
  # :local apiBaseUrl "http://192.168.1.100/api/hotspot";
  
  # Serial (Identity do Mikrotik)
  :local serial [/system identity get name];
  
  # Arquivo JSON de destino
  :local jsonFile "hotspot/publicacoes.json";
  
  # ============================================
  # CRIAR DIRETÓRIO (se não existir)
  # ============================================
  
  :do {
    /file print file=hotspot/test.txt;
    /file remove "hotspot/test.txt";
  } on-error={
    :log info "FreeFi: Criando diretório /hotspot...";
  }
  
  # ============================================
  # BUSCAR PUBLICAÇÕES DA API
  # ============================================
  
  :do {
    :local fullUrl ($apiBaseUrl . "/" . $serial . "/publicacoes");
    
    /tool fetch \
      url=$fullUrl \
      http-method=get \
      dst-path=$jsonFile \
      keep-result=yes;
    
    :log info ("FreeFi: Publicações sincronizadas - Serial: " . $serial);
    :log info ("FreeFi: JSON salvo em: " . $jsonFile);
    
    # ============================================
    # PROCESSAR JSON (FUTURO)
    # ============================================
    # TODO: Parser JSON e aplicar walled gardens
    # RouterOS 7.x+ tem suporte nativo a JSON
    # Exemplo:
    # :local content [/file get $jsonFile contents];
    # :local jsonData [:deserialize from=json value=$content];
    # ... processar publicacoes ...
    
  } on-error={
    :log error "FreeFi: Erro ao sincronizar publicações. Verificar conectividade e URL da API.";
  }
}

# ============================================
# FIM DO SCRIPT
# ============================================

:put "✅ Script 'freefi_sync_publicacoes' criado com sucesso!"
:put "📋 Próximo passo: Importar script de agendamento (2_freefi_scheduler.rsc)"
