# 📡 Scripts Mikrotik RouterOS - FreeFi

Scripts prontos para atualizar Mikrotik para consumir **API Nova (Laravel)**.

---

## 📁 ARQUIVOS

| Arquivo | Descrição | Quando Executar |
|---------|-----------|----------------|
| **1_freefi_heartbeat.rsc** | Script de heartbeat (5 min) | ✅ Obrigatório - Dia 1 |
| **2_freefi_scheduler.rsc** | Agendamento automático | ✅ Obrigatório - Dia 1 |
| **3_freefi_sync_publicacoes.rsc** | Sincronização publicações (1h) | ✅ Obrigatório - Dia 1 |
| **4_freefi_remove_old.rsc** | Remover scripts antigos | ⚠️ Opcional - Após 7 dias |

---

## 🚀 INSTALAÇÃO RÁPIDA (20/10/2025)

### **Método 1: Via Terminal Mikrotik** ⭐ RECOMENDADO

```bash
# 1. Conectar SSH
ssh admin@IP_DO_MIKROTIK

# 2. Fazer backup
/export file=backup-pre-migracao-20251020

# 3. Copiar/Colar cada script no terminal (na ordem)
# (Abrir cada arquivo .rsc e copiar TODO conteúdo)

# 4. Validar
/system script print where name~"freefi"
/system scheduler print where name~"freefi"
```

### **Método 2: Via FTP/WinBox**

```bash
# 1. Upload via FTP
scp scripts/mikrotik/*.rsc admin@IP_DO_MIKROTIK:/

# 2. Conectar terminal Mikrotik
ssh admin@IP_DO_MIKROTIK

# 3. Importar (na ordem)
/import 1_freefi_heartbeat.rsc
/import 2_freefi_scheduler.rsc
/import 3_freefi_sync_publicacoes.rsc

# 4. Validar
/log print where topics~"script"
```

---

## ⚙️ CONFIGURAÇÃO (ANTES DE EXECUTAR)

### **1. Ajustar URL da API**

Editar cada script e alterar `apiUrl`:

```routeros
# PRODUÇÃO (HTTPS)
:local apiUrl "https://admin.freefi.com.br/api/hotspot/heartbeat";

# DESENVOLVIMENTO (HTTP Local)
:local apiUrl "http://192.168.1.100/api/hotspot/heartbeat";
```

### **2. Ajustar Interface VPN (se aplicável)**

No script `1_freefi_heartbeat.rsc`:

```routeros
# Se interface VPN tem OUTRO nome:
:if ([/interface find name="sua_vpn_interface"] != "") do={
  :set vpnip [/ip address get [find interface="sua_vpn_interface"] address];
}
```

### **3. Validar Serial (Identity)**

```routeros
# Verificar serial atual
/system identity print

# Ajustar se necessário
/system identity set name="HS-SHOPPING-001"
```

---

## ✅ TESTES PÓS-INSTALAÇÃO

### **1. Testar Heartbeat**

```routeros
# Executar manualmente
/system script run freefi_heartbeat

# Verificar log
/log print where message~"FreeFi"

# Esperado:
# "FreeFi: Heartbeat enviado - Serial: HS-XXX | VPN: 10.0.0.100"
```

### **2. Testar Sincronização**

```routeros
# Executar manualmente
/system script run freefi_sync_publicacoes

# Verificar arquivo JSON
/file print where name~"publicacoes.json"

# Ver conteúdo (últimas linhas)
/file get hotspot/publicacoes.json contents
```

### **3. Validar Schedulers**

```routeros
# Listar schedulers
/system scheduler print where name~"freefi"

# Esperado:
# freefi-heartbeat (interval=5m)
# freefi-sync (interval=1h)
```

### **4. Monitorar Logs em Tempo Real**

```routeros
# Abrir console de logs
/log print follow where topics~"script"

# Aguardar 5 minutos (heartbeat)
# Aguardar 1 hora (sync)
```

---

## 🔍 TROUBLESHOOTING

### **Erro: "certificate verify failed"**

**Problema:** SSL inválido

**Solução 1 - Importar Certificado CA:**
```routeros
/tool fetch url=https://letsencrypt.org/certs/lets-encrypt-r3.pem
/certificate import file-name=lets-encrypt-r3.pem passphrase=""
```

**Solução 2 - Desabilitar Verificação (⚠️ não recomendado produção):**
```routeros
# Editar script, adicionar:
/tool fetch ... check-certificate=no
```

### **Erro: "could not resolve host"**

**Problema:** DNS não resolve admin.freefi.com.br

**Solução:**
```routeros
# Adicionar DNS estático
/ip dns static add name=admin.freefi.com.br address=IP_DO_SERVIDOR

# Ou usar IP direto no script:
:local apiUrl "https://IP_DO_SERVIDOR/api/hotspot/heartbeat";
```

### **Erro: "connection timed out"**

**Problema:** Firewall bloqueando, servidor offline

**Checklist:**
```routeros
# 1. Testar ping
/ping admin.freefi.com.br count=5

# 2. Testar conectividade HTTP
/tool fetch url=https://admin.freefi.com.br mode=http check-certificate=no

# 3. Verificar firewall
/ip firewall filter print where chain="output"

# 4. Verificar rota padrão
/ip route print where dst-address=0.0.0.0/0
```

### **Sucesso mas JSON vazio**

**Problema:** Nenhuma publicação ativa para este hotspot

**Validação:**
```bash
# No Laravel
php artisan tinker
>>> \App\Models\Hotspot::where('serial', 'HS-XXX')->first()
>>> \App\Models\Publicacao::where('status', 'ativa')->get()
```

---

## 📋 CHECKLIST DE VALIDAÇÃO

### **No Mikrotik:**
- [ ] Scripts importados (3 scripts)
- [ ] Schedulers ativos (2 schedulers)
- [ ] Heartbeat executado (log "enviado")
- [ ] Sync executado (arquivo JSON criado)
- [ ] Logs sem erros críticos

### **No Laravel (Backend):**
```bash
docker exec -it freefi-admin-app bash
php artisan tinker

# Verificar heartbeat recebido
>>> \App\Models\Hotspot::where('serial', 'HS-XXX')->first()->last_activity_at
# Esperado: timestamp recente (< 5 min)

# Verificar publicações retornadas
>>> \App\Models\Publicacao::where('status', 'ativa')->count()
# Esperado: > 0
```

### **Portal Cativo:**
- [ ] Banner aparece ao conectar WiFi
- [ ] Imagem carrega (não 404)
- [ ] Clique abre link em nova aba
- [ ] Tracking registrado (banco Laravel)

---

## 🗑️ REMOVER SCRIPTS ANTIGOS (Após 7 dias)

**⚠️ Executar APENAS após confirmar que API nova funciona 100%**

```routeros
# Importar script de limpeza
/import 4_freefi_remove_old.rsc

# Aguardar 10s (pode cancelar com CTRL+C)
# Remove automaticamente scripts/schedulers antigos
```

---

## 📊 ORDEM DE EXECUÇÃO (Resumo)

```
1️⃣ /import 1_freefi_heartbeat.rsc          (Cria script heartbeat)
   ↓
2️⃣ /import 3_freefi_sync_publicacoes.rsc   (Cria script sync)
   ↓
3️⃣ /import 2_freefi_scheduler.rsc          (Agenda ambos + executa 1x)
   ↓
4️⃣ Validar logs e arquivos
   ↓
5️⃣ (Após 7 dias) /import 4_freefi_remove_old.rsc
```

---

## 📚 REFERÊNCIAS

- **MIGRACAO_MIKROTIK.md** - Guia completo migração
- **INTEGRACAO_MIKROTIK.md** - Integração Laravel ↔ Mikrotik
- **Portal Cativo:** `docs/portal-cativo-exemplo.html`

---

## 🆘 SUPORTE

**Problemas durante migração:**
- Consultar: `MIGRACAO_MIKROTIK.md` (seção Troubleshooting)
- Logs Mikrotik: `/log print where topics~"script,error"`
- Logs Laravel: `docker logs freefi-admin-app`

---

## ✅ SUCESSO!

Se tudo funcionou:
```
✅ Heartbeat enviado a cada 5 min
✅ Publicações sincronizadas a cada 1h
✅ Portal cativo mostrando banners
✅ Tracking funcionando
✅ Dashboard Laravel atualizando
```

**🎉 Mikrotik 100% integrado com API Nova!**
