<?php

use App\Models\Empresa;
use App\Models\User;
use Illuminate\Support\Facades\Storage;

test('shows preview icon for companies with logo', function () {
    $user = User::factory()->create();
    $this->actingAs($user);
    
    // Empresa com logomarca
    $empresaComLogo = Empresa::factory()->create([
        'name' => 'Empresa com Logo',
        'logomarca' => 'logos/test_logo.jpg'
    ]);
    
    // Empresa sem logomarca
    $empresaSemLogo = Empresa::factory()->create([
        'name' => 'Empresa sem Logo',
        'logomarca' => null
    ]);
    
    $response = $this->get(route('empresas.index'));
    
    $response->assertStatus(200);
    
    // Verificar se o ícone de preview aparece na coluna de ações (não mais como coluna separada)
    $response->assertSee('data-path');
    $response->assertSee('ph-eye');
    $response->assertSee('Preview Logomarca');
    
    // Verificar se as empresas aparecem na listagem
    $response->assertSee('Empresa com Logo');
    $response->assertSee('Empresa sem Logo');
    
    // Verificar que não há mais coluna separada de logomarca
    $response->assertDontSee('<th scope="col">Logomarca</th>', false);
});

test('preview modal works with logo', function () {
    $user = User::factory()->create();
    $this->actingAs($user);
    
    Storage::fake('public');
    Storage::disk('public')->put('logos/modal_test.jpg', 'fake image content');
    
    $empresa = Empresa::factory()->create([
        'name' => 'Empresa Modal Test',
        'logomarca' => 'logos/modal_test.jpg'
    ]);
    
    $response = $this->get(route('empresas.index'));
    
    $response->assertStatus(200);
    
    // Verificar se os atributos do modal estão corretos
    $response->assertSee('data-bs-toggle="modal"', false);
    $response->assertSee('data-bs-target="#mediaPreviewModal"', false);
    $response->assertSee('data-type="image"', false);
    $response->assertSee(Storage::url('logos/modal_test.jpg'));
});