<?php

namespace Tests;

use Illuminate\Foundation\Testing\TestCase as BaseTestCase;
use App\Models\User;

abstract class TestCase extends BaseTestCase
{
    /**
     * Setup the test environment.
     */
    protected function setUp(): void
    {
        parent::setUp();

        // Desabilitar verificação CSRF em testes
        $this->withoutMiddleware([
            \App\Http\Middleware\VerifyCsrfToken::class,
        ]);
    }

    /**
     * Helper: Autenticar como Super Admin
     */
    protected function actingAsSuperAdmin(): static
    {
        $admin = User::factory()->create([
            'name' => 'Test Super Admin',
            'email' => 'superadmin@test.com',
            'password' => bcrypt('password'),
            'is_superadmin' => true,
            'status_cadastro' => 'aprovado',
        ]);

        return $this->actingAs($admin);
    }

    /**
     * Helper: Autenticar como usuário aprovado
     */
    protected function actingAsApprovedUser(array $attributes = []): static
    {
        $user = User::factory()->create(array_merge([
            'status_cadastro' => 'aprovado',
        ], $attributes));

        return $this->actingAs($user);
    }

    /**
     * Helper: Criar empresa de teste
     */
    protected function createEmpresa(string $tipo = 'franquia', array $attributes = [])
    {
        return \App\Models\Empresa::factory()->create(array_merge([
            'tipo_empresa' => $tipo,
        ], $attributes));
    }
}
