# 🧪 Testes Backend

> **Localização Padrão:** `tests/backend-tests/`  
> **Organização:** Testes PHP e Shell scripts de validação

## 📁 Estrutura

```
tests/backend-tests/
├── README.md (este arquivo)
├── php/                 # Scripts PHP de teste standalone
│   ├── test-*.php      # Testes funcionais
│   ├── send-*.php      # Testes de envio (email, etc)
│   ├── run-*.php       # Executores de teste
│   └── teste_*.php     # Testes diversos
├── shell/              # Scripts Shell de automação
│   └── test-*.sh       # Scripts de teste bash
└── config/             # Configurações de teste
    └── .env.testing    # Variáveis de ambiente para testes
```

---

## 📝 Arquivos PHP (18 scripts)

### 🚀 Testes E2E (End-to-End)
- `test-e2e-registration.php` - Teste completo de registro
- `test-e2e-users-listing.php` - Teste de listagem de usuários
- `test-e2e-http-requests.php` - Teste de requisições HTTP

### 👥 Testes de Usuários
- `test-registration-flow.php` - Fluxo de registro
- `test-users-view-layout.php` - Layout da view de usuários
- `run-registration-tests.php` - Executor de testes de registro

### ✅ Testes de Aprovação
- `test-approval-system.php` - Sistema de aprovação
- `test-middleware-approval.php` - Middleware de aprovação

### 🎯 Testes de Features
- `test-feature-flags.php` - Feature flags
- `test-status-dropdown.php` - Dropdown de status
- `test-clear-filter-button.php` - Botão de limpar filtro

### 📧 Testes de Email
- `test-email-system.php` - Sistema de email completo
- `test-smtp-connection.php` - Conexão SMTP
- `send-test-email.php` - Enviar email de teste
- `send-test-email-standalone.php` - Enviar email standalone

### 📁 Testes de Upload
- `teste_upload.php` - Upload de arquivos
- `teste_upload_real.php` - Upload real (storage)

### 🛣️ Testes de Rotas
- `test-all-routes.php` - Validação de todas as rotas

---

## 🐚 Scripts Shell (2 scripts)

- `test-register.sh` - Automação de teste de registro
- `test-midias-routes.sh` - Teste de rotas de mídias

---

## ⚙️ Configuração

### .env.testing
Arquivo de ambiente dedicado para testes, contém:
- Configurações de banco de dados de teste
- Configurações de email para testes
- Variáveis específicas para ambiente de teste

**Uso:**
```bash
cp tests/backend-tests/config/.env.testing .env.testing
php artisan test --env=testing
```

---

## 🚀 Como Executar

### Testes PHP Standalone
```bash
# Exemplo: Testar sistema de email
php tests/backend-tests/php/test-email-system.php

# Exemplo: Testar upload
php tests/backend-tests/php/teste_upload_real.php
```

### Scripts Shell
```bash
# Tornar executável (se necessário)
chmod +x tests/backend-tests/shell/test-register.sh

# Executar
./tests/backend-tests/shell/test-register.sh
```

### Testes Laravel (Pest/PHPUnit)
```bash
# Executar todos os testes
php artisan test

# Executar testes específicos
php artisan test --filter=UserTest
```

---

## 📋 Categorização por Módulo

### 🏢 Sistema de Empresas
- Nenhum teste específico ainda

### 👥 Sistema de Usuários
- test-registration-flow.php
- test-users-view-layout.php
- test-e2e-users-listing.php
- run-registration-tests.php

### 📧 Sistema de Email
- test-email-system.php
- test-smtp-connection.php
- send-test-email.php
- send-test-email-standalone.php

### 📁 Sistema de Mídias
- teste_upload.php
- teste_upload_real.php
- test-midias-routes.sh

### 🚩 Feature Flags
- test-feature-flags.php

### 🔐 Sistema de Aprovação
- test-approval-system.php
- test-middleware-approval.php

### 🎨 Interface/UI
- test-status-dropdown.php
- test-clear-filter-button.php

### 🛣️ Rotas/Requisições
- test-all-routes.php
- test-e2e-http-requests.php

---

## 💡 Boas Práticas

1. **Nomenclatura:**
   - `test-*.php` para testes funcionais
   - `run-*.php` para executores de teste
   - `send-*.php` para testes de envio
   - `teste_*.php` para testes diversos (padrão PT-BR)

2. **Organização:**
   - PHP scripts em `php/`
   - Shell scripts em `shell/`
   - Configs em `config/`

3. **Execução:**
   - Sempre executar a partir da raiz do projeto
   - Usar caminhos relativos
   - Verificar `.env.testing` antes de executar

4. **Documentação:**
   - Adicionar comentários nos scripts
   - Descrever o que cada teste valida
   - Incluir exemplos de uso

---

**Última atualização:** 18/10/2025  
**Total de scripts:** 21 arquivos (18 PHP + 2 Shell + 1 config)
