#!/usr/bin/env php
<?php

/**
 * Envio de Email de Teste - FreeFi Admin
 * =======================================
 * Envia email de demonstração usando os templates implementados
 */

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;
use App\Mail\{CadastroAprovado, CadastroRejeitado, NovoCadastroPendente};
use Illuminate\Support\Facades\Mail;

echo "\n";
echo "╔═══════════════════════════════════════════════════════════╗\n";
echo "║       ENVIO DE EMAIL DE TESTE - FreeFi Admin             ║\n";
echo "╚═══════════════════════════════════════════════════════════╝\n";
echo "\n";

// Email de destino
$emailDestino = 'linuxewireless@gmail.com';

// Buscar um usuário de exemplo
$user = User::with('empresa')->first();

if (!$user) {
    echo "❌ Nenhum usuário encontrado no banco de dados!\n";
    echo "   Execute as seeders ou cadastre um usuário primeiro.\n\n";
    exit(1);
}

echo "📊 DADOS DO USUÁRIO DE EXEMPLO:\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "  Nome:    {$user->name}\n";
echo "  Email:   {$user->email}\n";
echo "  Empresa: " . ($user->empresa ? $user->empresa->name : 'N/A') . "\n";
echo "  Status:  {$user->status_cadastro}\n";
echo "\n";

echo "📧 ESCOLHA O TIPO DE EMAIL PARA ENVIAR:\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "  [1] ✅ Cadastro Aprovado (verde)\n";
echo "  [2] ❌ Cadastro Rejeitado (vermelho)\n";
echo "  [3] 🔔 Novo Cadastro Pendente (laranja)\n";
echo "  [4] 📤 Enviar TODOS os tipos\n";
echo "\n";
echo "Digite sua escolha (1-4): ";

$escolha = trim(fgets(STDIN));

echo "\n";
echo "📤 Enviando para: $emailDestino\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";

$enviados = 0;
$erros = 0;

try {
    switch ($escolha) {
        case '1':
            echo "📧 Enviando: Cadastro Aprovado...\n";
            Mail::to($emailDestino)->send(new CadastroAprovado($user));
            echo "   ✅ Enviado com sucesso!\n";
            echo "   Assunto: ✅ Cadastro Aprovado - FreeFi Admin\n";
            $enviados++;
            break;
            
        case '2':
            echo "📧 Enviando: Cadastro Rejeitado...\n";
            $motivo = "Este é um email de teste. Seus dados estão incompletos ou não foram validados.";
            Mail::to($emailDestino)->send(new CadastroRejeitado($user, $motivo));
            echo "   ✅ Enviado com sucesso!\n";
            echo "   Assunto: ❌ Cadastro Rejeitado - FreeFi Admin\n";
            echo "   Motivo incluído: Sim\n";
            $enviados++;
            break;
            
        case '3':
            echo "📧 Enviando: Novo Cadastro Pendente...\n";
            Mail::to($emailDestino)->send(new NovoCadastroPendente($user));
            echo "   ✅ Enviado com sucesso!\n";
            echo "   Assunto: 🔔 Novo Cadastro Pendente de Aprovação - FreeFi Admin\n";
            $enviados++;
            break;
            
        case '4':
            echo "📧 Enviando: Cadastro Aprovado...\n";
            Mail::to($emailDestino)->send(new CadastroAprovado($user));
            echo "   ✅ Enviado! (1/3)\n\n";
            $enviados++;
            
            sleep(2); // Pequeno delay entre envios
            
            echo "📧 Enviando: Cadastro Rejeitado...\n";
            $motivo = "Este é um email de teste. Seus dados estão incompletos ou não foram validados.";
            Mail::to($emailDestino)->send(new CadastroRejeitado($user, $motivo));
            echo "   ✅ Enviado! (2/3)\n\n";
            $enviados++;
            
            sleep(2);
            
            echo "📧 Enviando: Novo Cadastro Pendente...\n";
            Mail::to($emailDestino)->send(new NovoCadastroPendente($user));
            echo "   ✅ Enviado! (3/3)\n\n";
            $enviados++;
            break;
            
        default:
            echo "❌ Opção inválida!\n";
            exit(1);
    }
    
    echo "\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "✅ ENVIO CONCLUÍDO COM SUCESSO!\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    echo "📊 RESUMO:\n";
    echo "   • Emails enviados: $enviados\n";
    echo "   • Destinatário: $emailDestino\n";
    echo "   • Servidor SMTP: " . config('mail.mailers.smtp.host') . "\n";
    echo "   • Porta: " . config('mail.mailers.smtp.port') . "\n\n";
    
    echo "📋 PRÓXIMOS PASSOS:\n";
    echo "   1. Verifique a caixa de entrada de: $emailDestino\n";
    echo "   2. Verifique também a pasta de SPAM/Lixo Eletrônico\n";
    echo "   3. Os emails devem chegar em alguns segundos\n";
    echo "   4. Observe o design profissional com gradientes e ícones\n\n";
    
    if ($escolha == '4') {
        echo "💡 DICA:\n";
        echo "   Como você enviou os 3 tipos, compare os designs:\n";
        echo "   • Email VERDE (aprovado) - positivo e motivador\n";
        echo "   • Email VERMELHO (rejeitado) - empático com próximos passos\n";
        echo "   • Email LARANJA (pendente) - urgente para admins\n\n";
    }
    
    exit(0);
    
} catch (\Exception $e) {
    echo "\n";
    echo "❌ ERRO AO ENVIAR EMAIL!\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "Detalhes: " . $e->getMessage() . "\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
    
    echo "🔧 VERIFICAÇÕES:\n";
    echo "   • Configuração SMTP no .env está correta?\n";
    echo "   • Servidor SMTP está acessível?\n";
    echo "   • Credenciais estão corretas?\n";
    echo "   • Execute: php test-smtp-connection.php\n\n";
    
    exit(1);
}
