<?php

require __DIR__.'/vendor/autoload.php';

use Illuminate\Support\Facades\DB;

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "\n";
echo "╔══════════════════════════════════════════════════════════════════╗\n";
echo "║       TESTE - SISTEMA DE STATUS DROPDOWN (COMBO INTERATIVO)     ║\n";
echo "╚══════════════════════════════════════════════════════════════════╝\n";
echo "\n";

try {
    echo "FASE 1: Verificar View - Elementos do Dropdown\n";
    echo "══════════════════════════════════════════════════════════════════════\n";
    
    $viewPath = resource_path('views/users/index.blade.php');
    $viewContent = file_get_contents($viewPath);
    
    // Verificar badge clicável
    if (strpos($viewContent, 'onclick="toggleStatusSelect') !== false) {
        echo "✓ Badge clicável com função toggleStatusSelect()\n";
    } else {
        echo "✗ ERRO: Badge clicável não encontrado\n";
    }
    
    // Verificar select dropdown
    if (strpos($viewContent, 'status-select-{{ $user->id }}') !== false) {
        echo "✓ Select dropdown com ID dinâmico\n";
    } else {
        echo "✗ ERRO: Select dropdown não encontrado\n";
    }
    
    // Verificar ícone caret-down
    if (strpos($viewContent, 'ph-caret-down') !== false) {
        echo "✓ Ícone caret-down no badge\n";
    } else {
        echo "✗ ERRO: Ícone caret-down não encontrado\n";
    }
    
    // Verificar opções do select
    $options = ['pendente', 'aprovado', 'rejeitado'];
    foreach ($options as $option) {
        if (strpos($viewContent, "value=\"$option\"") !== false) {
            echo "✓ Opção '$option' no select\n";
        } else {
            echo "✗ ERRO: Opção '$option' não encontrada\n";
        }
    }
    
    // Verificar emojis de status
    if (strpos($viewContent, '🟡 Pendente') !== false &&
        strpos($viewContent, '🟢 Aprovado') !== false &&
        strpos($viewContent, '🔴 Rejeitado') !== false) {
        echo "✓ Emojis coloridos nas opções (🟡🟢🔴)\n";
    } else {
        echo "✗ ERRO: Emojis não encontrados\n";
    }
    
    // Verificar classe d-none (oculto inicialmente)
    if (strpos($viewContent, 'class="form-select form-select-sm status-select d-none') !== false) {
        echo "✓ Select inicialmente oculto (d-none)\n";
    } else {
        echo "✗ ERRO: Select não está oculto inicialmente\n";
    }
    
    // Verificar evento onchange
    if (strpos($viewContent, 'onchange="changeUserStatus') !== false) {
        echo "✓ Evento onchange com changeUserStatus()\n";
    } else {
        echo "✗ ERRO: Evento onchange não encontrado\n";
    }
    
    // Verificar evento onblur
    if (strpos($viewContent, 'onblur=') !== false) {
        echo "✓ Evento onblur para fechar select\n";
    } else {
        echo "✗ ERRO: Evento onblur não encontrado\n";
    }
    
    echo "\nFASE 2: Verificar JavaScript - Funções do Dropdown\n";
    echo "══════════════════════════════════════════════════════════════════════\n";
    
    // Verificar função toggleStatusSelect
    if (strpos($viewContent, 'function toggleStatusSelect(userId)') !== false) {
        echo "✓ Função toggleStatusSelect() declarada\n";
    } else {
        echo "✗ ERRO: Função toggleStatusSelect() não encontrada\n";
    }
    
    // Verificar função hideStatusSelect
    if (strpos($viewContent, 'function hideStatusSelect(userId)') !== false) {
        echo "✓ Função hideStatusSelect() declarada\n";
    } else {
        echo "✗ ERRO: Função hideStatusSelect() não encontrada\n";
    }
    
    // Verificar função changeUserStatus
    if (strpos($viewContent, 'function changeUserStatus(userId)') !== false) {
        echo "✓ Função changeUserStatus() declarada\n";
    } else {
        echo "✗ ERRO: Função changeUserStatus() não encontrada\n";
    }
    
    // Verificar lógica de confirmação
    if (strpos($viewContent, 'if (confirm(confirmMessage))') !== false) {
        echo "✓ Confirmação antes de alterar status\n";
    } else {
        echo "✗ ERRO: Confirmação não encontrada\n";
    }
    
    // Verificar submit de formulários
    if (strpos($viewContent, "document.getElementById('approve-form-'") !== false &&
        strpos($viewContent, "document.getElementById('reject-form-'") !== false) {
        echo "✓ Submit dos formulários approve/reject\n";
    } else {
        echo "✗ ERRO: Submit dos formulários não encontrado\n";
    }
    
    // Verificar fechamento ao clicar fora
    if (strpos($viewContent, "if (!event.target.closest('.status-selector'))") !== false) {
        echo "✓ Fechar select ao clicar fora\n";
    } else {
        echo "✗ ERRO: Lógica de fechar ao clicar fora não encontrada\n";
    }
    
    // Verificar ocultação de outros selects
    if (strpos($viewContent, "document.querySelectorAll('.status-select')") !== false) {
        echo "✓ Ocultar outros selects ao abrir um novo\n";
    } else {
        echo "✗ ERRO: Lógica de ocultar outros selects não encontrada\n";
    }
    
    echo "\nFASE 3: Verificar Estilos CSS\n";
    echo "══════════════════════════════════════════════════════════════════════\n";
    
    // Verificar @push('styles')
    if (strpos($viewContent, "@push('styles')") !== false) {
        echo "✓ Section @push('styles') declarada\n";
    } else {
        echo "✗ ERRO: Section @push('styles') não encontrada\n";
    }
    
    // Verificar classe .status-selector
    if (strpos($viewContent, '.status-selector') !== false) {
        echo "✓ Classe CSS .status-selector\n";
    } else {
        echo "✗ ERRO: Classe .status-selector não encontrada\n";
    }
    
    // Verificar classe .status-badge
    if (strpos($viewContent, '.status-badge') !== false) {
        echo "✓ Classe CSS .status-badge com hover\n";
    } else {
        echo "✗ ERRO: Classe .status-badge não encontrada\n";
    }
    
    // Verificar classe .status-select
    if (strpos($viewContent, '.status-select') !== false) {
        echo "✓ Classe CSS .status-select com posicionamento\n";
    } else {
        echo "✗ ERRO: Classe .status-select não encontrada\n";
    }
    
    // Verificar z-index
    if (strpos($viewContent, 'z-index: 1000') !== false) {
        echo "✓ Z-index 1000 para select (sobreposição)\n";
    } else {
        echo "✗ ERRO: Z-index não configurado\n";
    }
    
    // Verificar box-shadow
    if (strpos($viewContent, 'box-shadow') !== false) {
        echo "✓ Box-shadow no select (sombra)\n";
    } else {
        echo "✗ ERRO: Box-shadow não encontrado\n";
    }
    
    echo "\nFASE 4: Testar Funcionalidade com Usuário Real\n";
    echo "══════════════════════════════════════════════════════════════════════\n";
    
    $user = DB::table('users')->where('status_cadastro', 'pendente')->first();
    
    if ($user) {
        echo "✓ Usuário pendente encontrado: {$user->name}\n";
        echo "ℹ   → ID: {$user->id}\n";
        echo "ℹ   → Email: {$user->email}\n";
        echo "ℹ   → Status atual: {$user->status_cadastro}\n";
        
        // Simular renderização do badge
        $badgeClass = $user->status_cadastro === 'aprovado' ? 'bg-success' : 
                     ($user->status_cadastro === 'rejeitado' ? 'bg-danger' : 'bg-warning text-dark');
        $badgeIcon = $user->status_cadastro === 'aprovado' ? 'ph-check-circle' : 
                    ($user->status_cadastro === 'rejeitado' ? 'ph-x-circle' : 'ph-clock');
        
        echo "\n✓ Badge renderizado:\n";
        echo "  <span class=\"badge $badgeClass\" onclick=\"toggleStatusSelect({$user->id})\">\n";
        echo "    <i class=\"ph $badgeIcon\"></i> " . ucfirst($user->status_cadastro) . "\n";
        echo "    <i class=\"ph ph-caret-down\"></i>\n";
        echo "  </span>\n";
        
        echo "\n✓ Select renderizado:\n";
        echo "  <select id=\"status-select-{$user->id}\" class=\"d-none\" size=\"3\">\n";
        echo "    <option value=\"pendente\" " . ($user->status_cadastro === 'pendente' ? 'selected' : '') . ">🟡 Pendente</option>\n";
        echo "    <option value=\"aprovado\" " . ($user->status_cadastro === 'aprovado' ? 'selected' : '') . ">🟢 Aprovado</option>\n";
        echo "    <option value=\"rejeitado\" " . ($user->status_cadastro === 'rejeitado' ? 'selected' : '') . ">🔴 Rejeitado</option>\n";
        echo "  </select>\n";
        echo "ℹ   → Atributo size=\"3\" mostra as 3 opções diretamente!\n";
    } else {
        echo "ℹ Nenhum usuário pendente encontrado (OK - sistema funciona para todos os status)\n";
        
        $user = DB::table('users')->first();
        if ($user) {
            echo "✓ Testando com usuário: {$user->name} (status: {$user->status_cadastro})\n";
        }
    }
    
    echo "\nFASE 5: Estatísticas do Sistema\n";
    echo "══════════════════════════════════════════════════════════════════════\n";
    
    $stats = [
        'pendente' => DB::table('users')->where('status_cadastro', 'pendente')->count(),
        'aprovado' => DB::table('users')->where('status_cadastro', 'aprovado')->count(),
        'rejeitado' => DB::table('users')->where('status_cadastro', 'rejeitado')->count(),
    ];
    
    echo "✓ Estatísticas de usuários:\n";
    echo "ℹ   → 🟡 Pendentes: {$stats['pendente']}\n";
    echo "ℹ   → 🟢 Aprovados: {$stats['aprovado']}\n";
    echo "ℹ   → 🔴 Rejeitados: {$stats['rejeitado']}\n";
    echo "ℹ   → 📊 Total: " . array_sum($stats) . "\n";
    
    echo "\n";
    echo "╔══════════════════════════════════════════════════════════════════╗\n";
    echo "║                   RESUMO DO TESTE DROPDOWN                       ║\n";
    echo "╚══════════════════════════════════════════════════════════════════╝\n";
    echo "\n";
    
    echo "FUNCIONALIDADES IMPLEMENTADAS:\n";
    echo "══════════════════════════════════════════════════════════════════\n";
    echo "  ✓ Badge clicável com ícone + texto + caret-down\n";
    echo "  ✓ Select dropdown oculto inicialmente (d-none)\n";
    echo "  ✓ Função toggleStatusSelect() - mostrar/ocultar select\n";
    echo "  ✓ Função hideStatusSelect() - fechar select\n";
    echo "  ✓ Função changeUserStatus() - processar mudança\n";
    echo "  ✓ Opções com emojis coloridos (🟡🟢🔴)\n";
    echo "  ✓ Confirmação personalizada por tipo de mudança\n";
    echo "  ✓ Submit automático dos formulários approve/reject\n";
    echo "  ✓ Fechar select ao clicar fora\n";
    echo "  ✓ Ocultar outros selects ao abrir um novo\n";
    echo "  ✓ Estilos CSS com posicionamento absolute\n";
    echo "  ✓ Box-shadow e z-index para destaque\n";
    echo "  ✓ Hover effect no badge\n";
    echo "  ✓ Opacidade reduzida quando select está aberto\n";
    echo "══════════════════════════════════════════════════════════════════\n";
    echo "\n";
    
    echo "FLUXO DE INTERAÇÃO:\n";
    echo "══════════════════════════════════════════════════════════════════\n";
    echo "  1. 🖱️  Usuário clica no badge colorido\n";
    echo "  2. 📋 Select dropdown aparece abaixo do badge\n";
    echo "  3. 👁️  Badge fica com opacidade reduzida (0.5)\n";
    echo "  4. 🔽 Usuário seleciona nova opção no select\n";
    echo "  5. ⚠️  Confirmação personalizada aparece\n";
    echo "  6. ✅ Se confirmar: formulário é submetido\n";
    echo "  7. ❌ Se cancelar: select volta ao valor original\n";
    echo "  8. 🔒 Select fecha automaticamente\n";
    echo "══════════════════════════════════════════════════════════════════\n";
    echo "\n";
    
    echo "PRÓXIMOS PASSOS:\n";
    echo "══════════════════════════════════════════════════════════════════\n";
    echo "  📌 Testar manualmente em: http://localhost:8082/users\n";
    echo "  📌 Clicar no badge de um usuário pendente\n";
    echo "  📌 Verificar se select aparece/desaparece corretamente\n";
    echo "  📌 Testar mudança de status (pendente → aprovado)\n";
    echo "  📌 Verificar feedback visual (badge muda de cor)\n";
    echo "  📌 Testar em diferentes navegadores\n";
    echo "══════════════════════════════════════════════════════════════════\n";
    echo "\n";
    
} catch (\Exception $e) {
    echo "\n❌ ERRO: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
