#!/bin/bash

echo "🧪 EXECUTANDO TESTES DE REGISTRO COM CÓDIGO DE CONVITE"
echo "═══════════════════════════════════════════════════════"
echo ""

# Definir cores
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Contador de testes
PASSED=0
FAILED=0

# Função para testar
test_case() {
    echo -n "  Testing: $1... "
    if $2; then
        echo -e "${GREEN}✓ PASSED${NC}"
        ((PASSED++))
    else
        echo -e "${RED}✗ FAILED${NC}"
        ((FAILED++))
    fi
}

echo "📋 TESTES DE VALIDAÇÃO DE CÓDIGO (AJAX)"
echo "───────────────────────────────────────"

# Teste 1: Código válido
test_case "Validar código existente" \
    "docker exec freefi-admin-app php artisan tinker --execute=\"
        \\\$response = (new App\\\Http\\\Controllers\\\Auth\\\RegisterController())->validateCode(
            new Illuminate\\\Http\\\Request(['codigo' => 'VKCK959134'])
        );
        exit(\\\$response->getData()->valid ? 0 : 1);
    \""

echo ""
echo "📝 TESTES DE REGISTRO COMPLETO"
echo "───────────────────────────────"

# Teste 2: Verificar se a rota existe
test_case "Rota de registro existe" \
    "docker exec freefi-admin-app php artisan route:list | grep -q 'register'"

# Teste 3: Verificar se UserFactory está funcionando  
test_case "UserFactory cria usuário" \
    "docker exec freefi-admin-app php artisan tinker --execute=\"
        \\\$user = App\\\Models\\\User::factory()->make();
        exit(\\\$user->name ? 0 : 1);
    \""

# Teste 4: Verificar estrutura da tabela users
test_case "Tabela users tem campo status_cadastro" \
    "docker exec freefi-admin-app php artisan tinker --execute=\"
        \\\$hasColumn = Schema::hasColumn('users', 'status_cadastro');
        exit(\\\$hasColumn ? 0 : 1);
    \""

# Teste 5: Verificar estrutura da tabela empresas
test_case "Tabela empresas tem campo codigo_convite" \
    "docker exec freefi-admin-app php artisan tinker --execute=\"
        \\\$hasColumn = Schema::hasColumn('empresas', 'codigo_convite');
        exit(\\\$hasColumn ? 0 : 1);
    \""

# Teste 6: Verificar se há franquias com código
test_case "Existem franquias com código de convite" \
    "docker exec freefi-admin-app php artisan tinker --execute=\"
        \\\$count = App\\\Models\\\Empresa::whereNotNull('codigo_convite')->count();
        exit(\\\$count > 0 ? 0 : 1);
    \""

echo ""
echo "🔒 TESTES DE SEGURANÇA"
echo "─────────────────────"

# Teste 7: Verificar hash de senha
test_case "Senhas são hasheadas com bcrypt" \
    "docker exec freefi-admin-app php artisan tinker --execute=\"
        \\\$user = App\\\Models\\\User::first();
        exit(str_starts_with(\\\$user->password, '\\\$2y\\\$') ? 0 : 1);
    \""

# Teste 8: Verificar unique constraint no código
test_case "Código de convite é único" \
    "docker exec freefi-admin-app php artisan tinker --execute=\"
        use Illuminate\\\Support\\\Facades\\\Schema;
        \\\$indexes = Schema::getConnection()
            ->getDoctrineSchemaManager()
            ->listTableIndexes('empresas');
        \\\$hasUnique = false;
        foreach(\\\$indexes as \\\$index) {
            if(\\\$index->isUnique() && in_array('codigo_convite', \\\$index->getColumns())) {
                \\\$hasUnique = true;
                break;
            }
        }
        exit(\\\$hasUnique ? 0 : 1);
    \""

echo ""
echo "═══════════════════════════════════════════════════════"
echo -e "  ${GREEN}PASSED: $PASSED${NC}  ${RED}FAILED: $FAILED${NC}"
echo "═══════════════════════════════════════════════════════"

if [ $FAILED -eq 0 ]; then
    echo -e "${GREEN}✅ TODOS OS TESTES PASSARAM!${NC}"
    exit 0
else
    echo -e "${RED}❌ ALGUNS TESTES FALHARAM!${NC}"
    exit 1
fi
