# 🚀 DEPLOY IMEDIATO - COMANDOS PARA EXECUTAR

## 📋 PASSO A PASSO

### 1️⃣ CONECTAR AO SERVIDOR

```bash
ssh root@172.233.21.57
```

**Senha:** [Você tem a senha do servidor]

---

### 2️⃣ EXECUTAR DEPLOY (COPIE E COLE TUDO)

```bash
# Navegar para o diretório
cd /var/www/html/laravel/admin/freefi_admin

# Criar backup
mkdir -p backups/deploy-$(date +%Y%m%d_%H%M%S)
cp app/Providers/AppServiceProvider.php backups/deploy-$(date +%Y%m%d_%H%M%S)/ 2>/dev/null || true

# Atualizar código do GitHub
git pull origin main

# Verificar se baixou a correção
echo "Verificando correção..."
grep "Paginator::useBootstrapFive()" app/Providers/AppServiceProvider.php && echo "✅ Correção encontrada!" || echo "❌ Correção não encontrada!"

# Limpar caches
php artisan config:clear
php artisan view:clear
php artisan cache:clear

# Otimizar
php artisan config:cache
php artisan view:cache

# Reiniciar aplicação
docker-compose restart app

echo ""
echo "========================================="
echo "✅ DEPLOY CONCLUÍDO!"
echo "========================================="
echo ""
echo "Acesse: http://172.233.21.57:8082/publicacoes"
echo ""
```

---

### 3️⃣ VERIFICAR SE FUNCIONOU

Após executar os comandos acima, acesse no navegador:

**http://172.233.21.57:8082/publicacoes**

Login: `linuxewireless@gmail.com`
Senha: `password`

Verifique se aparece: **"Mostrando X a Y de Z publicações"**

---

## 🔧 SE ALGO DER ERRADO

### Problema: git pull não funciona

```bash
git fetch --all
git reset --hard origin/main
git pull origin main
```

### Problema: Comando php não encontrado

Tente usar `php8.3` ou `php8.2`:

```bash
php8.3 artisan config:clear
php8.3 artisan view:clear
php8.3 artisan cache:clear
php8.3 artisan config:cache
php8.3 artisan view:cache
```

### Problema: Docker não reinicia

```bash
docker-compose down
docker-compose up -d
```

---

## ✅ COMANDO ALTERNATIVO (UMA ÚNICA LINHA)

Se preferir executar tudo de uma vez:

```bash
cd /var/www/html/laravel/admin/freefi_admin && git pull origin main && php artisan config:clear && php artisan view:clear && php artisan cache:clear && php artisan config:cache && php artisan view:cache && docker-compose restart app && echo "✅ Deploy concluído!"
```

---

## 📊 RESULTADO ESPERADO

Depois do deploy, a paginação deve mostrar:

```
┌────────────────────────────────────────┐
│ Mostrando 1 a 4 de 4 publicações       │
└────────────────────────────────────────┘
```

Ou se houver mais de 15 publicações:

```
┌─────────────────────────────────────────────────────┐
│ Mostrando 1 a 15 de 23 publicações  [ ‹ ] [1] [2] [ › ] │
└─────────────────────────────────────────────────────┘
```

---

**Pronto! Execute os comandos no servidor e pronto! 🎉**
