# 🚀 Sistema de Feature Flags - Guia Rápido

## ⚡ Teste Rápido da Configuração

Execute o script de teste:

```bash
php test-feature-flags.php
```

Este script mostra:
- ✅ Status de todas as feature flags
- 🔍 Análise do comportamento atual
- 💡 Recomendações para seu ambiente
- 🛠️ Comandos úteis

## 📋 Cenários Comuns

### 1️⃣ Desenvolvimento Local (não enviar emails reais)

```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_DEV_MODE=true
FEATURE_EMAIL_TEST_RECIPIENT=
```

**Resultado:** Emails são apenas **logados** em `storage/logs/laravel.log`

**Ver logs:**
```bash
tail -f storage/logs/laravel.log | grep "dev mode"
```

---

### 2️⃣ Homologação (redirecionar para email de teste)

```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_DEV_MODE=false
FEATURE_EMAIL_TEST_RECIPIENT=seu_email@example.com
```

**Resultado:** Todos os emails vão para **seu_email@example.com**

---

### 3️⃣ Produção Normal

```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_DEV_MODE=false
FEATURE_EMAIL_TEST_RECIPIENT=
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=true
```

**Resultado:** Emails são **enviados normalmente** aos destinatários reais

---

### 4️⃣ Manutenção SMTP (desabilitar envio temporariamente)

```env
FEATURE_EMAIL_ENABLED=false
```

**Resultado:** **Nenhum email** é enviado ou logado (sistema continua funcionando)

---

### 5️⃣ Desabilitar Apenas Notificações de Admin

```env
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_CADASTRO_APROVADO=true
FEATURE_EMAIL_CADASTRO_REJEITADO=true
FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE=false
```

**Resultado:** Usuários recebem emails, mas **admins não são notificados** de novos cadastros

---

## 🔄 Após Alterar .env

**SEMPRE limpe o cache:**

```bash
php artisan config:clear
```

Ou reinicie o servidor se estiver usando `php artisan serve`.

---

## 📊 Tipos de Emails Controlados

| Email | Flag | Quando é Enviado |
|-------|------|------------------|
| ✅ **Cadastro Aprovado** | `FEATURE_EMAIL_CADASTRO_APROVADO` | Admin aprova usuário |
| ❌ **Cadastro Rejeitado** | `FEATURE_EMAIL_CADASTRO_REJEITADO` | Admin rejeita usuário |
| 🔔 **Novo Cadastro Pendente** | `FEATURE_EMAIL_NOVO_CADASTRO_PENDENTE` | Novo usuário se registra |

---

## 🎯 Prioridade das Flags

1. **FEATURE_EMAIL_ENABLED=false** → Bloqueia **TUDO**
2. **FEATURE_EMAIL_DEV_MODE=true** → Apenas **loga** (não envia)
3. **FEATURE_EMAIL_TEST_RECIPIENT** → **Redireciona** para email de teste
4. **Flags individuais** → Controle **granular** por tipo

---

## 🆘 Problemas Comuns

### ❓ Emails não estão sendo enviados

**Verificar:**

```bash
php test-feature-flags.php
```

**Possíveis causas:**
- ❌ `FEATURE_EMAIL_ENABLED=false`
- 🔧 `FEATURE_EMAIL_DEV_MODE=true` (apenas loga)
- 📧 Flag individual desabilitada

**Solução:**

```bash
# Habilitar envio
FEATURE_EMAIL_ENABLED=true
FEATURE_EMAIL_DEV_MODE=false

# Limpar cache
php artisan config:clear
```

---

### ❓ Emails indo para lugar errado

**Verificar:**

```bash
# Ver configuração de teste
grep FEATURE_EMAIL_TEST_RECIPIENT .env
```

**Solução:**

```bash
# Remover redirecionamento
FEATURE_EMAIL_TEST_RECIPIENT=

# Limpar cache
php artisan config:clear
```

---

### ❓ Cache não atualiza após alterar .env

**Solução:**

```bash
# Limpar todos os caches
php artisan config:clear
php artisan cache:clear

# Ou reiniciar servidor
php artisan serve
```

---

## 📖 Documentação Completa

Para mais detalhes, consulte:

- **[FEATURE-FLAGS-EMAILS.md](./FEATURE-FLAGS-EMAILS.md)** - Documentação completa
- **[test-feature-flags.php](./test-feature-flags.php)** - Script de teste

---

## 🔑 Comandos Essenciais

```bash
# Testar configuração atual
php test-feature-flags.php

# Limpar cache após alterar .env
php artisan config:clear

# Ver logs em tempo real
tail -f storage/logs/laravel.log

# Verificar config no Laravel Tinker
php artisan tinker
>>> config('features.email_enabled')
>>> config('features.dev_mode')
>>> config('features.test_recipient')
```

---

## ✅ Checklist de Implantação

### Local/Desenvolvimento
- [ ] `FEATURE_EMAIL_DEV_MODE=true`
- [ ] Verificar logs: `tail -f storage/logs/laravel.log`

### Homologação
- [ ] `FEATURE_EMAIL_DEV_MODE=false`
- [ ] `FEATURE_EMAIL_TEST_RECIPIENT=seu_email@example.com`
- [ ] Testar envio real

### Produção
- [ ] `FEATURE_EMAIL_ENABLED=true`
- [ ] `FEATURE_EMAIL_DEV_MODE=false`
- [ ] `FEATURE_EMAIL_TEST_RECIPIENT=` (vazio)
- [ ] Todas as flags individuais = `true`
- [ ] Executar `php artisan config:cache`
- [ ] Testar cadastro real

---

**Última atualização:** Janeiro 2025  
**Autor:** Sistema de Feature Flags - FreeFi Admin
