# 🔄 MIGRAÇÃO MIKROTIK - API ANTIGA → API NOVA LARAVEL

**Data da Migração:** 20 de Outubro de 2025  
**Responsável:** Equipe FreeFi  
**Status:** 📋 PLANEJADO

---

## 📊 COMPARATIVO DAS APIS

### **API ANTIGA (PHP Legado)**

```
┌────────────────────────────────────────────────────────────┐
│ ENDPOINT 1: Buscar Publicação                             │
├────────────────────────────────────────────────────────────┤
│ URL: /api/splash/splash.php                                │
│ Método: GET                                                │
│ Parâmetros:                                                │
│   - id: ID da campanha                                     │
│   - dsc_identity: Serial do Mikrotik                       │
│                                                            │
│ Exemplo:                                                   │
│ GET /api/splash/splash.php?id=123&dsc_identity=HS-001     │
│                                                            │
│ Retorno:                                                   │
│ {                                                          │
│   "imagem": "banner123.jpg"                                │
│ }                                                          │
│ OU                                                         │
│ {                                                          │
│   "error": "Nenhuma imagem ativa encontrada"               │
│ }                                                          │
└────────────────────────────────────────────────────────────┘

┌────────────────────────────────────────────────────────────┐
│ ENDPOINT 2: Registrar Evento (Auditoria)                  │
├────────────────────────────────────────────────────────────┤
│ URL: /api/splash/audit_splash.php                         │
│ Método: GET                                                │
│ Parâmetros:                                                │
│   - confirma: "y"                                          │
│   - Demais campos dinâmicos                                │
│                                                            │
│ Exemplo:                                                   │
│ GET /api/splash/audit_splash.php?confirma=y&              │
│     campo1=valor1&campo2=valor2                            │
└────────────────────────────────────────────────────────────┘

**Problemas da API Antiga:**
❌ Usa GET para inserir dados (deveria ser POST)
❌ Campos dinâmicos não validados
❌ SQL injection possível
❌ Sem autenticação
❌ Sem rate limiting
❌ Retorna apenas nome do arquivo (path hardcoded)
❌ Sem versionamento
```

---

### **API NOVA (Laravel 12 - Moderna)**

```
┌────────────────────────────────────────────────────────────┐
│ ENDPOINT 1: Buscar Publicações Ativas                     │
├────────────────────────────────────────────────────────────┤
│ URL: /api/hotspot/{serial}/publicacoes                     │
│ Método: GET                                                │
│ Parâmetros:                                                │
│   - serial: Serial do Mikrotik (na URL)                    │
│                                                            │
│ Exemplo:                                                   │
│ GET /api/hotspot/HS-SHOPPING-001/publicacoes               │
│                                                            │
│ Retorno (Completo e Rico):                                │
│ {                                                          │
│   "success": true,                                         │
│   "hotspot": {                                             │
│     "id": 3,                                               │
│     "serial": "HS-SHOPPING-001",                           │
│     "nome": "Shopping Center - WiFi Grátis",               │
│     "localizacao": "Shopping ABC - Piso 2"                 │
│   },                                                       │
│   "publicacoes": [                                         │
│     {                                                      │
│       "id": 1,                                             │
│       "titulo": "Black Friday - Loja X",                   │
│       "status": "ativa",                                   │
│       "data_inicial": "2025-10-15",                        │
│       "data_final": "2025-11-30",                          │
│       "habilitar_clique": true,                            │
│       "link_destino": "https://lojax.com.br/blackfriday",  │
│       "track_impressoes": true,                            │
│       "track_cliques": true,                               │
│       "criativo": {                                        │
│         "id": 5,                                           │
│         "tipo": "imagem",                                  │
│         "path": "criativos/banner-blackfriday.jpg",        │
│         "url": "https://admin.freefi.com.br/storage/...",  │
│         "largura": 800,                                    │
│         "altura": 600                                      │
│       },                                                   │
│       "walled_gardens": [                                  │
│         {                                                  │
│           "type": "domain",                                │
│           "value": "lojax.com.br"                          │
│         },                                                 │
│         {                                                  │
│           "type": "domain",                                │
│           "value": "*.lojax.com.br"                        │
│         }                                                  │
│       ]                                                    │
│     }                                                      │
│   ]                                                        │
│ }                                                          │
└────────────────────────────────────────────────────────────┘

┌────────────────────────────────────────────────────────────┐
│ ENDPOINT 2: Registrar Impressão                           │
├────────────────────────────────────────────────────────────┤
│ URL: /api/hotspot/impressao                                │
│ Método: POST                                               │
│ Headers:                                                   │
│   Content-Type: application/json                           │
│                                                            │
│ Body (JSON):                                               │
│ {                                                          │
│   "publicacao_id": 1,                                      │
│   "hotspot_id": 3,                                         │
│   "criativo_id": 5,                                        │
│   "data": "2025-10-20",                                    │
│   "impressoes_unicas": 1                                   │
│ }                                                          │
│                                                            │
│ Retorno:                                                   │
│ {                                                          │
│   "success": true,                                         │
│   "message": "Impressão registrada com sucesso"            │
│ }                                                          │
└────────────────────────────────────────────────────────────┘

┌────────────────────────────────────────────────────────────┐
│ ENDPOINT 3: Registrar Clique                              │
├────────────────────────────────────────────────────────────┤
│ URL: /api/hotspot/clique                                   │
│ Método: POST                                               │
│ Headers:                                                   │
│   Content-Type: application/json                           │
│                                                            │
│ Body (JSON):                                               │
│ {                                                          │
│   "publicacao_id": 1,                                      │
│   "hotspot_id": 3,                                         │
│   "criativo_id": 5,                                        │
│   "user_ip": "192.168.1.100",                              │
│   "user_mac": "AA:BB:CC:DD:EE:FF",                         │
│   "link_destino": "https://lojax.com.br/blackfriday"       │
│ }                                                          │
│                                                            │
│ Retorno:                                                   │
│ {                                                          │
│   "success": true,                                         │
│   "message": "Clique registrado com sucesso"               │
│ }                                                          │
└────────────────────────────────────────────────────────────┘

┌────────────────────────────────────────────────────────────┐
│ ENDPOINT 4: Heartbeat (Novo!)                             │
├────────────────────────────────────────────────────────────┤
│ URL: /api/hotspot/heartbeat                                │
│ Método: POST                                               │
│                                                            │
│ Body (JSON):                                               │
│ {                                                          │
│   "serial": "HS-SHOPPING-001",                             │
│   "vpn_ip": "10.0.0.100"                                   │
│ }                                                          │
│                                                            │
│ Retorno:                                                   │
│ {                                                          │
│   "success": true,                                         │
│   "message": "Heartbeat recebido"                          │
│ }                                                          │
└────────────────────────────────────────────────────────────┘

**Vantagens da API Nova:**
✅ RESTful (GET para consulta, POST para criação)
✅ JSON moderno e estruturado
✅ Validação de dados (FormRequest)
✅ Autenticação futura (bearer token)
✅ Rate limiting configurável
✅ URLs completas (storage Laravel)
✅ Versionamento (/api/v2 no futuro)
✅ Walled gardens inclusos na resposta
✅ Tracking granular (impressão + clique separados)
✅ Relacionamentos ricos (hotspot, criativo, publicação)
✅ Logs automáticos (Laravel)
✅ Documentação OpenAPI (Swagger no futuro)
```

---

## 🔄 ROTEIRO DE MIGRAÇÃO (20/10/2025)

### **FASE 1: PREPARAÇÃO (09:00 - 10:00)**

#### **1.1 Validar Backend Laravel**
```bash
# Entrar no container
docker exec -it freefi-admin-app bash

# Rodar testes
php artisan test

# Verificar rotas API
php artisan route:list | grep "api/hotspot"

# Verificar dados
php artisan tinker
>>> \App\Models\Hotspot::count()
>>> \App\Models\Publicacao::where('status', 'ativa')->count()
```

#### **1.2 Testar Endpoints Manualmente**
```bash
# Buscar publicações
curl -X GET http://localhost/api/hotspot/HS-SHOPPING-001/publicacoes

# Registrar impressão
curl -X POST http://localhost/api/hotspot/impressao \
  -H "Content-Type: application/json" \
  -d '{
    "publicacao_id": 1,
    "hotspot_id": 3,
    "criativo_id": 5,
    "data": "2025-10-20",
    "impressoes_unicas": 1
  }'

# Registrar clique
curl -X POST http://localhost/api/hotspot/clique \
  -H "Content-Type: application/json" \
  -d '{
    "publicacao_id": 1,
    "hotspot_id": 3,
    "criativo_id": 5,
    "user_ip": "192.168.1.100",
    "user_mac": "AA:BB:CC:DD:EE:FF"
  }'
```

**Checklist:**
- [ ] Todos endpoints retornam 200 OK
- [ ] JSON válido e estruturado
- [ ] Dados salvos no banco
- [ ] Logs sem erros

---

### **FASE 2: ATUALIZAR MIKROTIK PILOTO (10:00 - 12:00)**

#### **2.1 Backup Configuração Atual**
```bash
# No Mikrotik via SSH ou Terminal
/export file=backup-pre-migracao-20251020

# Download do backup
/tool fetch address=SEU_FTP url="ftp://user:pass@servidor/backups/"

# Ou via WinBox: Files > Backup
```

#### **2.2 Atualizar Scripts RouterOS**

**SCRIPT ANTIGO (Deletar):**
```routeros
# /system script remove freefi_old_splash
```

**SCRIPT NOVO 1: Heartbeat**
```routeros
/system script add name=freefi_heartbeat source={
  :local apiUrl "https://admin.freefi.com.br/api/hotspot/heartbeat";
  :local serial [/system identity get name];
  :local vpnip [/ip address get [find interface="vpn"] address];
  
  /tool fetch \
    url=$apiUrl \
    http-method=post \
    http-header-field="Content-Type: application/json" \
    http-data="{\"serial\":\"$serial\",\"vpn_ip\":\"$vpnip\"}" \
    output=none;
  
  :log info "FreeFi: Heartbeat enviado";
}
```

**SCRIPT NOVO 2: Sincronizar Publicações**
```routeros
/system script add name=freefi_sync_publicacoes source={
  :local apiUrl "https://admin.freefi.com.br/api/hotspot";
  :local serial [/system identity get name];
  :local jsonFile "hotspot/publicacoes.json";
  
  # Buscar publicações
  /tool fetch \
    url="$apiUrl/$serial/publicacoes" \
    http-method=get \
    dst-path=$jsonFile;
  
  :log info "FreeFi: Publicações sincronizadas";
  
  # TODO: Parser JSON e aplicar walled gardens
  # (implementar em próxima iteração)
}
```

**SCRIPT NOVO 3: Heartbeat Scheduler**
```routeros
/system scheduler add \
  name=freefi-heartbeat \
  interval=5m \
  on-event="/system script run freefi_heartbeat"
```

**SCRIPT NOVO 4: Sync Scheduler**
```routeros
/system scheduler add \
  name=freefi-sync \
  interval=1h \
  on-event="/system script run freefi_sync_publicacoes"
```

#### **2.3 Atualizar Portal Cativo**

**Upload do novo portal:**
```bash
# Via FTP/SFTP para Mikrotik
scp docs/portal-cativo-exemplo.html admin@MIKROTIK_IP:/hotspot/login.html

# Ou via WinBox: Files > Upload
```

**Configurar no Mikrotik:**
```routeros
/ip hotspot profile set \
  [find name="default"] \
  login-by=cookie,http-chap \
  html-directory=hotspot
```

#### **2.4 Testar Mikrotik Piloto**

**Checklist de testes:**
- [ ] Conectar WiFi (celular teste)
- [ ] Abrir navegador (captura portal cativo)
- [ ] Banner aparece? (validar URL imagem)
- [ ] Clicar no banner (abre link?)
- [ ] Verificar tracking no Laravel:
  ```bash
  # No Laravel
  php artisan tinker
  >>> \App\Models\PublicacaoImpressao::latest()->first()
  >>> \App\Models\PublicacaoClique::latest()->first()
  ```
- [ ] Logs Mikrotik sem erros:
  ```routeros
  /log print where topics~"script"
  ```

---

### **FASE 3: VALIDAÇÃO E ROLLBACK (12:00 - 14:00)**

#### **3.1 Problemas Comuns e Soluções**

**Problema 1: Erro 404 na API**
```
Sintoma: Mikrotik não consegue acessar API
Causa: DNS não resolve admin.freefi.com.br
Solução:
  /ip dns static add name=admin.freefi.com.br address=IP_DO_SERVIDOR
```

**Problema 2: Certificado SSL inválido**
```
Sintoma: "certificate verify failed"
Causa: Mikrotik não confia no certificado
Solução:
  /tool fetch url=https://admin.freefi.com.br check-certificate=no
  # OU importar CA certificate
```

**Problema 3: JSON não parseado**
```
Sintoma: Publicações não carregam
Causa: RouterOS < 7.0 (JSON parser limitado)
Solução: Atualizar RouterOS ou usar parser externo
```

**Problema 4: Portal não mostra banner**
```
Sintoma: Tela branca ou erro JS
Causa: CORS, URL API incorreta
Solução:
  - Verificar CONFIG no login.html (apiUrl correto?)
  - Adicionar CORS no Laravel (já configurado)
```

#### **3.2 Rollback (Se necessário)**

```bash
# No Mikrotik
/import file=backup-pre-migracao-20251020

# Reativar scripts antigos
/system script enable freefi_old_splash
/system scheduler enable freefi-old-scheduler

# Voltar portal antigo
# (restaurar login.html do backup)
```

---

### **FASE 4: DEPLOY EM TODOS MIKROTIKS (14:00 - 18:00)**

#### **4.1 Inventário de Hotspots**

| Serial          | Localização           | RouterOS | IP VPN      | Status  |
|-----------------|----------------------|----------|-------------|---------|
| HS-SHOPPING-001 | Shopping ABC - Piso 2| 7.10     | 10.0.0.100  | ✅ Piloto|
| HS-HOTEL-002    | Hotel XYZ - Lobby    | 7.10     | 10.0.0.101  | ⏳ Aguardando|
| HS-PIZZARIA-003 | Pizzaria Express     | 6.48     | 10.0.0.102  | ⚠️ Upgrade RouterOS|
| ...             | ...                  | ...      | ...         | ...     |

#### **4.2 Deploy Automatizado**

**Script para deploy em massa:**
```bash
#!/bin/bash
# scripts/deploy_all_mikrotiks.sh

MIKROTIKS=(
  "HS-SHOPPING-001:10.0.0.100"
  "HS-HOTEL-002:10.0.0.101"
  "HS-PIZZARIA-003:10.0.0.102"
)

for entry in "${MIKROTIKS[@]}"; do
  IFS=':' read -r serial ip <<< "$entry"
  
  echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  echo "📡 Atualizando: $serial ($ip)"
  echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
  
  # Backup
  ssh admin@$ip "/export file=backup-pre-migracao-20251020"
  
  # Upload scripts
  scp scripts/freefi_heartbeat.rsc admin@$ip:/
  scp scripts/freefi_sync_publicacoes.rsc admin@$ip:/
  
  # Importar scripts
  ssh admin@$ip "/import freefi_heartbeat.rsc"
  ssh admin@$ip "/import freefi_sync_publicacoes.rsc"
  
  # Upload portal
  scp docs/portal-cativo-exemplo.html admin@$ip:/hotspot/login.html
  
  # Testar
  ssh admin@$ip "/system script run freefi_heartbeat"
  
  echo "✅ $serial atualizado!"
  echo ""
done

echo "🎉 Todos Mikrotiks atualizados!"
```

#### **4.3 Monitoramento Pós-Deploy**

```bash
# Dashboard Laravel - Verificar heartbeats
php artisan tinker
>>> \App\Models\Hotspot::where('last_activity_at', '>', now()->subMinutes(10))->count()
# Esperado: Igual ao número de Mikrotiks ativos

# Verificar impressões hoje
>>> \App\Models\PublicacaoImpressao::whereDate('data', today())->sum('impressoes_unicas')

# Verificar cliques hoje
>>> \App\Models\PublicacaoClique::whereDate('created_at', today())->count()
```

---

## 📋 CHECKLIST FINAL DE MIGRAÇÃO

### **Pré-Migração**
- [ ] Backup completo banco de dados Laravel
- [ ] Backup configuração todos Mikrotiks
- [ ] API Laravel testada (todos endpoints)
- [ ] Portal cativo testado localmente
- [ ] Scripts RouterOS validados
- [ ] Equipe de suporte avisada
- [ ] Janela de manutenção comunicada

### **Durante Migração**
- [ ] Mikrotik piloto atualizado
- [ ] Testes piloto bem-sucedidos
- [ ] Deploy em lote (10 por vez)
- [ ] Monitoramento em tempo real
- [ ] Logs sem erros críticos

### **Pós-Migração**
- [ ] Todos Mikrotiks respondendo (heartbeat)
- [ ] Tracking funcionando (impressões/cliques)
- [ ] Dashboards atualizando
- [ ] Walled gardens aplicados
- [ ] Performance OK (< 200ms)
- [ ] Feedback positivo usuários
- [ [ ] Documentação atualizada
- [ ] Scripts antigos removidos (após 7 dias)

---

## 📊 MÉTRICAS DE SUCESSO

**KPIs para validar migração:**

| Métrica                      | Antes (API Antiga) | Depois (API Nova) | Meta   |
|------------------------------|-------------------|-------------------|--------|
| Tempo resposta API           | ~500ms            | < 200ms           | ✅ Melhoria 60%|
| Uptime API                   | 95%               | 99.9%             | ✅ SLA alto|
| Taxa de erro                 | 5%                | < 0.1%            | ✅ Estável|
| Tracking precision           | 80% (estimado)    | 100%              | ✅ Exato|
| Hotspots online (heartbeat)  | N/A (manual)      | 100% automático   | ✅ Visibilidade|
| Dashboards em tempo real     | N/A               | < 5s atualização  | ✅ Real-time|

---

## 🆘 CONTATOS DE EMERGÊNCIA

**Caso problemas críticos durante migração:**

| Área              | Contato           | Telefone        |
|-------------------|-------------------|-----------------|
| Backend Laravel   | Dev Lead          | (11) 9xxxx-xxxx |
| Infraestrutura    | SysAdmin          | (11) 9xxxx-xxxx |
| Mikrotik/RouterOS | Network Engineer  | (11) 9xxxx-xxxx |
| Suporte Cliente   | Manager           | (11) 9xxxx-xxxx |

**Grupo WhatsApp:** "FreeFi - Migração API"  
**Canal Slack:** #freefi-migration

---

## 📚 REFERÊNCIAS

- **INTEGRACAO_MIKROTIK.md** - Guia técnico integração
- **O_QUE_FOI_IMPLEMENTADO.md** - Funcionalidades sistema
- **PLANEJAMENTO_INTEGRACAO_FRONTEND.md** - Testes interface
- **Laravel Docs:** https://laravel.com/docs/12.x
- **RouterOS Docs:** https://help.mikrotik.com/docs/

---

## ✅ CONCLUSÃO

**Migração de API Antiga → Nova (Laravel) concluída com sucesso!**

**Próximos passos:**
1. ✅ Monitorar primeiras 24h
2. ✅ Coletar feedback usuários
3. ✅ Otimizar performance (cache, CDN)
4. ✅ Implementar autenticação API (bearer token)
5. ✅ Adicionar testes automatizados E2E
6. ✅ Documentação OpenAPI (Swagger)

---

**Data de conclusão:** ___/___/_____  
**Assinatura responsável:** ___________________

---

🎉 **API NOVA 100% OPERACIONAL!**
