# 🚀 Planejamento: Integração do Frontend

**Data:** 20/10/2025 (Amanhã)  
**Objetivo:** Integrar o frontend com o backend implementado  
**Status Atual:** Backend 100% funcional, Frontend criado mas não testado

---

## 📋 Checklist de Tarefas para Amanhã

### 🔧 1. Preparação do Ambiente (15 min)

- [ ] Subir containers Docker
  ```bash
  cd /var/www/html/laravel/admin/freefi_admin
  docker-compose up -d
  ```

- [ ] Aplicar migrations corrigidas
  ```bash
  docker-compose exec app php artisan migrate:fresh --seed
  ```

- [ ] Verificar se servidor está rodando
  ```bash
  # Opção 1: Apache (já configurado)
  curl http://localhost/
  
  # Opção 2: Se Apache não funcionar, usar servidor embutido
  docker-compose exec app php artisan serve --host=0.0.0.0 --port=8000
  ```

- [ ] Criar dados de teste
  ```bash
  docker-compose exec app php tests/e2e_test.php
  ```

---

### 🖥️ 2. Testes de Interface (30 min)

#### 2.1 Acessar Página de Testes
- [ ] Abrir navegador: `http://localhost/teste-interface`
- [ ] Verificar se página carrega sem erros
- [ ] Visualizar todos os cards e links

#### 2.2 Testar Formulário de Criação
- [ ] Acessar: `/publicacoes/create`
- [ ] **Teste 1:** Página carrega sem erros ✅
- [ ] **Teste 2:** Campo "Link de Destino" aparece ✅
- [ ] **Teste 3:** Toggles funcionam (habilitar clique, track impressões, track cliques) ✅
- [ ] **Teste 4:** Botão "Adicionar Domínio/IP" funciona ✅
- [ ] **Teste 5:** Cards de walled garden são criados dinamicamente ✅
- [ ] **Teste 6:** Select de tipo (domain/ip/subnet) funciona ✅
- [ ] **Teste 7:** Placeholder muda conforme tipo selecionado ✅
- [ ] **Teste 8:** Botão "X" remove walled garden com animação ✅
- [ ] **Teste 9:** Selecionar criativo funciona ✅
- [ ] **Teste 10:** Preview de criativo carrega via AJAX ✅

**Possíveis Problemas:**
- ❌ Preview não carrega → Verificar rota `/publicacoes/criativo/{id}` no controller
- ❌ JavaScript não funciona → Verificar console do navegador (F12)
- ❌ Campos não aparecem → Verificar se migration foi aplicada

---

#### 2.3 Testar Formulário de Edição
- [ ] Criar publicação de teste primeiro
- [ ] Acessar: `/publicacoes/1/edit`
- [ ] **Teste 1:** Walled gardens existentes são carregados ✅
- [ ] **Teste 2:** Pode adicionar novos walled gardens ✅
- [ ] **Teste 3:** Pode remover walled gardens existentes ✅
- [ ] **Teste 4:** Toggle "ativo" funciona individualmente ✅
- [ ] **Teste 5:** Input hidden com ID é criado para existentes ✅
- [ ] **Teste 6:** Salvar atualiza corretamente no banco ✅

**Possíveis Problemas:**
- ❌ Walled gardens não carregam → Verificar relacionamento no model Publicacao
- ❌ Erro ao salvar → Verificar método `update` no PublicacaoController

---

### 📊 3. Testes de Dashboards e Gráficos (45 min)

#### 3.1 Dashboard Geral
- [ ] Acessar: `/estatisticas/dashboard`
- [ ] **Teste 1:** 6 cards de KPI aparecem ✅
- [ ] **Teste 2:** Números estão corretos (conferir com banco) ✅
- [ ] **Teste 3:** Filtro de data funciona ✅
- [ ] **Teste 4:** Filtro de franquia funciona ✅
- [ ] **Teste 5:** Gráfico de evolução temporal renderiza (Chart.js) ✅
- [ ] **Teste 6:** Gráfico de distribuição (donut) renderiza ✅
- [ ] **Teste 7:** Top 10 publicações aparece ✅
- [ ] **Teste 8:** Top 10 hotspots aparece ✅
- [ ] **Teste 9:** Medalhas 🥇🥈🥉 aparecem ✅
- [ ] **Teste 10:** Tooltips funcionam no hover ✅

**Possíveis Problemas:**
- ❌ Gráficos não aparecem → Verificar se Chart.js CDN carregou
- ❌ Dados vazios → Executar script E2E para criar dados de teste
- ❌ Erro 500 → Verificar método `dashboard()` no EstatisticasController

---

#### 3.2 Relatório por Publicação
- [ ] Acessar: `/estatisticas/por-publicacao`
- [ ] **Teste 1:** Tabela carrega sem erros ✅
- [ ] **Teste 2:** 10 colunas aparecem ✅
- [ ] **Teste 3:** Badges de status funcionam ✅
- [ ] **Teste 4:** Badges de performance (CTR) funcionam ✅
- [ ] **Teste 5:** Cores corretas (verde >=5%, amarelo >=2%, cinza <2%) ✅
- [ ] **Teste 6:** Rodapé com totais aparece ✅
- [ ] **Teste 7:** Somas estão corretas ✅

**Possíveis Problemas:**
- ❌ CTR incorreto → Verificar cálculo no controller
- ❌ Badges erradas → Verificar condições no blade

---

#### 3.3 Relatório por Hotspot
- [ ] Acessar: `/estatisticas/por-hotspot`
- [ ] **Teste 1:** 3 cards resumo aparecem ✅
- [ ] **Teste 2:** Tabela carrega sem erros ✅
- [ ] **Teste 3:** Badges de performance aparecem ✅
- [ ] **Teste 4:** Status online/offline correto ✅

**Possíveis Problemas:**
- ❌ Status incorreto → Verificar campo `last_activity_at` no banco

---

#### 3.4 Estatísticas da Publicação
- [ ] Acessar: `/publicacoes/1/estatisticas`
- [ ] **Teste 1:** 4 cards KPI aparecem ✅
- [ ] **Teste 2:** Gráfico de impressões/cliques (linha) renderiza ✅
- [ ] **Teste 3:** Gráfico de cliques por hora (barra) renderiza ✅
- [ ] **Teste 4:** Top 10 hotspots aparece com medalhas ✅
- [ ] **Teste 5:** Dados diários (7 dias) aparecem ✅
- [ ] **Teste 6:** Cards de walled gardens aparecem ✅
- [ ] **Teste 7:** Ícones diferenciados por tipo (domain/ip/subnet) ✅

**Possíveis Problemas:**
- ❌ Gráficos não renderizam → Verificar dados retornados pelo controller
- ❌ Walled gardens não aparecem → Verificar relacionamento `walledGardens()`

---

### 🔌 4. Testes de API (30 min)

#### 4.1 Testar Endpoints Manualmente

**Preparação:**
```bash
# Entrar no container
docker-compose exec app bash

# Criar script de teste
cat > /tmp/test_api.sh << 'SCRIPT'
#!/bin/bash

echo "🧪 Testando API do FreeFi Admin"
echo ""

# 1. Heartbeat
echo "1️⃣ POST /api/hotspot/heartbeat"
curl -X POST http://localhost/api/hotspot/heartbeat \
  -H "Content-Type: application/json" \
  -d '{"serial":"E2E-TEST-001","vpn_ip":"10.0.0.200"}' \
  -s | jq
echo ""

# 2. Buscar Publicações
echo "2️⃣ GET /api/hotspot/E2E-TEST-001/publicacoes"
curl -X GET http://localhost/api/hotspot/E2E-TEST-001/publicacoes \
  -s | jq
echo ""

# 3. Buscar Walled Gardens
echo "3️⃣ GET /api/hotspot/publicacao/1/walled-gardens"
curl -X GET http://localhost/api/hotspot/publicacao/1/walled-gardens \
  -s | jq
echo ""

# 4. Registrar Impressão
echo "4️⃣ POST /api/hotspot/impressao"
curl -X POST http://localhost/api/hotspot/impressao \
  -H "Content-Type: application/json" \
  -d '{
    "publicacao_id": 1,
    "hotspot_id": 3,
    "criativo_id": 1,
    "data": "2025-10-20",
    "impressoes_unicas": 10
  }' \
  -s | jq
echo ""

# 5. Registrar Clique
echo "5️⃣ POST /api/hotspot/clique"
curl -X POST http://localhost/api/hotspot/clique \
  -H "Content-Type: application/json" \
  -d '{
    "publicacao_id": 1,
    "hotspot_id": 3,
    "criativo_id": 1,
    "user_ip": "192.168.1.100",
    "user_mac": "AA:BB:CC:DD:EE:FF"
  }' \
  -s | jq
echo ""

echo "✅ Testes de API concluídos!"
SCRIPT

chmod +x /tmp/test_api.sh
/tmp/test_api.sh
```

**Checklist:**
- [ ] **Endpoint 1:** Heartbeat retorna sucesso ✅
- [ ] **Endpoint 2:** Buscar publicações retorna array ✅
- [ ] **Endpoint 3:** Buscar walled gardens retorna array ✅
- [ ] **Endpoint 4:** Registrar impressão retorna sucesso ✅
- [ ] **Endpoint 5:** Registrar clique retorna ID ✅

**Possíveis Problemas:**
- ❌ 404 Not Found → Verificar se rotas estão em `routes/api.php`
- ❌ 500 Internal Error → Verificar logs: `docker-compose exec app tail -f storage/logs/laravel.log`
- ❌ JSON inválido → Verificar retorno dos controllers

---

### 🐛 5. Resolução de Problemas Comuns

#### Problema 1: Página em Branco
```bash
# Verificar logs de erro
docker-compose exec app tail -n 50 storage/logs/laravel.log

# Limpar cache
docker-compose exec app php artisan cache:clear
docker-compose exec app php artisan config:clear
docker-compose exec app php artisan view:clear
```

#### Problema 2: Gráficos Não Aparecem
```javascript
// Abrir console do navegador (F12) e verificar:
// 1. Se Chart.js carregou
console.log(typeof Chart); // deve retornar "function"

// 2. Se dados estão chegando
console.log(impressoesData);
console.log(cliquesData);

// 3. Se canvas existe
console.log(document.getElementById('chartId'));
```

#### Problema 3: Walled Gardens Não Funcionam
```bash
# Verificar se tabela existe
docker-compose exec app php artisan tinker
>>> Schema::hasTable('walled_gardens');
>>> App\Models\WalledGarden::count();

# Verificar relacionamento
>>> $pub = App\Models\Publicacao::first();
>>> $pub->walledGardens()->count();
```

#### Problema 4: Preview de Criativo Não Carrega
```bash
# Verificar rota
docker-compose exec app php artisan route:list | grep criativo

# Testar endpoint
curl http://localhost/publicacoes/criativo/1
```

---

### 📝 6. Documentar Problemas Encontrados

**Template para reportar problemas:**

```markdown
## Problema: [Título]

**Onde:** [URL ou arquivo]
**O que aconteceu:** [Descrição do erro]
**Erro exibido:** [Mensagem de erro ou screenshot]

**Tentativas de solução:**
1. [O que você tentou]
2. [Resultado]

**Logs relevantes:**
```
[Cole aqui logs do Laravel ou console do navegador]
```

**Status:** [ ] Resolvido / [ ] Pendente
```

---

### ✅ 7. Checklist Final do Dia

Ao final dos testes, marque:

- [ ] Todas as views carregam sem erro
- [ ] Formulários salvam dados corretamente
- [ ] Gráficos Chart.js renderizam
- [ ] Walled gardens dinâmicos funcionam
- [ ] API retorna dados corretamente
- [ ] Documentei todos os problemas encontrados
- [ ] Criei lista de melhorias para o futuro

---

## 🎯 Objetivos de Sucesso

### Mínimo Viável (Deve Funcionar)
- ✅ Página de teste carrega
- ✅ Pelo menos 1 formulário funciona (criar ou editar)
- ✅ Pelo menos 1 dashboard funciona
- ✅ Dados aparecem corretamente

### Ideal (Tudo Funcionando)
- ✅ Todos os formulários funcionam
- ✅ Todos os dashboards renderizam
- ✅ Gráficos aparecem
- ✅ Walled gardens dinâmicos funcionam
- ✅ API responde corretamente

### Bônus (Se Der Tempo)
- ✅ Melhorar UX (animações, validações)
- ✅ Adicionar mais dados de teste
- ✅ Testar em mobile/tablet
- ✅ Exportar relatórios (PDF/Excel)

---

## 📚 Recursos Disponíveis

### Documentação
1. **O_QUE_FOI_IMPLEMENTADO.md** - Entender o que foi feito
2. **TESTES.md** - Guia de testes completo
3. **teste-interface.blade.php** - Página centralizada de testes

### Comandos Úteis
```bash
# Ver logs em tempo real
docker-compose exec app tail -f storage/logs/laravel.log

# Acessar Tinker (console Laravel)
docker-compose exec app php artisan tinker

# Executar testes E2E
docker-compose exec app php tests/e2e_test.php

# Listar rotas
docker-compose exec app php artisan route:list

# Limpar cache
docker-compose exec app php artisan cache:clear

# Ver estrutura do banco
docker-compose exec app php artisan tinker
>>> Schema::getColumnListing('publicacoes');
```

### Console do Navegador (F12)
```javascript
// Verificar erros JavaScript
console.log('Teste');

// Ver dados de gráficos
console.log(chartData);

// Verificar se Chart.js carregou
console.log(typeof Chart);

// Verificar elementos da página
console.log(document.querySelectorAll('.feature-card').length);
```

---

## 🚀 Fluxo Sugerido para Amanhã

```
08:00 - 08:15  → Subir ambiente, aplicar migrations
08:15 - 08:45  → Testar formulários (criar/editar)
08:45 - 09:30  → Testar dashboards e gráficos
09:30 - 10:00  → Testar API com curl/Postman
10:00 - 10:15  → ☕ Pausa
10:15 - 11:00  → Corrigir problemas encontrados
11:00 - 11:30  → Documentar e criar lista de melhorias
11:30 - 12:00  → Teste final completo (E2E manual)
```

---

## 📞 Suporte

Se encontrar problemas durante os testes:

1. **Verificar logs:** `storage/logs/laravel.log`
2. **Console do navegador:** F12 → Console
3. **Tinker:** `php artisan tinker` para testar models
4. **Documentação:** Consultar arquivos .md criados

---

## 💾 Backup Antes de Começar

```bash
# Fazer backup do banco de dados
docker-compose exec db mysqldump -u root -p adm_freefi > backup_$(date +%Y%m%d).sql

# Fazer backup do código (já está no Git, mas por segurança)
tar -czf freefi_admin_backup_$(date +%Y%m%d).tar.gz \
  --exclude='vendor' \
  --exclude='node_modules' \
  --exclude='storage/logs' \
  /var/www/html/laravel/admin/freefi_admin/
```

---

## 🎉 Resultado Esperado

Ao final de amanhã, você terá:

✅ Sistema testado e funcionando  
✅ Lista de problemas (se houver) documentados  
✅ Interface validada e pronta para uso  
✅ Dados de demonstração criados  
✅ Confiança para apresentar aos clientes  

---

**Boa sorte nos testes de amanhã! 🚀**

**Última atualização:** 19/10/2025  
**Próxima sessão:** 20/10/2025
