# 🚀 ROTEIRO RÁPIDO - MIGRAÇÃO API (20/10/2025)

**Tempo estimado:** 4-6 horas  
**Equipe:** Dev + SysAdmin + Network

---

## ⏰ CRONOGRAMA

```
09:00 - 10:00 ▶️  FASE 1: Validar Backend Laravel
10:00 - 12:00 ▶️  FASE 2: Atualizar Mikrotik Piloto
12:00 - 14:00 ▶️  ALMOÇO + Validação
14:00 - 16:00 ▶️  FASE 3: Deploy em Massa
16:00 - 18:00 ▶️  FASE 4: Monitoramento + Ajustes
```

---

## ✅ FASE 1: VALIDAR BACKEND (09:00 - 10:00)

### **1.1 Testar Endpoints API**

```bash
cd /var/www/html/laravel/admin/freefi_admin

# Executar script de testes
./scripts/test_mikrotik_integration.sh

# OU testes manuais:
curl http://localhost/api/hotspot/HS-SHOPPING-001/publicacoes
curl -X POST http://localhost/api/hotspot/heartbeat \
  -H "Content-Type: application/json" \
  -d '{"serial":"HS-001","vpn_ip":"10.0.0.100"}'
```

**Esperado:**
- [ ] Status 200 OK
- [ ] JSON válido
- [ ] Dados salvos no banco

### **1.2 Testar Interface Web**

```bash
# Abrir navegador
http://localhost/publicacoes

# Criar publicação teste
http://localhost/publicacoes/create
```

**Checklist:**
- [ ] Formulário carrega
- [ ] Upload de imagem OK
- [ ] Walled gardens salvos
- [ ] Dashboard mostra dados

---

## ✅ FASE 2: MIKROTIK PILOTO (10:00 - 12:00)

### **2.1 Escolher Hotspot Piloto**

**Critérios:**
- ✅ Baixo tráfego (para testar sem impacto)
- ✅ Acesso físico (caso problemas)
- ✅ RouterOS 7.x+ (suporte JSON)

**Sugestão:** `HS-SHOPPING-001`

### **2.2 Backup**

```routeros
# Conectar SSH
ssh admin@IP_MIKROTIK_PILOTO

# Fazer backup
/export file=backup-pre-migracao-20251020

# Download backup (caso necessário restaurar)
```

### **2.3 Instalar Scripts**

**Opção A - Terminal (⭐ Recomendado):**

```routeros
# 1. Abrir arquivos .rsc no VS Code
# 2. Copiar TODO conteúdo
# 3. Colar no terminal Mikrotik (um por vez)

# Ordem:
1. scripts/mikrotik/1_freefi_heartbeat.rsc
2. scripts/mikrotik/3_freefi_sync_publicacoes.rsc
3. scripts/mikrotik/2_freefi_scheduler.rsc
```

**Opção B - FTP:**

```bash
# Upload scripts
scp scripts/mikrotik/*.rsc admin@IP_MIKROTIK:/

# Importar
ssh admin@IP_MIKROTIK
/import 1_freefi_heartbeat.rsc
/import 3_freefi_sync_publicacoes.rsc
/import 2_freefi_scheduler.rsc
```

### **2.4 Validar**

```routeros
# Ver scripts
/system script print where name~"freefi"

# Ver schedulers
/system scheduler print where name~"freefi"

# Ver logs
/log print where message~"FreeFi"

# Executar manualmente
/system script run freefi_heartbeat
/system script run freefi_sync_publicacoes

# Verificar arquivo JSON
/file print where name~"publicacoes"
```

### **2.5 Atualizar Portal Cativo**

```bash
# Upload portal
scp docs/portal-cativo-exemplo.html admin@IP_MIKROTIK:/hotspot/login.html

# OU via WinBox: Files > Upload
```

**Configurar no Mikrotik:**

```routeros
/ip hotspot profile set [find name="default"] html-directory=hotspot
```

### **2.6 Testar Conexão WiFi**

1. Conectar celular no WiFi
2. Abrir navegador (deve capturar portal)
3. **Verificar:**
   - [ ] Banner aparece?
   - [ ] Imagem carrega?
   - [ ] Clique funciona?

4. **No Laravel, verificar tracking:**
   ```bash
   php artisan tinker
   >>> \App\Models\PublicacaoImpressao::latest()->first()
   >>> \App\Models\PublicacaoClique::latest()->first()
   ```

---

## ✅ FASE 3: DEPLOY EM MASSA (14:00 - 16:00)

### **3.1 Listar Hotspots**

```bash
# Ver todos hotspots cadastrados
php artisan tinker
>>> \App\Models\Hotspot::all()->pluck('serial', 'id')
```

### **3.2 Deploy Automatizado** (Opcional)

```bash
# Editar lista de IPs
nano scripts/deploy_all_mikrotiks.sh

# Executar
./scripts/deploy_all_mikrotiks.sh
```

### **3.3 Deploy Manual** (Mais seguro)

Para cada Mikrotik:

```bash
# 1. Backup
ssh admin@IP /export file=backup-20251020

# 2. Upload scripts
scp scripts/mikrotik/*.rsc admin@IP:/

# 3. Importar
ssh admin@IP
/import 1_freefi_heartbeat.rsc
/import 3_freefi_sync_publicacoes.rsc
/import 2_freefi_scheduler.rsc

# 4. Upload portal
exit
scp docs/portal-cativo-exemplo.html admin@IP:/hotspot/login.html

# 5. Validar logs
ssh admin@IP
/log print where message~"FreeFi"
```

**Fazer em lotes de 5-10 por vez.**

---

## ✅ FASE 4: MONITORAMENTO (16:00 - 18:00)

### **4.1 Dashboard Laravel**

```bash
# Abrir navegador
http://localhost/dashboard

# Verificar:
- Todos hotspots online? (heartbeat < 10 min)
- Impressões sendo registradas?
- Cliques funcionando?
```

### **4.2 Logs Centralizados**

```bash
# Logs Laravel
docker logs -f freefi-admin-app

# Filtrar erros
docker logs freefi-admin-app | grep ERROR

# Ver últimas requisições API
tail -f storage/logs/laravel.log
```

### **4.3 Validação SQL**

```bash
php artisan tinker

# Hotspots online (heartbeat recente)
>>> \App\Models\Hotspot::where('last_activity_at', '>', now()->subMinutes(10))->count()

# Impressões hoje
>>> \App\Models\PublicacaoImpressao::whereDate('data', today())->sum('impressoes_unicas')

# Cliques hoje
>>> \App\Models\PublicacaoClique::whereDate('created_at', today())->count()

# Publicações ativas
>>> \App\Models\Publicacao::where('status', 'ativa')->count()
```

---

## 🆘 PROBLEMAS COMUNS

### **1. Erro 404 na API**

```bash
# Verificar Apache/Nginx
docker exec -it freefi-admin-app bash
cat /etc/nginx/sites-enabled/default

# Testar dentro do container
curl http://localhost/api/hotspot/HS-001/publicacoes
```

### **2. Certificado SSL Inválido**

```routeros
# No Mikrotik, desabilitar validação (temporário)
/tool fetch ... check-certificate=no

# OU importar CA certificate
/tool fetch url=https://letsencrypt.org/certs/lets-encrypt-r3.pem
/certificate import file-name=lets-encrypt-r3.pem
```

### **3. JSON não Carrega no Portal**

```javascript
// Abrir DevTools navegador (F12)
// Ver erros console
// Verificar Network > XHR

// Possíveis causas:
// - CORS (já configurado Laravel)
// - URL API errada (verificar CONFIG no login.html)
// - Firewall bloqueando
```

### **4. Tracking Não Funciona**

```bash
# Verificar se middleware CORS está ativo
php artisan route:list | grep hotspot

# Testar tracking manualmente
curl -X POST http://localhost/api/hotspot/impressao \
  -H "Content-Type: application/json" \
  -d '{"publicacao_id":1,"hotspot_id":3,"criativo_id":5,"data":"2025-10-20"}'

# Ver banco de dados
php artisan tinker
>>> \App\Models\PublicacaoImpressao::latest()->first()
```

---

## 📋 CHECKLIST FINAL

### **Backend Laravel:**
- [ ] API /publicacoes retorna 200
- [ ] API /heartbeat retorna 200
- [ ] API /impressao retorna 200
- [ ] API /clique retorna 200
- [ ] Dashboard carrega
- [ ] Gráficos funcionam

### **Mikrotik Piloto:**
- [ ] Scripts instalados (3)
- [ ] Schedulers ativos (2)
- [ ] Heartbeat enviado (log)
- [ ] JSON sincronizado (arquivo)
- [ ] Portal cativo atualizado
- [ ] WiFi testado (conexão OK)

### **Tracking:**
- [ ] Impressão registrada (banco)
- [ ] Clique registrado (banco)
- [ ] Dashboard atualizado

### **Todos Mikrotiks:**
- [ ] Scripts instalados
- [ ] Heartbeats recentes (< 10 min)
- [ ] Sem erros críticos logs

---

## 🎉 SUCESSO!

**Se tudo funcionou:**

```
✅ API Nova 100% operacional
✅ Todos Mikrotiks sincronizados
✅ Tracking em tempo real
✅ Dashboards atualizando
✅ Portal cativo modernizado
```

**Próximos passos (próximos dias):**
1. Monitorar 24h
2. Coletar feedback
3. Remover scripts antigos (após 7 dias)
4. Otimizações (cache, CDN)

---

## 📚 DOCUMENTAÇÃO COMPLETA

- **MIGRACAO_MIKROTIK.md** - Guia detalhado 100+ páginas
- **scripts/mikrotik/README.md** - Instalação scripts
- **INTEGRACAO_MIKROTIK.md** - Arquitetura integração
- **PLANEJAMENTO_INTEGRACAO_FRONTEND.md** - Testes interface

---

**🚀 Boa migração! Qualquer problema, consultar documentação ou escalar para equipe.**
